/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.text.HTMLPrinter;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class CAnnotationHover
implements IAnnotationHover {
    protected int compareRulerLine(Position position, IDocument iDocument, int n) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                int n2 = iDocument.getLineOfOffset(position.getOffset());
                if (n == n2) {
                    return 1;
                }
                if (n2 <= n && n <= iDocument.getLineOfOffset(position.getOffset() + position.getLength())) {
                    return 2;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return 0;
    }

    protected List select(List list, List list2) {
        return list;
    }

    protected List getMarkersForLine(ISourceViewer iSourceViewer, int n) {
        IDocument iDocument = iSourceViewer.getDocument();
        IAnnotationModel iAnnotationModel = iSourceViewer.getAnnotationModel();
        if (iAnnotationModel == null) {
            return null;
        }
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        ArrayList<IMarker> arrayList2 = new ArrayList<IMarker>();
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof MarkerAnnotation)) continue;
            MarkerAnnotation markerAnnotation = (MarkerAnnotation)e;
            switch (this.compareRulerLine(iAnnotationModel.getPosition((Annotation)markerAnnotation), iDocument, n)) {
                case 1: {
                    arrayList.add(markerAnnotation.getMarker());
                    break;
                }
                case 2: {
                    arrayList2.add(markerAnnotation.getMarker());
                }
            }
        }
        return this.select(arrayList, arrayList2);
    }

    public String getHoverInfo(ISourceViewer iSourceViewer, int n) {
        List list = this.getMarkersForLine(iSourceViewer, n);
        if (list != null && list.size() > 0) {
            if (list.size() == 1) {
                IMarker iMarker = (IMarker)list.get(0);
                String string = iMarker.getAttribute("message", null);
                if (string != null && string.trim().length() > 0) {
                    return this.formatSingleMessage(string);
                }
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    IMarker iMarker = (IMarker)iterator.next();
                    String string = iMarker.getAttribute("message", null);
                    if (string == null || string.trim().length() <= 0) continue;
                    arrayList.add(string.trim());
                }
                if (arrayList.size() == 1) {
                    return this.formatSingleMessage((String)arrayList.get(0));
                }
                if (arrayList.size() > 1) {
                    return this.formatMultipleMessages(arrayList);
                }
            }
        }
        return null;
    }

    private int getHoverWidth(Display display) {
        Rectangle rectangle = display.getBounds();
        int n = rectangle.width - (display.getCursorLocation().x - rectangle.x);
        if ((n -= 12) < 200) {
            n = 200;
        }
        return n;
    }

    private String formatSingleMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        HTMLPrinter.addPageProlog(stringBuffer);
        HTMLPrinter.addParagraph(stringBuffer, HTMLPrinter.convertToHTMLContent(string));
        HTMLPrinter.addPageEpilog(stringBuffer);
        return stringBuffer.toString();
    }

    private String formatMultipleMessages(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        HTMLPrinter.addPageProlog(stringBuffer);
        HTMLPrinter.addParagraph(stringBuffer, HTMLPrinter.convertToHTMLContent(CUIMessages.getString("CAnnotationHover.multipleMarkers")));
        HTMLPrinter.startBulletList(stringBuffer);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HTMLPrinter.addBullet(stringBuffer, HTMLPrinter.convertToHTMLContent((String)iterator.next()));
        }
        HTMLPrinter.endBulletList(stringBuffer);
        HTMLPrinter.addPageEpilog(stringBuffer);
        return stringBuffer.toString();
    }
}

