/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;

public class CAutoIndentStrategy
extends DefaultAutoIndentStrategy {
    protected int findMatchingOpenBracket(IDocument iDocument, int n, int n2, int n3) throws BadLocationException {
        int n4 = iDocument.getLineOffset(n);
        int n5 = this.getBracketCount(iDocument, n4, n2, false) - n3;
        while (n5 < 0) {
            if (--n < 0) {
                return -1;
            }
            n4 = iDocument.getLineOffset(n);
            n2 = n4 + iDocument.getLineLength(n) - 1;
            n5 += this.getBracketCount(iDocument, n4, n2, false);
        }
        return n;
    }

    private int getBracketCount(IDocument iDocument, int n, int n2, boolean bl) throws BadLocationException {
        int n3 = 0;
        block7: while (n < n2) {
            char c = iDocument.getChar(n);
            ++n;
            switch (c) {
                case '/': {
                    if (n >= n2) break;
                    char c2 = iDocument.getChar(n);
                    if (c2 == '*') {
                        n = this.getCommentEnd(iDocument, n + 1, n2);
                        break;
                    }
                    if (c2 != '/') break;
                    n = n2;
                    break;
                }
                case '*': {
                    char c2;
                    if (n >= n2 || (c2 = iDocument.getChar(n)) != '/') continue block7;
                    n3 = 0;
                    ++n;
                    break;
                }
                case '{': {
                    ++n3;
                    bl = false;
                    break;
                }
                case '}': {
                    if (bl) break;
                    --n3;
                    break;
                }
                case '\"': 
                case '\'': {
                    n = this.getStringEnd(iDocument, n, n2, c);
                }
            }
        }
        return n3;
    }

    private int getCommentEnd(IDocument iDocument, int n, int n2) throws BadLocationException {
        while (n < n2) {
            char c = iDocument.getChar(n);
            if (c != '*' || ++n >= n2 || iDocument.getChar(n) != '/') continue;
            return n + 1;
        }
        return n2;
    }

    protected String getIndentOfLine(IDocument iDocument, int n) throws BadLocationException {
        if (n > -1) {
            int n2 = iDocument.getLineOffset(n);
            int n3 = n2 + iDocument.getLineLength(n) - 1;
            int n4 = this.findEndOfWhiteSpace(iDocument, n2, n3);
            return iDocument.get(n2, n4 - n2);
        }
        return "";
    }

    private int getStringEnd(IDocument iDocument, int n, int n2, char c) throws BadLocationException {
        while (n < n2) {
            char c2 = iDocument.getChar(n);
            ++n;
            if (c2 == '\\') {
                ++n;
                continue;
            }
            if (c2 != c) continue;
            return n;
        }
        return n2;
    }

    protected void smartInsertAfterBracket(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.offset == -1 || iDocument.getLength() == 0) {
            return;
        }
        try {
            int n;
            int n2 = documentCommand.offset == iDocument.getLength() ? documentCommand.offset - 1 : documentCommand.offset;
            int n3 = iDocument.getLineOfOffset(n2);
            int n4 = iDocument.getLineOffset(n3);
            int n5 = this.findEndOfWhiteSpace(iDocument, n4, documentCommand.offset);
            if (n5 == documentCommand.offset && (n = this.findMatchingOpenBracket(iDocument, n3, documentCommand.offset, 1)) != -1 && n != n3) {
                StringBuffer stringBuffer = new StringBuffer(this.getIndentOfLine(iDocument, n));
                stringBuffer.append(iDocument.get(n5, documentCommand.offset - n5));
                stringBuffer.append(documentCommand.text);
                documentCommand.length = documentCommand.offset - n4;
                documentCommand.offset = n4;
                documentCommand.text = stringBuffer.toString();
            }
        }
        catch (BadLocationException badLocationException) {
            CUIPlugin.getDefault().log(badLocationException);
        }
    }

    protected void smartIndentAfterNewLine(IDocument iDocument, DocumentCommand documentCommand) {
        int n = iDocument.getLength();
        if (documentCommand.offset == -1 || n == 0) {
            return;
        }
        try {
            int n2 = documentCommand.offset == n ? documentCommand.offset - 1 : documentCommand.offset;
            int n3 = iDocument.getLineOfOffset(n2);
            StringBuffer stringBuffer = new StringBuffer(documentCommand.text);
            if (documentCommand.offset < n && iDocument.getChar(documentCommand.offset) == '}') {
                int n4 = this.findMatchingOpenBracket(iDocument, n3, documentCommand.offset, 0);
                if (n4 == -1) {
                    n4 = n3;
                }
                stringBuffer.append(this.getIndentOfLine(iDocument, n4));
            } else {
                int n5 = iDocument.getLineOffset(n3);
                int n6 = this.findEndOfWhiteSpace(iDocument, n5, documentCommand.offset);
                stringBuffer.append(iDocument.get(n5, n6 - n5));
                if (this.getBracketCount(iDocument, n5, documentCommand.offset, true) > 0) {
                    stringBuffer.append('\t');
                }
            }
            documentCommand.text = stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {
            CUIPlugin.getDefault().log(badLocationException);
        }
    }

    private boolean endsWithDelimiter(IDocument iDocument, String string) {
        String[] stringArray = iDocument.getLegalLineDelimiters();
        int n = 0;
        while (n < stringArray.length) {
            if (string.endsWith(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.length == 0 && documentCommand.text != null && this.endsWithDelimiter(iDocument, documentCommand.text)) {
            this.smartIndentAfterNewLine(iDocument, documentCommand);
        } else if ("}".equals(documentCommand.text)) {
            this.smartInsertAfterBracket(iDocument, documentCommand);
        }
    }
}

