/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class CDoubleClickSelector
implements ITextDoubleClickStrategy {
    protected ITextViewer fText;
    protected int fPos;
    protected int fStartPos;
    protected int fEndPos;
    protected static char[] fgBrackets = new char[]{'{', '}', '(', ')', '[', ']', '\"', '\"'};

    public void doubleClicked(ITextViewer iTextViewer) {
        this.fPos = iTextViewer.getSelectedRange().x;
        if (this.fPos < 0) {
            return;
        }
        this.fText = iTextViewer;
        if (!this.selectBracketBlock()) {
            this.selectWord();
        }
    }

    protected boolean matchBracketsAt() {
        int n = fgBrackets.length;
        int n2 = fgBrackets.length;
        this.fStartPos = -1;
        this.fEndPos = -1;
        try {
            IDocument iDocument = this.fText.getDocument();
            char c = iDocument.getChar(this.fPos - 1);
            char c2 = iDocument.getChar(this.fPos);
            int n3 = 0;
            while (n3 < fgBrackets.length) {
                if (c == fgBrackets[n3]) {
                    this.fStartPos = this.fPos - 1;
                    n = n3;
                }
                n3 += 2;
            }
            n3 = 1;
            while (n3 < fgBrackets.length) {
                if (c2 == fgBrackets[n3]) {
                    this.fEndPos = this.fPos;
                    n2 = n3;
                }
                n3 += 2;
            }
            if (this.fStartPos > -1 && n < n2) {
                this.fEndPos = this.searchForClosingBracket(this.fStartPos, c, fgBrackets[n + 1], iDocument);
                if (this.fEndPos > -1) {
                    return true;
                }
                this.fStartPos = -1;
            } else if (this.fEndPos > -1) {
                this.fStartPos = this.searchForOpenBracket(this.fEndPos, fgBrackets[n2 - 1], c2, iDocument);
                if (this.fStartPos > -1) {
                    return true;
                }
                this.fEndPos = -1;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    protected boolean matchWord() {
        IDocument iDocument = this.fText.getDocument();
        try {
            char c;
            int n = this.fPos;
            while (n >= 0) {
                c = iDocument.getChar(n);
                if (!Character.isJavaIdentifierPart(c)) break;
                --n;
            }
            this.fStartPos = n;
            n = this.fPos;
            int n2 = iDocument.getLength();
            while (n < n2) {
                c = iDocument.getChar(n);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++n;
            }
            this.fEndPos = n;
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected int searchForClosingBracket(int n, char c, char c2, IDocument iDocument) throws BadLocationException {
        int n2 = 1;
        int n3 = n + 1;
        int n4 = iDocument.getLength();
        while (n3 < n4 && n2 > 0) {
            char c3 = iDocument.getChar(n3);
            if (c3 == c && c3 != c2) {
                ++n2;
            } else if (c3 == c2) {
                --n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            return n3 - 1;
        }
        return -1;
    }

    protected int searchForOpenBracket(int n, char c, char c2, IDocument iDocument) throws BadLocationException {
        int n2 = 1;
        int n3 = n - 1;
        while (n3 >= 0 && n2 > 0) {
            char c3 = iDocument.getChar(n3);
            if (c3 == c2 && c3 != c) {
                ++n2;
            } else if (c3 == c) {
                --n2;
            }
            --n3;
        }
        if (n2 == 0) {
            return n3 + 1;
        }
        return -1;
    }

    protected boolean selectBracketBlock() {
        if (this.matchBracketsAt()) {
            if (this.fStartPos == this.fEndPos) {
                this.fText.setSelectedRange(this.fStartPos, 0);
            } else {
                this.fText.setSelectedRange(this.fStartPos + 1, this.fEndPos - this.fStartPos - 1);
            }
            return true;
        }
        return false;
    }

    protected void selectWord() {
        if (this.matchWord()) {
            if (this.fStartPos == this.fEndPos) {
                this.fText.setSelectedRange(this.fStartPos, 0);
            } else {
                this.fText.setSelectedRange(this.fStartPos + 1, this.fEndPos - this.fStartPos - 1);
            }
        }
    }
}

