/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.internal.ui.text.CCodeScanner;
import org.eclipse.cdt.internal.ui.text.CCommentScanner;
import org.eclipse.cdt.internal.ui.text.CppCodeScanner;
import org.eclipse.cdt.internal.ui.text.FastCPartitionScanner;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.SingleTokenCScanner;
import org.eclipse.cdt.internal.ui.text.util.CColorManager;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class CTextTools {
    private CColorManager fColorManager;
    private CCodeScanner fCodeScanner;
    private CppCodeScanner fCppCodeScanner;
    private FastCPartitionScanner fPartitionScanner;
    private CCommentScanner fMultilineCommentScanner;
    private CCommentScanner fSinglelineCommentScanner;
    private SingleTokenCScanner fStringScanner;
    private IPreferenceStore fPreferenceStore;
    private Preferences fCorePreferenceStore;
    private PreferenceListener fPreferenceListener = new PreferenceListener();

    public CTextTools(IPreferenceStore iPreferenceStore) {
        this(iPreferenceStore, null);
    }

    public CTextTools(IPreferenceStore iPreferenceStore, Preferences preferences) {
        if (iPreferenceStore == null) {
            iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        }
        this.fPreferenceStore = iPreferenceStore;
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fCorePreferenceStore = preferences;
        if (this.fCorePreferenceStore != null) {
            this.fCorePreferenceStore.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
        }
        this.fColorManager = new CColorManager();
        this.fCodeScanner = new CCodeScanner(this.fColorManager, iPreferenceStore);
        this.fCppCodeScanner = new CppCodeScanner(this.fColorManager, iPreferenceStore);
        this.fPartitionScanner = new FastCPartitionScanner();
        this.fMultilineCommentScanner = new CCommentScanner(this.fColorManager, iPreferenceStore, preferences, "c_multi_line_comment");
        this.fSinglelineCommentScanner = new CCommentScanner(this.fColorManager, iPreferenceStore, preferences, "c_single_line_comment");
        this.fStringScanner = new SingleTokenCScanner((IColorManager)this.fColorManager, iPreferenceStore, "c_string");
    }

    public CTextTools() {
        this(null);
    }

    public void dispose() {
        this.fCodeScanner = null;
        this.fPartitionScanner = null;
        this.fMultilineCommentScanner = null;
        this.fSinglelineCommentScanner = null;
        this.fStringScanner = null;
        if (this.fColorManager != null) {
            this.fColorManager.dispose();
            this.fColorManager = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
            this.fPreferenceStore = null;
            if (this.fCorePreferenceStore != null) {
                this.fCorePreferenceStore.removePropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
                this.fCorePreferenceStore = null;
            }
            this.fPreferenceListener = null;
        }
    }

    public CColorManager getColorManager() {
        return this.fColorManager;
    }

    public RuleBasedScanner getCCodeScanner() {
        return this.fCodeScanner;
    }

    public RuleBasedScanner getCppCodeScanner() {
        return this.fCppCodeScanner;
    }

    public IPartitionTokenScanner getPartitionScanner() {
        return this.fPartitionScanner;
    }

    public IDocumentPartitioner createDocumentPartitioner() {
        String[] stringArray = new String[]{"c_multi_line_comment", "c_single_line_comment", "c_string"};
        return new DefaultPartitioner(this.getPartitionScanner(), stringArray);
    }

    public RuleBasedScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    public RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    public RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    public boolean affectsBehavior(PropertyChangeEvent propertyChangeEvent) {
        return this.fCodeScanner.affectsBehavior(propertyChangeEvent) || this.fCppCodeScanner.affectsBehavior(propertyChangeEvent) || this.fMultilineCommentScanner.affectsBehavior(propertyChangeEvent) || this.fSinglelineCommentScanner.affectsBehavior(propertyChangeEvent) || this.fStringScanner.affectsBehavior(propertyChangeEvent);
    }

    protected void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fCodeScanner.affectsBehavior(propertyChangeEvent)) {
            this.fCodeScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fCppCodeScanner.affectsBehavior(propertyChangeEvent)) {
            this.fCppCodeScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(propertyChangeEvent)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(propertyChangeEvent)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fStringScanner.affectsBehavior(propertyChangeEvent)) {
            this.fStringScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
    }

    public void setupCDocumentPartitioner(IDocument iDocument, String string) {
        IDocumentPartitioner iDocumentPartitioner = this.createDocumentPartitioner();
        if (iDocument instanceof IDocumentExtension3) {
            IDocumentExtension3 iDocumentExtension3 = (IDocumentExtension3)iDocument;
            iDocumentExtension3.setDocumentPartitioner(string, iDocumentPartitioner);
        } else {
            iDocument.setDocumentPartitioner(iDocumentPartitioner);
        }
        iDocumentPartitioner.connect(iDocument);
    }

    public void setupCDocument(IDocument iDocument) {
        this.setupCDocumentPartitioner(iDocument, "__dftl_partitioning");
    }

    private class PreferenceListener
    implements IPropertyChangeListener,
    Preferences.IPropertyChangeListener {
        PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CTextTools.this.adaptToPreferenceChange(propertyChangeEvent);
        }

        public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
            CTextTools.this.adaptToPreferenceChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getProperty(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue()));
        }
    }
}

