/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import org.eclipse.cdt.internal.ui.editor.CAnnotationIterator;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.HTMLPrinter;
import org.eclipse.cdt.internal.ui.text.c.hover.AbstractCEditorTextHover;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class AbstractAnnotationHover
extends AbstractCEditorTextHover {
    private IPreferenceStore fStore = CUIPlugin.getDefault().getCombinedPreferenceStore();
    private DefaultMarkerAnnotationAccess fAnnotationAccess = new DefaultMarkerAnnotationAccess();
    private boolean fAllAnnotations;

    public AbstractAnnotationHover(boolean bl) {
        this.fAllAnnotations = bl;
    }

    private String formatMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        HTMLPrinter.addPageProlog(stringBuffer);
        HTMLPrinter.addParagraph(stringBuffer, HTMLPrinter.convertToHTMLContent(string));
        HTMLPrinter.addPageEpilog(stringBuffer);
        return stringBuffer.toString();
    }

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        if (this.getEditor() == null) {
            return null;
        }
        CDocumentProvider cDocumentProvider = CUIPlugin.getDefault().getDocumentProvider();
        IAnnotationModel iAnnotationModel = cDocumentProvider.getAnnotationModel(this.getEditor().getEditorInput());
        if (iAnnotationModel != null) {
            CAnnotationIterator cAnnotationIterator = new CAnnotationIterator(iAnnotationModel, true, this.fAllAnnotations);
            int n = -1;
            String string = null;
            while (cAnnotationIterator.hasNext()) {
                String string2;
                Annotation annotation = (Annotation)cAnnotationIterator.next();
                AnnotationPreference annotationPreference = this.getAnnotationPreference(annotation);
                if (annotationPreference == null || (annotationPreference.getTextPreferenceKey() == null || !this.fStore.getBoolean(annotationPreference.getTextPreferenceKey())) && (annotationPreference.getHighlightPreferenceKey() == null || !this.fStore.getBoolean(annotationPreference.getHighlightPreferenceKey()))) continue;
                Position position = iAnnotationModel.getPosition(annotation);
                int n2 = this.fAnnotationAccess.getLayer(annotation);
                if (n2 <= n || position == null || !position.overlapsWith(iRegion.getOffset(), iRegion.getLength()) || (string2 = annotation.getText()) == null || string2.trim().length() <= 0) continue;
                string = string2;
                n = n2;
            }
            if (n > -1) {
                return this.formatMessage(string);
            }
        }
        return null;
    }

    public void setEditor(IEditorPart iEditorPart) {
        if (iEditorPart instanceof CEditor) {
            super.setEditor(iEditorPart);
        } else {
            super.setEditor(null);
        }
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        if (annotation.isMarkedDeleted()) {
            return null;
        }
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }
}

