/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.ui.text.c.hover.AbstractCEditorTextHover;
import org.eclipse.cdt.internal.ui.text.c.hover.CEditorTextHoverDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.c.hover.ICEditorTextHover;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.IEditorPart;

public class BestMatchHover
extends AbstractCEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    private List fTextHoverSpecifications;
    private List fInstantiatedTextHovers;
    private ITextHover fBestHover;

    public BestMatchHover() {
        this.installTextHovers();
    }

    public BestMatchHover(IEditorPart iEditorPart) {
        this();
        this.setEditor(iEditorPart);
    }

    private void installTextHovers() {
        this.fTextHoverSpecifications = new ArrayList(2);
        this.fInstantiatedTextHovers = new ArrayList(2);
        CEditorTextHoverDescriptor[] cEditorTextHoverDescriptorArray = CUIPlugin.getDefault().getCEditorTextHoverDescriptors();
        int n = 0;
        while (n < cEditorTextHoverDescriptorArray.length) {
            if (!"org.eclipse.cdt.ui.BestMatchHover".equals(cEditorTextHoverDescriptorArray[n].getId())) {
                this.fTextHoverSpecifications.add(cEditorTextHoverDescriptorArray[n]);
            }
            ++n;
        }
    }

    private void checkTextHovers() {
        if (this.fTextHoverSpecifications.size() == 0) {
            return;
        }
        Iterator iterator = new ArrayList(this.fTextHoverSpecifications).iterator();
        while (iterator.hasNext()) {
            CEditorTextHoverDescriptor cEditorTextHoverDescriptor = (CEditorTextHoverDescriptor)iterator.next();
            ICEditorTextHover iCEditorTextHover = cEditorTextHoverDescriptor.createTextHover();
            if (iCEditorTextHover == null) continue;
            iCEditorTextHover.setEditor(this.getEditor());
            this.addTextHover(iCEditorTextHover);
            this.fTextHoverSpecifications.remove(cEditorTextHoverDescriptor);
        }
    }

    protected void addTextHover(ITextHover iTextHover) {
        if (!this.fInstantiatedTextHovers.contains(iTextHover)) {
            this.fInstantiatedTextHovers.add(iTextHover);
        }
    }

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        Iterator iterator = this.fInstantiatedTextHovers.iterator();
        while (iterator.hasNext()) {
            ITextHover iTextHover = (ITextHover)iterator.next();
            String string = iTextHover.getHoverInfo(iTextViewer, iRegion);
            if (string == null || string.trim().length() <= 0) continue;
            this.fBestHover = iTextHover;
            return string;
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fBestHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fBestHover).getHoverControlCreator();
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fBestHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fBestHover).getInformationPresenterControlCreator();
        }
        return null;
    }
}

