/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.c.hover.ICEditorTextHover;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Assert;

public class CEditorTextHoverDescriptor
implements Comparable {
    private static final String C_EDITOR_TEXT_HOVER_EXTENSION_POINT = "org.eclipse.cdt.ui.textHovers";
    private static final String HOVER_TAG = "hover";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String ACTIVATE_PLUG_IN_ATTRIBUTE = "activate";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String PERSPECTIVE = "perspective";
    public static final String NO_MODIFIER = "0";
    public static final String DISABLED_TAG = "!";
    public static final String VALUE_SEPARATOR = ";";
    private int fStateMask;
    private String fModifierString;
    private boolean fIsEnabled;
    private IConfigurationElement fElement;

    public static CEditorTextHoverDescriptor[] getContributedHovers() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(C_EDITOR_TEXT_HOVER_EXTENSION_POINT);
        CEditorTextHoverDescriptor[] cEditorTextHoverDescriptorArray = CEditorTextHoverDescriptor.createDescriptors(iConfigurationElementArray);
        CEditorTextHoverDescriptor.initializeFromPreferences(cEditorTextHoverDescriptorArray);
        return cEditorTextHoverDescriptorArray;
    }

    public static int computeStateMask(String string) {
        if (string == null) {
            return -1;
        }
        if (string.length() == 0) {
            return 0;
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;.:+-* ");
        while (stringTokenizer.hasMoreTokens()) {
            int n2 = EditorUtility.findLocalizedModifier(stringTokenizer.nextToken());
            if (n2 == 0 || (n & n2) == n2) {
                return -1;
            }
            n |= n2;
        }
        return n;
    }

    private CEditorTextHoverDescriptor(IConfigurationElement iConfigurationElement) {
        Assert.isNotNull((Object)iConfigurationElement);
        this.fElement = iConfigurationElement;
    }

    public ICEditorTextHover createTextHover() {
        boolean bl;
        String string = this.fElement.getDeclaringExtension().getNamespace();
        boolean bl2 = bl = Platform.getBundle((String)string).getState() == 32;
        if (bl || this.canActivatePlugIn()) {
            try {
                return (ICEditorTextHover)this.fElement.createExecutableExtension(CLASS_ATTRIBUTE);
            }
            catch (CoreException coreException) {
                CUIPlugin.getDefault().log((IStatus)new Status(4, CUIPlugin.getPluginId(), 0, "CEditorTextHover.createTextHover", null));
            }
        }
        return null;
    }

    public String getId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getHoverClassName() {
        return this.fElement.getAttribute(CLASS_ATTRIBUTE);
    }

    public String getLabel() {
        String string = this.fElement.getAttribute(LABEL_ATTRIBUTE);
        if (string != null) {
            return string;
        }
        string = this.getHoverClassName();
        int n = string.lastIndexOf(46);
        if (n >= 0 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public String getDescription() {
        return this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
    }

    public String getPerspective() {
        return this.fElement.getAttribute(PERSPECTIVE);
    }

    public boolean canActivatePlugIn() {
        return Boolean.valueOf(this.fElement.getAttribute(ACTIVATE_PLUG_IN_ATTRIBUTE));
    }

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass()) || this.getId() == null) {
            return false;
        }
        return this.getId().equals(((CEditorTextHoverDescriptor)object).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public int compareTo(Object object) {
        return Collator.getInstance().compare(this.getLabel(), ((CEditorTextHoverDescriptor)object).getLabel());
    }

    private static CEditorTextHoverDescriptor[] createDescriptors(IConfigurationElement[] iConfigurationElementArray) {
        ArrayList<CEditorTextHoverDescriptor> arrayList = new ArrayList<CEditorTextHoverDescriptor>(iConfigurationElementArray.length);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (HOVER_TAG.equals(iConfigurationElement.getName())) {
                CEditorTextHoverDescriptor cEditorTextHoverDescriptor = new CEditorTextHoverDescriptor(iConfigurationElement);
                arrayList.add(cEditorTextHoverDescriptor);
            }
            ++n;
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new CEditorTextHoverDescriptor[arrayList.size()]);
    }

    private static void initializeFromPreferences(CEditorTextHoverDescriptor[] cEditorTextHoverDescriptorArray) {
        String string;
        String string2 = CUIPlugin.getDefault().getPreferenceStore().getString("hoverModifiers");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, VALUE_SEPARATOR);
        HashMap<String, String> hashMap = new HashMap<String, String>(stringTokenizer.countTokens() / 2);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            hashMap.put(string, stringTokenizer.nextToken());
        }
        string = CUIPlugin.getDefault().getPreferenceStore().getString("hoverModifierMasks");
        stringTokenizer = new StringTokenizer(string, VALUE_SEPARATOR);
        HashMap<String, String> hashMap2 = new HashMap<String, String>(stringTokenizer.countTokens() / 2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            hashMap2.put(string3, stringTokenizer.nextToken());
        }
        int n = 0;
        while (n < cEditorTextHoverDescriptorArray.length) {
            String string4 = (String)hashMap.get(cEditorTextHoverDescriptorArray[n].getId());
            boolean bl = true;
            if (string4 == null) {
                string4 = DISABLED_TAG;
            }
            if (string4.startsWith(DISABLED_TAG)) {
                bl = false;
                string4 = string4.substring(1);
            }
            if (string4.equals(NO_MODIFIER)) {
                string4 = "";
            }
            cEditorTextHoverDescriptorArray[n].fModifierString = string4;
            cEditorTextHoverDescriptorArray[n].fIsEnabled = bl;
            cEditorTextHoverDescriptorArray[n].fStateMask = CEditorTextHoverDescriptor.computeStateMask(string4);
            if (cEditorTextHoverDescriptorArray[n].fStateMask == -1) {
                try {
                    cEditorTextHoverDescriptorArray[n].fStateMask = Integer.parseInt((String)hashMap2.get(cEditorTextHoverDescriptorArray[n].getId()));
                }
                catch (NumberFormatException numberFormatException) {
                    cEditorTextHoverDescriptorArray[n].fStateMask = -1;
                }
                int n2 = cEditorTextHoverDescriptorArray[n].fStateMask;
                cEditorTextHoverDescriptorArray[n].fModifierString = n2 == -1 ? "" : EditorUtility.getModifierString(n2);
            }
            ++n;
        }
    }

    public int getStateMask() {
        return this.fStateMask;
    }

    public String getModifierString() {
        return this.fModifierString;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }
}

