/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.corext.template.ContextType;
import org.eclipse.cdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.cdt.internal.ui.CCompletionContributorManager;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.CParameterListValidator;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposalComparator;
import org.eclipse.cdt.internal.ui.text.contentassist.CompletionEngine;
import org.eclipse.cdt.internal.ui.text.contentassist.ResultCollector;
import org.eclipse.cdt.internal.ui.text.template.TemplateEngine;
import org.eclipse.cdt.ui.CSearchResultLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.FunctionPrototypeSummary;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

public class CCompletionProcessor
implements IContentAssistProcessor {
    private CEditor fEditor;
    private char[] fProposalAutoActivationSet;
    private CCompletionProposalComparator fComparator;
    private IContextInformationValidator fValidator;
    private TemplateEngine[] fGlobalContextTemplateEngine;
    private TemplateEngine[] fFunctionContextTemplateEngine;
    private TemplateEngine[] fStructureContextTemplateEngine;
    private boolean fRestrictToMatchingCase;
    private boolean fAllowAddIncludes;
    private BasicSearchResultCollector searchResultCollector = null;
    private ResultCollector resultCollector = null;
    private CompletionEngine completionEngine = null;
    private SearchEngine searchEngine = null;
    private CSearchResultLabelProvider labelProvider = null;
    private int fCurrentOffset = 0;
    private IWorkingCopy fCurrentSourceUnit = null;
    private IASTCompletionNode fCurrentCompletionNode = null;
    private int fNumberOfComputedResults = 0;
    private ITextViewer fTextViewer;

    public CCompletionProcessor(IEditorPart iEditorPart) {
        this.fEditor = (CEditor)iEditorPart;
        this.labelProvider = new CSearchResultLabelProvider();
        this.searchResultCollector = new BasicSearchResultCollector();
        this.resultCollector = new ResultCollector();
        this.completionEngine = new CompletionEngine(this.resultCollector);
        this.searchEngine = new SearchEngine();
        this.searchEngine.setWaitingPolicy(1);
        this.setupTemplateEngine();
        this.fRestrictToMatchingCase = false;
        this.fAllowAddIncludes = true;
        this.fComparator = new CCompletionProposalComparator();
    }

    private boolean isCppContext() {
        String string = null;
        if (this.fEditor != null && this.fEditor.getEditorInput() != null) {
            string = this.fEditor.getEditorInput().getName();
        }
        if (string == null) {
            return true;
        }
        if (string.endsWith(".c")) {
            return false;
        }
        if (string.endsWith(".cpp") || string.endsWith(".cc") || string.endsWith(".cxx") || string.endsWith(".C") || string.endsWith(".hxx")) {
            return true;
        }
        IFile iFile = this.fEditor.getInputFile();
        return iFile != null && CoreModel.hasCCNature((IProject)iFile.getProject());
    }

    private void setupTemplateEngine() {
        ContextType contextType;
        String[] stringArray = new String[2];
        String[] stringArray2 = new String[2];
        String[] stringArray3 = new String[2];
        ArrayList<TemplateEngine> arrayList = new ArrayList<TemplateEngine>(2);
        ArrayList<TemplateEngine> arrayList2 = new ArrayList<TemplateEngine>(2);
        ArrayList<TemplateEngine> arrayList3 = new ArrayList<TemplateEngine>(2);
        if (this.isCppContext()) {
            stringArray[0] = "C++ Global";
            stringArray[1] = "C Global";
            stringArray2[0] = "C++ Function";
            stringArray2[1] = "C Function";
            stringArray3[0] = "C++ Structure";
            stringArray3[1] = "C Structure";
        } else {
            stringArray[0] = "C Global";
            stringArray3[0] = "C Structure";
            stringArray2[0] = "C Function";
        }
        int n = 0;
        while (n < stringArray.length) {
            contextType = ContextTypeRegistry.getInstance().getContextType(stringArray[n]);
            if (contextType != null) {
                arrayList.add(new TemplateEngine(contextType));
            }
            ++n;
        }
        n = 0;
        while (n < stringArray2.length) {
            contextType = ContextTypeRegistry.getInstance().getContextType(stringArray2[n]);
            if (contextType != null) {
                arrayList2.add(new TemplateEngine(contextType));
            }
            ++n;
        }
        n = 0;
        while (n < stringArray3.length) {
            contextType = ContextTypeRegistry.getInstance().getContextType(stringArray3[n]);
            if (contextType != null) {
                arrayList3.add(new TemplateEngine(contextType));
            }
            ++n;
        }
        this.fGlobalContextTemplateEngine = arrayList.toArray(new TemplateEngine[arrayList.size()]);
        this.fFunctionContextTemplateEngine = arrayList2.toArray(new TemplateEngine[arrayList2.size()]);
        this.fStructureContextTemplateEngine = arrayList3.toArray(new TemplateEngine[arrayList3.size()]);
    }

    public void orderProposalsAlphabetically(boolean bl) {
        this.fComparator.setOrderAlphabetically(bl);
    }

    public String getErrorMessage() {
        if (this.fNumberOfComputedResults == 0) {
            String string = this.resultCollector.getErrorMessage();
            if (string == null || string.length() == 0) {
                string = CUIMessages.getString("CEditor.contentassist.noCompletions");
            }
            return string;
        }
        return this.resultCollector.getErrorMessage();
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new CParameterListValidator();
        }
        return this.fValidator;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        List list = this.addContextInformations(iTextViewer, n);
        return list.toArray(new IContextInformation[list.size()]);
    }

    private List addContextInformations(ITextViewer iTextViewer, int n) {
        ICompletionProposal[] iCompletionProposalArray = this.internalComputeCompletionProposals(iTextViewer, n);
        ArrayList<ContextInformationWrapper> arrayList = new ArrayList<ContextInformationWrapper>();
        int n2 = 0;
        while (n2 < iCompletionProposalArray.length) {
            IContextInformation iContextInformation = iCompletionProposalArray[n2].getContextInformation();
            if (iContextInformation != null) {
                ContextInformationWrapper contextInformationWrapper = new ContextInformationWrapper(iContextInformation);
                contextInformationWrapper.setContextInformationPosition(n);
                arrayList.add(contextInformationWrapper);
            }
            ++n2;
        }
        return arrayList;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] cArray) {
        this.fProposalAutoActivationSet = cArray;
    }

    public void restrictProposalsToMatchingCases(boolean bl) {
    }

    public void allowAddingIncludes(boolean bl) {
        this.fAllowAddIncludes = bl;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        return this.internalComputeCompletionProposals(iTextViewer, n);
    }

    private ICompletionProposal[] internalComputeCompletionProposals(ITextViewer iTextViewer, int n) {
        IWorkingCopyManager iWorkingCopyManager = CUIPlugin.getDefault().getWorkingCopyManager();
        IWorkingCopy iWorkingCopy = iWorkingCopyManager.getWorkingCopy(this.fEditor.getEditorInput());
        IDocument iDocument = iTextViewer.getDocument();
        int n2 = n - 1;
        if (n2 >= 0) {
            try {
                if (iDocument.getChar(n2) == ':' && iDocument.getChar(n2 - 1) != ':') {
                    return null;
                }
                if (iDocument.getChar(n2) == '>' && iDocument.getChar(n2 - 1) != '-') {
                    return null;
                }
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        ICompletionProposal[] iCompletionProposalArray = null;
        try {
            iCompletionProposalArray = this.evalProposals(iDocument, n, iWorkingCopy, iTextViewer);
        }
        catch (Exception exception) {
            CUIPlugin.getDefault().log(exception);
        }
        int n3 = this.fNumberOfComputedResults = iCompletionProposalArray == null ? 0 : iCompletionProposalArray.length;
        if (iCompletionProposalArray == null) {
            iCompletionProposalArray = new ICCompletionProposal[]{};
        }
        this.order((ICCompletionProposal[])iCompletionProposalArray);
        return iCompletionProposalArray;
    }

    private ICCompletionProposal[] order(ICCompletionProposal[] iCCompletionProposalArray) {
        if (iCCompletionProposalArray != null) {
            Arrays.sort(iCCompletionProposalArray, this.fComparator);
        }
        return iCCompletionProposalArray;
    }

    public ICCompletionProposal[] evalProposals(IDocument iDocument, int n, IWorkingCopy iWorkingCopy, ITextViewer iTextViewer) {
        this.fCurrentOffset = n;
        this.fCurrentSourceUnit = iWorkingCopy;
        this.fTextViewer = iTextViewer;
        ArrayList arrayList = new ArrayList();
        if (this.fCurrentSourceUnit == null) {
            return null;
        }
        this.resultCollector.reset(iTextViewer);
        this.fCurrentCompletionNode = this.addProposalsFromModel(arrayList);
        if (this.fCurrentCompletionNode != null) {
            this.addProposalsFromSearch(this.fCurrentCompletionNode, arrayList);
            this.addProposalsFromCompletionContributors(this.fCurrentCompletionNode, arrayList);
            this.addProposalsFromTemplates(iTextViewer, this.fCurrentCompletionNode, arrayList);
            return this.order(arrayList.toArray(new ICCompletionProposal[0]));
        }
        return null;
    }

    private void addProposalsFromTemplates(ITextViewer iTextViewer, IASTCompletionNode iASTCompletionNode, List list) {
        if (iASTCompletionNode == null) {
            return;
        }
        if (iTextViewer == null) {
            return;
        }
        IASTCompletionNode.CompletionKind completionKind = iASTCompletionNode.getCompletionKind();
        if (completionKind == IASTCompletionNode.CompletionKind.VARIABLE_TYPE || completionKind == IASTCompletionNode.CompletionKind.CLASS_REFERENCE) {
            this.addProposalsFromTemplateEngine(iTextViewer, this.fGlobalContextTemplateEngine, list);
        }
        if (completionKind == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE || completionKind == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE) {
            this.addProposalsFromTemplateEngine(iTextViewer, this.fFunctionContextTemplateEngine, list);
        }
        if (completionKind == IASTCompletionNode.CompletionKind.FIELD_TYPE) {
            this.addProposalsFromTemplateEngine(iTextViewer, this.fStructureContextTemplateEngine, list);
        }
    }

    private void addProposalsFromTemplateEngine(ITextViewer iTextViewer, TemplateEngine[] templateEngineArray, List list) {
        int n = 0;
        while (n < templateEngineArray.length) {
            if (templateEngineArray[n] != null) {
                try {
                    templateEngineArray[n].reset();
                    templateEngineArray[n].complete(iTextViewer, this.fCurrentOffset, null);
                }
                catch (Exception exception) {
                    CUIPlugin.getDefault().log(exception);
                }
                list.addAll(templateEngineArray[n].getResults());
            }
            ++n;
        }
    }

    private void addProposalsFromCompletionContributors(IASTCompletionNode iASTCompletionNode, List list) {
        if (iASTCompletionNode == null) {
            return;
        }
        String string = iASTCompletionNode.getCompletionPrefix();
        int n = this.fCurrentOffset - string.length();
        int n2 = string.length();
        if (iASTCompletionNode.getCompletionContext() != IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE && iASTCompletionNode.getCompletionContext() != IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE) {
            return;
        }
        IFunctionSummary[] iFunctionSummaryArray = CCompletionContributorManager.getDefault().getMatchingFunctions(string);
        if (iFunctionSummaryArray == null) {
            return;
        }
        int n3 = 0;
        while (n3 < iFunctionSummaryArray.length) {
            String string2 = String.valueOf(iFunctionSummaryArray[n3].getName()) + "()";
            String string3 = iFunctionSummaryArray[n3].getDescription();
            IFunctionSummary.IFunctionPrototypeSummary iFunctionPrototypeSummary = iFunctionSummaryArray[n3].getPrototype();
            String string4 = iFunctionPrototypeSummary.getArguments();
            CCompletionProposal cCompletionProposal = new CCompletionProposal(string2, n, n2, CPluginImages.get("org.eclipse.cdt.ui.function_obj.gif"), iFunctionPrototypeSummary.getPrototypeString(true), 2, this.fTextViewer);
            if (string3 != null) {
                cCompletionProposal.setAdditionalProposalInfo(string3);
            }
            if (string4 != null && string4.length() > 0) {
                cCompletionProposal.setContextInformation((IContextInformation)new ContextInformation(string2, string4));
            }
            list.add(cCompletionProposal);
            ++n3;
        }
    }

    private FunctionPrototypeSummary getPrototype(BasicSearchMatch basicSearchMatch) {
        switch (basicSearchMatch.getElementType()) {
            case 67: 
            case 68: 
            case 70: 
            case 71: {
                return new FunctionPrototypeSummary(String.valueOf(basicSearchMatch.getReturnType()) + " " + basicSearchMatch.getName());
            }
        }
        return null;
    }

    private IASTCompletionNode addProposalsFromModel(List list) {
        IASTCompletionNode iASTCompletionNode = this.completionEngine.complete(this.fCurrentSourceUnit, this.fCurrentOffset);
        return iASTCompletionNode;
    }

    private void addProposalsFromSearch(IASTCompletionNode iASTCompletionNode, List list) {
        if (iASTCompletionNode == null) {
            return;
        }
        String string = iASTCompletionNode.getCompletionPrefix();
        int n = this.fCurrentOffset - string.length();
        int n2 = string.length();
        String string2 = String.valueOf(string) + "*";
        IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.getBoolean("content_assist_current_file_search_scope");
        boolean bl = iPreferenceStore.getBoolean("content_assist_project_search_scope");
        ICSearchScope iCSearchScope = null;
        if (bl && (iASTCompletionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE || iASTCompletionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE || iASTCompletionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.VARIABLE_TYPE || iASTCompletionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.FIELD_TYPE) && string.length() > 0) {
            LinkedList linkedList = new LinkedList();
            ICElement[] iCElementArray = new ICElement[]{this.fCurrentSourceUnit.getCProject()};
            iCSearchScope = SearchEngine.createCSearchScope((ICElement[])iCElementArray, (boolean)true);
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(SearchEngine.createSearchPattern((String)string2, (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            orPattern.addPattern(SearchEngine.createSearchPattern((String)string2, (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            orPattern.addPattern(SearchEngine.createSearchPattern((String)string2, (ICSearchConstants.SearchFor)ICSearchConstants.MACRO, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            orPattern.addPattern(SearchEngine.createSearchPattern((String)string2, (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)false));
            if (iASTCompletionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE || iASTCompletionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string2, (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string2, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)false));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string2, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            }
            try {
                this.searchEngine.search(CUIPlugin.getWorkspace(), (ICSearchPattern)orPattern, iCSearchScope, (ICSearchResultCollector)this.searchResultCollector, true);
            }
            catch (InterruptedException interruptedException) {}
            linkedList.addAll(this.searchResultCollector.getSearchResults());
            this.sendResultsToCollector(linkedList.iterator(), n, n2, string);
        }
        list.addAll(this.resultCollector.getCompletions());
    }

    private void sendResultsToCollector(Iterator iterator, int n, int n2, String string) {
        while (iterator.hasNext()) {
            BasicSearchMatch basicSearchMatch = (BasicSearchMatch)iterator.next();
            int n3 = basicSearchMatch.getElementType();
            int n4 = this.completionEngine.computeRelevance(n3, string, basicSearchMatch.getName());
            switch (n3) {
                case 69: {
                    ASTAccessVisibility aSTAccessVisibility;
                    switch (basicSearchMatch.getVisibility()) {
                        case 8192: {
                            aSTAccessVisibility = ASTAccessVisibility.PUBLIC;
                            break;
                        }
                        case 16384: {
                            aSTAccessVisibility = ASTAccessVisibility.PROTECTED;
                            break;
                        }
                        default: {
                            aSTAccessVisibility = ASTAccessVisibility.PRIVATE;
                        }
                    }
                    this.resultCollector.acceptField(basicSearchMatch.getName(), basicSearchMatch.getReturnType(), aSTAccessVisibility, n, n2, n4);
                    break;
                }
                case 74: 
                case 75: {
                    this.resultCollector.acceptVariable(basicSearchMatch.getName(), basicSearchMatch.getReturnType(), n, n2, n4);
                    break;
                }
                case 67: 
                case 68: {
                    ASTAccessVisibility aSTAccessVisibility;
                    switch (basicSearchMatch.getVisibility()) {
                        case 8192: {
                            aSTAccessVisibility = ASTAccessVisibility.PUBLIC;
                            break;
                        }
                        case 16384: {
                            aSTAccessVisibility = ASTAccessVisibility.PROTECTED;
                            break;
                        }
                        default: {
                            aSTAccessVisibility = ASTAccessVisibility.PRIVATE;
                        }
                    }
                    this.resultCollector.acceptMethod(basicSearchMatch.getName(), null, basicSearchMatch.getReturnType(), aSTAccessVisibility, n, n2, n4, true, n);
                    break;
                }
                case 70: 
                case 71: {
                    this.resultCollector.acceptFunction(basicSearchMatch.getName(), null, basicSearchMatch.getReturnType(), n, n2, n4, true, n);
                    break;
                }
                case 64: {
                    this.resultCollector.acceptClass(basicSearchMatch.getName(), n, n2, n4);
                    break;
                }
                case 65: {
                    this.resultCollector.acceptStruct(basicSearchMatch.getName(), n, n2, n4);
                    break;
                }
                case 66: {
                    this.resultCollector.acceptUnion(basicSearchMatch.getName(), n, n2, n4);
                    break;
                }
                case 61: {
                    this.resultCollector.acceptNamespace(basicSearchMatch.getName(), n, n2, n4);
                    break;
                }
                case 77: {
                    this.resultCollector.acceptMacro(basicSearchMatch.getName(), n, n2, n4, n);
                    break;
                }
                case 63: {
                    this.resultCollector.acceptEnumeration(basicSearchMatch.getName(), n, n2, n4);
                    break;
                }
                case 79: {
                    this.resultCollector.acceptEnumerator(basicSearchMatch.getName(), n, n2, n4);
                    break;
                }
            }
        }
    }

    public IASTCompletionNode getCurrentCompletionNode() {
        return this.fCurrentCompletionNode;
    }

    private static class ContextInformationWrapper
    implements IContextInformation,
    IContextInformationExtension {
        private final IContextInformation fContextInformation;
        private int fPosition;

        public ContextInformationWrapper(IContextInformation iContextInformation) {
            this.fContextInformation = iContextInformation;
        }

        public String getContextDisplayString() {
            return this.fContextInformation.getContextDisplayString();
        }

        public Image getImage() {
            return this.fContextInformation.getImage();
        }

        public String getInformationDisplayString() {
            return this.fContextInformation.getInformationDisplayString();
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public void setContextInformationPosition(int n) {
            this.fPosition = n;
        }
    }
}

