/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class CCompletionProposal
implements ICCompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3 {
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private int fContextInformationPosition;
    private String fProposalInfo;
    private char[] fTriggerCharacters;
    protected boolean fToggleEating;
    protected ITextViewer fTextViewer;
    private int fRelevance;
    private StyleRange fRememberedStyleRange;

    public CCompletionProposal(String string, int n, int n2, Image image, String string2, int n3) {
        this(string, n, n2, image, string2, n3, null);
    }

    public CCompletionProposal(String string, int n, int n2, Image image, String string2, int n3, ITextViewer iTextViewer) {
        Assert.isNotNull((Object)string);
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
        this.fReplacementString = string;
        this.fReplacementOffset = n;
        this.fReplacementLength = n2;
        this.fImage = image;
        this.fDisplayString = string2 != null ? string2 : string;
        this.fRelevance = n3;
        this.fTextViewer = iTextViewer;
        this.fCursorPosition = string.length();
        this.fContextInformation = null;
        this.fContextInformationPosition = -1;
        this.fTriggerCharacters = null;
        this.fProposalInfo = null;
    }

    public void setContextInformation(IContextInformation iContextInformation) {
        this.fContextInformation = iContextInformation;
        this.fContextInformationPosition = this.fContextInformation != null ? this.fCursorPosition : -1;
    }

    public void setTriggerCharacters(char[] cArray) {
        this.fTriggerCharacters = cArray;
    }

    public void setAdditionalProposalInfo(String string) {
        this.fProposalInfo = string;
    }

    public void setCursorPosition(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fCursorPosition = n;
        this.fContextInformationPosition = this.fContextInformation != null ? this.fCursorPosition : -1;
    }

    public void apply(IDocument iDocument, char c, int n) {
        try {
            int n2;
            String string;
            int n3 = n - (this.fReplacementOffset + this.fReplacementLength);
            if (n3 > 0) {
                this.fReplacementLength += n3;
            }
            if (c == '\u0000') {
                string = this.fReplacementString;
            } else {
                StringBuffer stringBuffer = new StringBuffer(this.fReplacementString);
                if (this.fCursorPosition > 0 && this.fCursorPosition <= stringBuffer.length() && stringBuffer.charAt(this.fCursorPosition - 1) != c) {
                    stringBuffer.insert(this.fCursorPosition, c);
                    ++this.fCursorPosition;
                }
                string = stringBuffer.toString();
            }
            int n4 = this.fReplacementOffset + this.fReplacementLength;
            ReferenceTracker referenceTracker = new ReferenceTracker();
            referenceTracker.preReplace(iDocument, n4);
            this.replace(iDocument, this.fReplacementOffset, this.fReplacementLength, string);
            n4 = referenceTracker.postReplace(iDocument);
            this.fReplacementOffset = n4 - (string == null ? 0 : string.length());
            if (this.fTextViewer != null && string != null && (n2 = string.indexOf("()")) != -1 && n2 + 1 == this.fCursorPosition) {
                CUIPlugin.getDefault().getPreferenceStore();
                int n5 = this.fReplacementOffset + this.fCursorPosition;
                LinkedPositionGroup linkedPositionGroup = new LinkedPositionGroup();
                linkedPositionGroup.addPosition(new LinkedPosition(iDocument, n5, 0, -1));
                LinkedModeModel linkedModeModel = new LinkedModeModel();
                linkedModeModel.addGroup(linkedPositionGroup);
                linkedModeModel.forceInstall();
                EditorLinkedModeUI editorLinkedModeUI = new EditorLinkedModeUI(linkedModeModel, this.fTextViewer);
                editorLinkedModeUI.setSimpleMode(true);
                editorLinkedModeUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(')'));
                editorLinkedModeUI.setExitPosition(this.fTextViewer, n5 + 1, 0, Integer.MAX_VALUE);
                editorLinkedModeUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                editorLinkedModeUI.enter();
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void replace(IDocument iDocument, int n, int n2, String string) throws BadLocationException {
        if (!iDocument.get(n, n2).equals(string)) {
            iDocument.replace(n, n2, string);
        }
    }

    public void apply(IDocument iDocument) {
        this.apply(iDocument, '\u0000', this.fReplacementOffset + this.fReplacementLength);
    }

    public Point getSelection(IDocument iDocument) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public String getAdditionalProposalInfo() {
        if (this.fProposalInfo != null) {
            return this.fProposalInfo;
        }
        return null;
    }

    public char[] getTriggerCharacters() {
        return this.fTriggerCharacters;
    }

    public int getContextInformationPosition() {
        return this.fReplacementOffset + this.fContextInformationPosition;
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public int getPrefixCompletionStart(IDocument iDocument, int n) {
        return this.getReplacementOffset();
    }

    public void setReplacementOffset(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fReplacementOffset = n;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public void setReplacementLength(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fReplacementLength = n;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public CharSequence getPrefixCompletionText(IDocument iDocument, int n) {
        String string = this.getReplacementString();
        int n2 = string.indexOf(40);
        if (n2 > 0) {
            return string.subSequence(0, n2);
        }
        return string;
    }

    public void setReplacementString(String string) {
        this.fReplacementString = string;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public boolean isValidFor(IDocument iDocument, int n) {
        return this.validate(iDocument, n, null);
    }

    public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
        if (n < this.fReplacementOffset) {
            return false;
        }
        boolean bl = this.startsWith(iDocument, n, this.fDisplayString);
        if (bl && documentEvent != null) {
            int n2 = (documentEvent.fText == null ? 0 : documentEvent.fText.length()) - documentEvent.fLength;
            this.fReplacementLength += n2;
        }
        return bl;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int n) {
        this.fRelevance = n;
    }

    protected boolean startsWith(IDocument iDocument, int n, String string) {
        int n2;
        int n3 = n2 = string == null ? 0 : string.length();
        if (n > this.fReplacementOffset + n2) {
            return false;
        }
        try {
            int n4 = n - this.fReplacementOffset;
            String string2 = iDocument.get(this.fReplacementOffset, n4);
            return string.substring(0, n4).equalsIgnoreCase(string2);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static boolean insertCompletion() {
        IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean("content_assist_autoinsert");
    }

    public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
        IDocument iDocument = iTextViewer.getDocument();
        Point point = iTextViewer.getSelectedRange();
        boolean bl = this.fToggleEating = (n & SWT.MOD1) != 0;
        if (CCompletionProposal.insertCompletion() ^ this.fToggleEating) {
            this.fReplacementLength = point.x + point.y - this.fReplacementOffset;
        }
        this.apply(iDocument, c, n2);
        this.fToggleEating = false;
    }

    private static Color getForegroundColor(StyledText styledText) {
        IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"content_assist_proposals_foreground");
        CTextTools cTextTools = CUIPlugin.getDefault().getTextTools();
        return cTextTools.getColorManager().getColor(rGB);
    }

    private static Color getBackgroundColor(StyledText styledText) {
        IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)"content_assist_proposals_background");
        CTextTools cTextTools = CUIPlugin.getDefault().getTextTools();
        return cTextTools.getColorManager().getColor(rGB);
    }

    private void repairPresentation(ITextViewer iTextViewer) {
        if (this.fRememberedStyleRange != null) {
            if (iTextViewer instanceof ITextViewerExtension2) {
                ITextViewerExtension2 iTextViewerExtension2 = (ITextViewerExtension2)iTextViewer;
                if (iTextViewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iTextViewer;
                    IRegion iRegion = iTextViewerExtension5.modelRange2WidgetRange((IRegion)new Region(this.fRememberedStyleRange.start, this.fRememberedStyleRange.length));
                    if (iRegion != null) {
                        iTextViewerExtension2.invalidateTextPresentation(iRegion.getOffset(), iRegion.getLength());
                    }
                } else {
                    iTextViewerExtension2.invalidateTextPresentation(this.fRememberedStyleRange.start + iTextViewer.getVisibleRegion().getOffset(), this.fRememberedStyleRange.length);
                }
            } else {
                iTextViewer.invalidateTextPresentation();
            }
        }
    }

    private void updateStyle(ITextViewer iTextViewer) {
        ITextViewerExtension5 iTextViewerExtension5;
        StyledText styledText = iTextViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return;
        }
        int n = styledText.getCaretOffset();
        int n2 = 0;
        if (iTextViewer instanceof ITextViewerExtension5) {
            iTextViewerExtension5 = (ITextViewerExtension5)iTextViewer;
            n2 = iTextViewerExtension5.widgetOffset2ModelOffset(n);
        } else {
            iTextViewerExtension5 = iTextViewer.getVisibleRegion();
            n2 = n + iTextViewerExtension5.getOffset();
        }
        if (n2 >= this.fReplacementOffset + this.fReplacementLength) {
            this.repairPresentation(iTextViewer);
            return;
        }
        int n3 = n;
        int n4 = this.fReplacementOffset + this.fReplacementLength - n2;
        Color color = CCompletionProposal.getForegroundColor(styledText);
        Color color2 = CCompletionProposal.getBackgroundColor(styledText);
        StyleRange styleRange = styledText.getStyleRangeAtOffset(n3);
        int n5 = styleRange != null ? styleRange.fontStyle : 0;
        this.repairPresentation(iTextViewer);
        this.fRememberedStyleRange = new StyleRange(n3, n4, color, color2, n5);
        try {
            styledText.setStyleRange(this.fRememberedStyleRange);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fRememberedStyleRange = null;
        }
    }

    public void selected(ITextViewer iTextViewer, boolean bl) {
        if (!CCompletionProposal.insertCompletion() ^ bl) {
            this.updateStyle(iTextViewer);
        } else {
            this.repairPresentation(iTextViewer);
            this.fRememberedStyleRange = null;
        }
    }

    public void unselected(ITextViewer iTextViewer) {
        this.repairPresentation(iTextViewer);
        this.fRememberedStyleRange = null;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return null;
    }

    public void updateReplacementOffset(int n) {
        this.setReplacementOffset(n);
    }

    public void updateReplacementLength(int n) {
        this.setReplacementLength(n);
    }

    public int hashCode() {
        return this.fDisplayString.hashCode() + this.fReplacementString.hashCode() + (this.fContextInformation == null ? 0 : this.fContextInformation.hashCode());
    }

    public boolean equals(Object object) {
        if (!(object instanceof CCompletionProposal)) {
            return false;
        }
        if (!this.fDisplayString.equals(((CCompletionProposal)object).fDisplayString)) {
            return false;
        }
        if (!this.fReplacementString.equals(((CCompletionProposal)object).fReplacementString)) {
            return false;
        }
        return this.fContextInformation == null || ((CCompletionProposal)object).fContextInformation == null || this.fContextInformation.equals((Object)((CCompletionProposal)object).fContextInformation);
    }

    private static final class ReferenceTracker {
        private static final String CATEGORY = "reference_position";
        private final IPositionUpdater fPositionUpdater = new DefaultPositionUpdater("reference_position");
        private final Position fPosition = new Position(0);

        ReferenceTracker() {
        }

        public void preReplace(IDocument iDocument, int n) throws BadLocationException {
            this.fPosition.setOffset(n);
            try {
                iDocument.addPositionCategory(CATEGORY);
                iDocument.addPositionUpdater(this.fPositionUpdater);
                iDocument.addPosition(CATEGORY, this.fPosition);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                CUIPlugin.getDefault().log(badPositionCategoryException);
            }
        }

        public int postReplace(IDocument iDocument) {
            try {
                iDocument.removePosition(CATEGORY, this.fPosition);
                iDocument.removePositionUpdater(this.fPositionUpdater);
                iDocument.removePositionCategory(CATEGORY);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                CUIPlugin.getDefault().log(badPositionCategoryException);
            }
            return this.fPosition.getOffset();
        }
    }

    protected static class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;

        public ExitPolicy(char c) {
            this.fExitCharacter = c;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel linkedModeModel, VerifyEvent verifyEvent, int n, int n2) {
            if (verifyEvent.character == this.fExitCharacter) {
                if (linkedModeModel.anyPositionContains(n)) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
                return new LinkedModeUI.ExitFlags(2, true);
            }
            switch (verifyEvent.character) {
                case ';': {
                    return new LinkedModeUI.ExitFlags(0, true);
                }
            }
            return null;
        }
    }
}

