/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.ASTUtil;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.parser.scanner2.FunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectStyleMacro;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.text.contentassist.ContentAssistElementRequestor;
import org.eclipse.cdt.internal.ui.text.contentassist.ICompletionRequestor;
import org.eclipse.cdt.internal.ui.text.contentassist.Problem;
import org.eclipse.cdt.internal.ui.text.contentassist.RelevanceConstants;
import org.eclipse.cdt.internal.ui.util.IDebugLogConstants;
import org.eclipse.cdt.internal.ui.util.Util;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;

public class CompletionEngine
implements RelevanceConstants {
    ICompletionRequestor requestor;
    int completionStart = 0;
    int completionLength = 0;
    int completionOrigin = 0;
    IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
    private Map macroMap = null;
    private ContentAssistElementRequestor elementRequestor = null;
    private static final String exceptionKeyword = "...";

    public CompletionEngine(ICompletionRequestor iCompletionRequestor) {
        this.requestor = iCompletionRequestor;
        this.elementRequestor = new ContentAssistElementRequestor();
    }

    private int computeCaseMatchingRelevance(String string, String string2) {
        if (CharOperation.prefixEquals((char[])string.toCharArray(), (char[])string2.toCharArray(), (boolean)true)) {
            if (CharOperation.equals((char[])string.toCharArray(), (char[])string2.toCharArray(), (boolean)true)) {
                return 200;
            }
            return 160;
        }
        return 0;
    }

    private int computeTypeRelevance(int n) {
        switch (n) {
            case 76: {
                return 140;
            }
            case 69: {
                return 130;
            }
            case 74: 
            case 75: {
                return 120;
            }
            case 67: 
            case 68: {
                return 110;
            }
            case 70: 
            case 71: {
                return 100;
            }
            case 64: {
                return 90;
            }
            case 65: {
                return 80;
            }
            case 66: {
                return 70;
            }
            case 78: {
                return 60;
            }
            case 61: {
                return 50;
            }
            case 77: {
                return 40;
            }
            case 63: {
                return 30;
            }
            case 79: {
                return 20;
            }
        }
        return 0;
    }

    public int computeRelevance(int n, String string, String string2) {
        int n2 = this.computeTypeRelevance(n);
        return n2 += this.computeCaseMatchingRelevance(string, string2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IASTCompletionNode parse(IWorkingCopy iWorkingCopy, int n) {
        IScannerInfo iScannerInfo;
        IResource iResource = iWorkingCopy.getResource();
        IPath iPath = iResource.getLocation();
        IProject iProject = iResource.getProject();
        CodeReader codeReader = new CodeReader(iPath.toOSString(), iWorkingCopy.getContents());
        ScannerInfo scannerInfo = new ScannerInfo();
        IScannerInfoProvider iScannerInfoProvider = CCorePlugin.getDefault().getScannerInfoProvider(iProject);
        if (iScannerInfoProvider != null && (iScannerInfo = iScannerInfoProvider.getScannerInformation(iResource)) != null) {
            scannerInfo = new ScannerInfo(iScannerInfo.getDefinedSymbols(), iScannerInfo.getIncludePaths());
        }
        iScannerInfo = CoreModel.hasCCNature((IProject)iProject) ? ParserLanguage.CPP : ParserLanguage.C;
        IParser iParser = null;
        IScanner iScanner = null;
        try {
            iScanner = ParserFactory.createScanner((CodeReader)codeReader, (IScannerInfo)scannerInfo, (ParserMode)ParserMode.COMPLETION_PARSE, (ParserLanguage)iScannerInfo, (ISourceElementRequestor)this.elementRequestor, (IParserLogService)ParserUtil.getScannerLogService(), Arrays.asList(CUIPlugin.getSharedWorkingCopies()));
            iParser = ParserFactory.createParser((IScanner)iScanner, (ISourceElementRequestor)this.elementRequestor, (ParserMode)ParserMode.COMPLETION_PARSE, (ParserLanguage)iScannerInfo, (IParserLogService)ParserUtil.getParserLogService());
            this.elementRequestor.setParser(iParser);
        }
        catch (ParserFactoryError parserFactoryError) {}
        if (iParser == null) {
            return null;
        }
        IASTCompletionNode iASTCompletionNode = null;
        try {
            try {
                IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
                int n2 = iPreferenceStore.getInt("content_assist_timeout_delay");
                if (n2 > 0) {
                    this.elementRequestor.setTimeout(n2);
                }
                this.elementRequestor.startTimer();
                long l = System.currentTimeMillis();
                this.macroMap = null;
                iASTCompletionNode = iParser.parse(n);
                this.log("Time spent in Parser = " + (System.currentTimeMillis() - l) + " ms");
                this.macroMap = iScanner.getDefinitions();
            }
            catch (ParseError parseError) {
                if (parseError.getErrorKind() == ParseError.ParseErrorKind.TIMEOUT_OR_CANCELLED) {
                    this.log("Timeout received !!!!!! ");
                    this.requestor.acceptError(new Problem(CUIMessages.getString("CEditor.contentassist.timeout")));
                }
            }
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            this.elementRequestor.stopTimer();
            throw throwable;
        }
        {
            Object var17_19 = null;
            this.elementRequestor.stopTimer();
            return iASTCompletionNode;
        }
    }

    private void addNodeToCompletions(IASTNode iASTNode, String string, int n, boolean bl, boolean bl2, int n2) {
        if (iASTNode instanceof IASTField) {
            IASTField iASTField = (IASTField)iASTNode;
            if (bl2 && !iASTField.isStatic()) {
                return;
            }
            int n3 = this.computeRelevance(69, string, iASTField.getName());
            this.requestor.acceptField(iASTField.getName(), ASTUtil.getType((IASTAbstractDeclaration)iASTField.getAbstractDeclaration()), iASTField.getVisiblity(), this.completionStart, this.completionLength, n3);
        } else if (iASTNode instanceof IASTParameterDeclaration) {
            IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iASTNode;
            int n4 = this.computeRelevance(76, string, iASTParameterDeclaration.getName());
            this.requestor.acceptLocalVariable(iASTParameterDeclaration.getName(), ASTUtil.getType((IASTAbstractDeclaration)iASTParameterDeclaration), this.completionStart, this.completionLength, n4);
        } else if (iASTNode instanceof IASTVariable) {
            IASTVariable iASTVariable = (IASTVariable)iASTNode;
            IASTScope iASTScope = iASTVariable.getOwnerScope();
            if (iASTScope instanceof IASTCodeScope) {
                int n5 = this.computeRelevance(76, string, iASTVariable.getName());
                this.requestor.acceptLocalVariable(iASTVariable.getName(), ASTUtil.getType((IASTAbstractDeclaration)iASTVariable.getAbstractDeclaration()), this.completionStart, this.completionLength, n5);
            } else {
                if (bl2 && !iASTVariable.isStatic()) {
                    return;
                }
                int n6 = this.computeRelevance(74, string, iASTVariable.getName());
                this.requestor.acceptVariable(iASTVariable.getName(), ASTUtil.getType((IASTAbstractDeclaration)iASTVariable.getAbstractDeclaration()), this.completionStart, this.completionLength, n6);
            }
        } else if (iASTNode instanceof IASTMethod) {
            IASTMethod iASTMethod = (IASTMethod)iASTNode;
            if (bl && !iASTMethod.isStatic()) {
                return;
            }
            int n7 = this.computeRelevance(67, string, iASTMethod.getName());
            String string2 = ASTUtil.getParametersString((String[])ASTUtil.getFunctionParameterTypes((IASTFunction)iASTMethod));
            int n8 = this.completionOrigin;
            if (n2 > -1 && string2.length() > 0) {
                int n9 = 0;
                int n10 = 0;
                while (n10 < n2) {
                    n9 = string2.indexOf(44, n9);
                    ++n10;
                }
                n8 -= n9;
            }
            this.requestor.acceptMethod(iASTMethod.getName(), string2, ASTUtil.getType((IASTAbstractDeclaration)iASTMethod.getReturnType()), iASTMethod.getVisiblity(), this.completionStart, this.completionLength, n7, n2 == -1, n8);
        } else if (iASTNode instanceof IASTFunction) {
            IASTFunction iASTFunction = (IASTFunction)iASTNode;
            if (bl && !iASTFunction.isStatic()) {
                return;
            }
            int n11 = this.computeRelevance(71, string, iASTFunction.getName());
            String string3 = ASTUtil.getParametersString((String[])ASTUtil.getFunctionParameterTypes((IASTFunction)iASTFunction));
            int n12 = this.completionOrigin;
            if (n2 > -1 && string3.length() > 0) {
                int n13 = 0;
                int n14 = 0;
                while (n14 < n2) {
                    n13 = string3.indexOf(44, n13);
                    ++n14;
                }
                n12 -= n13;
            }
            this.requestor.acceptFunction(iASTFunction.getName(), string3, ASTUtil.getType((IASTAbstractDeclaration)iASTFunction.getReturnType()), this.completionStart, this.completionLength, n11, n2 == -1, n12);
        } else if (iASTNode instanceof IASTClassSpecifier) {
            int n15;
            IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTNode;
            ASTClassKind aSTClassKind = iASTClassSpecifier.getClassKind();
            if (aSTClassKind == ASTClassKind.CLASS) {
                n15 = this.computeRelevance(64, string, iASTClassSpecifier.getName());
                this.requestor.acceptClass(iASTClassSpecifier.getName(), this.completionStart, this.completionLength, n15);
            }
            if (aSTClassKind == ASTClassKind.STRUCT && iASTClassSpecifier.getName().length() > 0) {
                n15 = this.computeRelevance(65, string, iASTClassSpecifier.getName());
                this.requestor.acceptStruct(iASTClassSpecifier.getName(), this.completionStart, this.completionLength, n15);
            }
            if (aSTClassKind == ASTClassKind.UNION && iASTClassSpecifier.getName().length() > 0) {
                n15 = this.computeRelevance(66, string, iASTClassSpecifier.getName());
                this.requestor.acceptUnion(iASTClassSpecifier.getName(), this.completionStart, this.completionLength, n15);
            }
        } else if (iASTNode instanceof IASTNamespaceDefinition) {
            IASTNamespaceDefinition iASTNamespaceDefinition = (IASTNamespaceDefinition)iASTNode;
            int n16 = this.computeRelevance(61, string, iASTNamespaceDefinition.getName());
            this.requestor.acceptNamespace(iASTNamespaceDefinition.getName(), this.completionStart, this.completionLength, n16);
        } else if (iASTNode instanceof IASTEnumerationSpecifier) {
            IASTEnumerationSpecifier iASTEnumerationSpecifier = (IASTEnumerationSpecifier)iASTNode;
            if (iASTEnumerationSpecifier.getName().length() > 0) {
                int n17 = this.computeRelevance(63, string, iASTEnumerationSpecifier.getName());
                this.requestor.acceptEnumeration(iASTEnumerationSpecifier.getName(), this.completionStart, this.completionLength, n17);
            }
        } else if (iASTNode instanceof IASTEnumerator) {
            IASTEnumerator iASTEnumerator = (IASTEnumerator)iASTNode;
            int n18 = this.computeRelevance(79, string, iASTEnumerator.getName());
            this.requestor.acceptEnumerator(iASTEnumerator.getName(), this.completionStart, this.completionLength, n18);
        } else if (iASTNode instanceof IASTTypedefDeclaration) {
            IASTTypedefDeclaration iASTTypedefDeclaration = (IASTTypedefDeclaration)iASTNode;
            int n19 = this.computeRelevance(78, string, iASTTypedefDeclaration.getName());
            this.requestor.acceptTypedef(iASTTypedefDeclaration.getName(), this.completionStart, this.completionLength, n19);
        } else if (iASTNode instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTNode;
            ASTClassKind aSTClassKind = iASTElaboratedTypeSpecifier.getClassKind();
            if (aSTClassKind == ASTClassKind.CLASS) {
                int n20 = this.computeRelevance(64, string, iASTElaboratedTypeSpecifier.getName());
                this.requestor.acceptClass(iASTElaboratedTypeSpecifier.getName(), this.completionStart, this.completionLength, n20);
            } else if (aSTClassKind == ASTClassKind.STRUCT) {
                int n21 = this.computeRelevance(65, string, iASTElaboratedTypeSpecifier.getName());
                this.requestor.acceptStruct(iASTElaboratedTypeSpecifier.getName(), this.completionStart, this.completionLength, n21);
            } else if (aSTClassKind == ASTClassKind.UNION) {
                int n22 = this.computeRelevance(66, string, iASTElaboratedTypeSpecifier.getName());
                this.requestor.acceptUnion(iASTElaboratedTypeSpecifier.getName(), this.completionStart, this.completionLength, n22);
            } else if (aSTClassKind == ASTClassKind.ENUM) {
                int n23 = this.computeRelevance(63, string, iASTElaboratedTypeSpecifier.getName());
                this.requestor.acceptEnumeration(iASTElaboratedTypeSpecifier.getName(), this.completionStart, this.completionLength, n23);
            }
        }
    }

    private void addKeywordToCompletions(String string) {
        int n = 10;
        this.requestor.acceptKeyword(string, this.completionStart, this.completionLength, n);
    }

    private void addKeywordsToCompletions(Iterator iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.addKeywordToCompletions(string);
            ++n;
        }
        this.log("No of Keywords       = " + n);
    }

    private void addMacroToCompletions(String string, String string2) {
        int n = this.computeRelevance(77, string, string2);
        this.requestor.acceptMacro(string2, this.completionStart, this.completionLength, n, this.completionOrigin);
    }

    private void addMacrosToCompletions(String string, Iterator iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            this.addMacroToCompletions(string, string2);
            ++n;
        }
        this.log("No of Macros         = " + n);
    }

    private void addToCompletions(IASTNode.ILookupResult iLookupResult) {
        this.addToCompletions(iLookupResult, false, false, -1);
    }

    private void addToCompletions(IASTNode.ILookupResult iLookupResult, boolean bl, boolean bl2, int n) {
        if (iLookupResult == null) {
            this.log("Lookup Results       = null ................. !!! No Lookup Results found !!! ");
            return;
        }
        Iterator iterator = iLookupResult.getNodes();
        int n2 = iLookupResult.getResultsSize();
        this.log("No of Lookup Results = " + n2);
        while (iterator.hasNext()) {
            IASTNode iASTNode = (IASTNode)iterator.next();
            this.addNodeToCompletions(iASTNode, iLookupResult.getPrefix(), n2, bl, bl2, n);
        }
    }

    private IASTNode.ILookupResult lookup(IASTScope iASTScope, String string, IASTNode.LookupKind[] lookupKindArray, IASTNode iASTNode, IASTExpression iASTExpression) {
        try {
            this.logLookups(lookupKindArray);
            IASTNode.ILookupResult iLookupResult = iASTScope.lookup(string, lookupKindArray, iASTNode, iASTExpression);
            return iLookupResult;
        }
        catch (IASTNode.LookupError lookupError) {
            lookupError.printStackTrace();
            return null;
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {
            aSTNotImplementedException.printStackTrace();
            return null;
        }
    }

    private List lookupMacros(String string) {
        TreeSet treeSet = new TreeSet(this.macroMap.keySet());
        Iterator iterator = treeSet.iterator();
        int n = string.length();
        String string2 = string.toUpperCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        String string4 = null;
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            if (string3.length() < n) continue;
            string4 = string3.length() > n ? string3.substring(0, n).toUpperCase() : string3;
            if (string4.equals(string2)) {
                Object object;
                Object v = this.macroMap.get(string3);
                if (v instanceof FunctionStyleMacro) {
                    object = (FunctionStyleMacro)v;
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(object.name));
                    stringBuffer.append("(");
                    if (object.arglist != null) {
                        int n2 = 0;
                        while (n2 < object.arglist.length) {
                            if (object.arglist[n2] != null) {
                                stringBuffer.append(object.arglist[n2]);
                            }
                            if (n2 != object.arglist.length - 1 && object.arglist[n2 + 1] != null) {
                                stringBuffer.append(",");
                            }
                            ++n2;
                        }
                    }
                    stringBuffer.append(")");
                    String string5 = stringBuffer.toString();
                    arrayList.add(string5);
                    continue;
                }
                if (!(v instanceof ObjectStyleMacro)) continue;
                object = String.valueOf(((ObjectStyleMacro)v).name);
                arrayList.add((String)object);
                continue;
            }
            if (string3.compareTo(string) > 0) break;
        }
        return arrayList;
    }

    private void completionOnMemberReference(IASTCompletionNode iASTCompletionNode) {
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        IASTNode.ILookupResult iLookupResult = null;
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.FIELDS, IASTNode.LookupKind.METHODS, IASTNode.LookupKind.ENUMERATORS};
        iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext(), null);
        this.addToCompletions(iLookupResult);
    }

    private void completionOnScopedReference(IASTCompletionNode iASTCompletionNode) {
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL};
        IASTNode.ILookupResult iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext(), null);
        if (iASTCompletionNode.getCompletionContext() != null && iASTCompletionNode.getCompletionContext() instanceof IASTClassSpecifier && ((IASTClassSpecifier)iASTCompletionNode.getCompletionContext()).getClassKind() != ASTClassKind.ENUM) {
            if (iASTCompletionNode.getCompletionScope() instanceof IASTCodeScope) {
                this.addToCompletions(iLookupResult, true, true, -1);
            } else {
                this.addToCompletions(iLookupResult, false, true, -1);
            }
        } else {
            this.addToCompletions(iLookupResult);
        }
    }

    private void completionOnTypeReference(IASTCompletionNode iASTCompletionNode) {
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        if (iASTCompletionNode.getCompletionPrefix().length() > 0 || iASTCompletionNode.getCompletionContext() != null) {
            IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.STRUCTURES, IASTNode.LookupKind.ENUMERATIONS, IASTNode.LookupKind.NAMESPACES, IASTNode.LookupKind.TYPEDEFS};
            IASTNode.ILookupResult iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext(), null);
            this.addToCompletions(iLookupResult);
        }
    }

    private void completionOnFieldType(IASTCompletionNode iASTCompletionNode) {
        IASTClassSpecifier iASTClassSpecifier;
        this.completionOnTypeReference(iASTCompletionNode);
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        if (iASTCompletionNode.getCompletionPrefix().length() == 0 && iASTScope instanceof IASTClassSpecifier && (iASTClassSpecifier = (IASTClassSpecifier)iASTScope).getClassKind() == ASTClassKind.CLASS) {
            IASTNode.ILookupResult iLookupResult = null;
            IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.STRUCTURES};
            iLookupResult = this.lookup(iASTScope, iASTClassSpecifier.getName(), lookupKindArray, iASTCompletionNode.getCompletionContext(), null);
            this.addToCompletions(iLookupResult);
        }
    }

    private void completionOnVariableType(IASTCompletionNode iASTCompletionNode) {
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.STRUCTURES, IASTNode.LookupKind.ENUMERATIONS, IASTNode.LookupKind.NAMESPACES, IASTNode.LookupKind.TYPEDEFS, IASTNode.LookupKind.CONSTRUCTORS};
        IASTNode.ILookupResult iLookupResult = this.lookup(iASTCompletionNode.getCompletionScope(), iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext(), null);
        this.addToCompletions(iLookupResult);
    }

    private void completionOnSingleNameReference(IASTCompletionNode iASTCompletionNode) {
        Object object;
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        String string = iASTCompletionNode.getCompletionPrefix();
        IASTNode.ILookupResult iLookupResult = null;
        if (iASTCompletionNode.getCompletionPrefix().length() > 0) {
            object = new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL};
            iLookupResult = this.lookup(iASTScope, string, (IASTNode.LookupKind[])object, iASTCompletionNode.getCompletionContext(), null);
            this.addToCompletions(iLookupResult);
        } else if (iASTScope instanceof IASTCodeScope) {
            if (((IASTCodeScope)iASTScope).getContainingFunction() instanceof IASTMethod) {
                object = new IASTNode.LookupKind[]{IASTNode.LookupKind.THIS};
                iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), (IASTNode.LookupKind[])object, iASTCompletionNode.getCompletionContext(), null);
                this.addToCompletions(iLookupResult);
                object = new IASTNode.LookupKind[]{IASTNode.LookupKind.LOCAL_VARIABLES};
                iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), (IASTNode.LookupKind[])object, iASTCompletionNode.getCompletionContext(), null);
                this.addToCompletions(iLookupResult);
            } else {
                object = new IASTNode.LookupKind[]{IASTNode.LookupKind.LOCAL_VARIABLES};
                iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), (IASTNode.LookupKind[])object, iASTCompletionNode.getCompletionContext(), null);
                this.addToCompletions(iLookupResult);
            }
        } else {
            object = new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL};
            iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), (IASTNode.LookupKind[])object, iASTCompletionNode.getCompletionContext(), null);
            this.addToCompletions(iLookupResult);
        }
        object = this.lookupMacros(iASTCompletionNode.getCompletionPrefix());
        this.addMacrosToCompletions(string, object.iterator());
    }

    private void completionOnClassReference(IASTCompletionNode iASTCompletionNode) {
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.CLASSES};
        IASTNode.ILookupResult iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext(), null);
        this.addToCompletions(iLookupResult);
    }

    private void completionOnStructReference(IASTCompletionNode iASTCompletionNode) {
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.STRUCTS};
        IASTNode.ILookupResult iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext(), null);
        this.addToCompletions(iLookupResult);
    }

    private void completionOnUnionReference(IASTCompletionNode iASTCompletionNode) {
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.UNIONS};
        IASTNode.ILookupResult iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext(), null);
        this.addToCompletions(iLookupResult);
    }

    private void completionOnEnumReference(IASTCompletionNode iASTCompletionNode) {
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.ENUMERATIONS};
        IASTNode.ILookupResult iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext(), null);
        this.addToCompletions(iLookupResult);
    }

    private void completionOnNamespaceReference(IASTCompletionNode iASTCompletionNode) {
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.NAMESPACES};
        IASTNode.ILookupResult iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext(), null);
        this.addToCompletions(iLookupResult);
    }

    private void completionOnExceptionReference(IASTCompletionNode iASTCompletionNode) {
        this.completionOnTypeReference(iASTCompletionNode);
        if (iASTCompletionNode.getCompletionPrefix().length() == 0) {
            this.addKeywordToCompletions(exceptionKeyword);
        }
    }

    private void completionOnMacroReference(IASTCompletionNode iASTCompletionNode) {
        List list = this.lookupMacros(iASTCompletionNode.getCompletionPrefix());
        this.addMacrosToCompletions(iASTCompletionNode.getCompletionPrefix(), list.iterator());
    }

    private void completionOnNewTypeReference(IASTCompletionNode iASTCompletionNode) {
        this.completionOnTypeReference(iASTCompletionNode);
    }

    private void completionOnConstructorReference(IASTCompletionNode iASTCompletionNode) {
        IASTScope iASTScope = iASTCompletionNode.getCompletionScope();
        if (iASTCompletionNode.getFunctionName().length() > 0 && iASTCompletionNode.getCompletionContext() == null) {
            IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.STRUCTURES};
            IASTNode.ILookupResult iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getFunctionName(), lookupKindArray, null, null);
            if (iLookupResult != null && iLookupResult.getResultsSize() == 1) {
                IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iLookupResult.getNodes().next();
                lookupKindArray[0] = IASTNode.LookupKind.CONSTRUCTORS;
                iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, (IASTNode)iASTClassSpecifier, iASTCompletionNode.getFunctionParameters());
                this.addToCompletions(iLookupResult, false, false, iLookupResult.getIndexOfNextParameter());
            }
        } else {
            IASTNode.LookupKind[] lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.CONSTRUCTORS};
            IASTNode.ILookupResult iLookupResult = this.lookup(iASTScope, iASTCompletionNode.getCompletionPrefix(), lookupKindArray, iASTCompletionNode.getCompletionContext(), null);
            this.addToCompletions(iLookupResult);
        }
    }

    private void completionOnFunctionReference(IASTCompletionNode iASTCompletionNode) {
        String string = iASTCompletionNode.getCompletionPrefix();
        boolean bl = false;
        IASTNode.LookupKind[] lookupKindArray = null;
        if (string.length() == 0) {
            lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.CONSTRUCTORS, IASTNode.LookupKind.FUNCTIONS, IASTNode.LookupKind.METHODS};
            string = iASTCompletionNode.getFunctionName();
            bl = true;
        } else {
            lookupKindArray = new IASTNode.LookupKind[]{IASTNode.LookupKind.ALL};
        }
        IASTNode.ILookupResult iLookupResult = this.lookup(iASTCompletionNode.getCompletionScope(), string, lookupKindArray, iASTCompletionNode.getCompletionContext(), iASTCompletionNode.getFunctionParameters());
        if (iLookupResult != null) {
            this.addToCompletions(iLookupResult, false, false, bl ? iLookupResult.getIndexOfNextParameter() : -1);
        }
        if (!bl) {
            List list = this.lookupMacros(iASTCompletionNode.getCompletionPrefix());
            this.addMacrosToCompletions(string, list.iterator());
        }
    }

    public IASTCompletionNode complete(IWorkingCopy iWorkingCopy, int n) {
        this.log("");
        long l = System.currentTimeMillis();
        IASTCompletionNode iASTCompletionNode = this.parse(iWorkingCopy, n);
        if (iASTCompletionNode == null) {
            this.log("Null Completion Node Error");
            return null;
        }
        this.log("Offset  = " + n);
        this.logNode("Scope   = ", (IASTNode)iASTCompletionNode.getCompletionScope());
        this.logNode("Context = ", iASTCompletionNode.getCompletionContext());
        this.logKind("Kind    = ", iASTCompletionNode.getCompletionKind());
        this.log("Prefix  = " + iASTCompletionNode.getCompletionPrefix());
        if (iASTCompletionNode.getCompletionScope() == null) {
            this.log("Null Completion Scope Error");
            return null;
        }
        if (iASTCompletionNode.getCompletionKind() == IASTCompletionNode.CompletionKind.NO_SUCH_KIND) {
            this.log("Invalid Completion Kind Error");
            return null;
        }
        this.completionOrigin = n;
        this.completionStart = n - iASTCompletionNode.getCompletionPrefix().length();
        this.completionLength = iASTCompletionNode.getCompletionPrefix().length();
        IASTCompletionNode.CompletionKind completionKind = iASTCompletionNode.getCompletionKind();
        if (completionKind == IASTCompletionNode.CompletionKind.MEMBER_REFERENCE) {
            this.completionOnMemberReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.FIELD_TYPE) {
            if (iASTCompletionNode.getCompletionContext() == null) {
                this.completionOnFieldType(iASTCompletionNode);
            } else {
                this.completionOnScopedReference(iASTCompletionNode);
            }
        } else if (completionKind == IASTCompletionNode.CompletionKind.VARIABLE_TYPE) {
            if (iASTCompletionNode.getCompletionContext() != null) {
                this.completionOnVariableType(iASTCompletionNode);
            } else {
                this.completionOnTypeReference(iASTCompletionNode);
            }
        } else if (completionKind == IASTCompletionNode.CompletionKind.ARGUMENT_TYPE) {
            this.completionOnTypeReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE) {
            if (iASTCompletionNode.getCompletionContext() == null) {
                this.completionOnSingleNameReference(iASTCompletionNode);
            } else {
                this.completionOnScopedReference(iASTCompletionNode);
            }
        } else if (completionKind == IASTCompletionNode.CompletionKind.TYPE_REFERENCE) {
            this.completionOnTypeReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.CLASS_REFERENCE) {
            this.completionOnClassReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.NAMESPACE_REFERENCE) {
            this.completionOnNamespaceReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.EXCEPTION_REFERENCE) {
            this.completionOnExceptionReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.MACRO_REFERENCE) {
            this.completionOnMacroReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.NEW_TYPE_REFERENCE) {
            this.completionOnNewTypeReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.FUNCTION_REFERENCE) {
            this.completionOnFunctionReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.CONSTRUCTOR_REFERENCE) {
            this.completionOnConstructorReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.STRUCT_REFERENCE) {
            this.completionOnStructReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.UNION_REFERENCE) {
            this.completionOnUnionReference(iASTCompletionNode);
        } else if (completionKind == IASTCompletionNode.CompletionKind.ENUM_REFERENCE) {
            this.completionOnEnumReference(iASTCompletionNode);
        }
        if (completionKind != IASTCompletionNode.CompletionKind.MEMBER_REFERENCE) {
            this.addKeywordsToCompletions(iASTCompletionNode.getKeywords());
        }
        this.log("Time spent in Completion Engine = " + (System.currentTimeMillis() - l) + " ms");
        return iASTCompletionNode;
    }

    private void logKind(String string, IASTCompletionNode.CompletionKind completionKind) {
        if (!CUIPlugin.getDefault().isDebugging() && Util.isActive(IDebugLogConstants.CONTENTASSIST)) {
            return;
        }
        String string2 = "";
        if (completionKind == IASTCompletionNode.CompletionKind.MEMBER_REFERENCE) {
            string2 = "MEMBER_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.FIELD_TYPE) {
            string2 = "FIELD_TYPE Class Scope";
        } else if (completionKind == IASTCompletionNode.CompletionKind.VARIABLE_TYPE) {
            string2 = "VARIABLE_TYPE Global Scope";
        } else if (completionKind == IASTCompletionNode.CompletionKind.ARGUMENT_TYPE) {
            string2 = "ARGUMENT_TYPE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE) {
            string2 = "SINGLE_NAME_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.TYPE_REFERENCE) {
            string2 = "TYPE_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.CLASS_REFERENCE) {
            string2 = "CLASS_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.NAMESPACE_REFERENCE) {
            string2 = "NAMESPACE_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.EXCEPTION_REFERENCE) {
            string2 = "EXCEPTION_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.MACRO_REFERENCE) {
            string2 = "MACRO_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.CONSTRUCTOR_REFERENCE) {
            string2 = "CONSTRUCTOR_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.NEW_TYPE_REFERENCE) {
            string2 = "NEW_TYPE_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.PREPROCESSOR_DIRECTIVE) {
            string2 = "PREPROCESSOR_DIRECTIVE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.STRUCT_REFERENCE) {
            string2 = "STRUCT_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.UNION_REFERENCE) {
            string2 = "UNION_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.ENUM_REFERENCE) {
            string2 = "ENUM_REFERENCE";
        } else if (completionKind == IASTCompletionNode.CompletionKind.NO_SUCH_KIND) {
            string2 = "NO_SUCH_KIND";
        }
        this.log(String.valueOf(string) + string2);
    }

    private void logNode(String string, IASTNode iASTNode) {
        if (!CUIPlugin.getDefault().isDebugging() && Util.isActive(IDebugLogConstants.CONTENTASSIST)) {
            return;
        }
        if (iASTNode == null) {
            this.log(String.valueOf(string) + "null");
            return;
        }
        if (iASTNode instanceof IASTMethod) {
            String string2 = "Method: ";
            string2 = String.valueOf(string2) + ((IASTMethod)iASTNode).getName();
            this.log(String.valueOf(string) + string2);
            return;
        }
        if (iASTNode instanceof IASTFunction) {
            String string3 = "Function: ";
            string3 = String.valueOf(string3) + ((IASTFunction)iASTNode).getName();
            this.log(String.valueOf(string) + string3);
            return;
        }
        if (iASTNode instanceof IASTClassSpecifier) {
            String string4 = "Class: ";
            string4 = String.valueOf(string4) + ((IASTClassSpecifier)iASTNode).getName();
            this.log(String.valueOf(string) + string4);
            return;
        }
        if (iASTNode instanceof IASTCompilationUnit) {
            String string5 = "Global";
            this.log(String.valueOf(string) + string5);
            return;
        }
        if (iASTNode instanceof IASTCodeScope) {
            String string6 = "Code Scope";
            this.log(String.valueOf(string) + string6);
            return;
        }
        if (iASTNode instanceof IASTNamespaceDefinition) {
            String string7 = "Namespace ";
            this.log(String.valueOf(string) + string7);
            return;
        }
        this.log(String.valueOf(string) + iASTNode.toString());
    }

    private void logLookups(IASTNode.LookupKind[] lookupKindArray) {
        if (!CUIPlugin.getDefault().isDebugging() && Util.isActive(IDebugLogConstants.CONTENTASSIST)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("Looking For ");
        int n = 0;
        while (n < lookupKindArray.length) {
            IASTNode.LookupKind lookupKind = lookupKindArray[n];
            if (lookupKind == IASTNode.LookupKind.ALL) {
                stringBuffer.append("ALL");
            } else if (lookupKind == IASTNode.LookupKind.STRUCTURES) {
                stringBuffer.append("STRUCTURES");
            } else if (lookupKind == IASTNode.LookupKind.STRUCTS) {
                stringBuffer.append("STRUCTS");
            } else if (lookupKind == IASTNode.LookupKind.UNIONS) {
                stringBuffer.append("UNIONS");
            } else if (lookupKind == IASTNode.LookupKind.CLASSES) {
                stringBuffer.append("CLASSES");
            } else if (lookupKind == IASTNode.LookupKind.FUNCTIONS) {
                stringBuffer.append("FUNCTIONS");
            } else if (lookupKind == IASTNode.LookupKind.VARIABLES) {
                stringBuffer.append("VARIABLES");
            } else if (lookupKind == IASTNode.LookupKind.LOCAL_VARIABLES) {
                stringBuffer.append("LOCAL_VARIABLES");
            } else if (lookupKind == IASTNode.LookupKind.MEMBERS) {
                stringBuffer.append("MEMBERS");
            } else if (lookupKind == IASTNode.LookupKind.METHODS) {
                stringBuffer.append("METHODS");
            } else if (lookupKind == IASTNode.LookupKind.FIELDS) {
                stringBuffer.append("FIELDS");
            } else if (lookupKind == IASTNode.LookupKind.CONSTRUCTORS) {
                stringBuffer.append("CONSTRUCTORS");
            } else if (lookupKind == IASTNode.LookupKind.NAMESPACES) {
                stringBuffer.append("NAMESPACES");
            } else if (lookupKind == IASTNode.LookupKind.ENUMERATIONS) {
                stringBuffer.append("ENUMERATIONS");
            } else if (lookupKind == IASTNode.LookupKind.ENUMERATORS) {
                stringBuffer.append("ENUMERATORS");
            } else if (lookupKind == IASTNode.LookupKind.THIS) {
                stringBuffer.append("THIS");
            } else if (lookupKind == IASTNode.LookupKind.TYPEDEFS) {
                stringBuffer.append("TYPEDEFS");
            }
            stringBuffer.append(", ");
            ++n;
        }
        this.log(stringBuffer.toString());
    }

    private void log(String string) {
        if (!CUIPlugin.getDefault().isDebugging() && Util.isActive(IDebugLogConstants.CONTENTASSIST)) {
            return;
        }
        Util.debugLog(string, IDebugLogConstants.CONTENTASSIST);
    }
}

