/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.CElementImageProvider;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CProposalContextInformation;
import org.eclipse.cdt.internal.ui.text.contentassist.CompletionRequestorAdaptor;
import org.eclipse.cdt.internal.ui.text.contentassist.IProblem;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.FunctionPrototypeSummary;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;

public class ResultCollector
extends CompletionRequestorAdaptor {
    private static final char[] METHOD_WITH_ARGUMENTS_TRIGGERS = new char[]{'(', '-', ' '};
    private static final char[] METHOD_TRIGGERS = new char[]{';', ',', '.', '\t', '[', ' '};
    private static final char[] TYPE_TRIGGERS = new char[]{'.', '\t', '[', '(', ' '};
    private static final char[] VAR_TRIGGERS = new char[]{'\t', ' ', '[', '(', '=', '-', ';', ',', '.'};
    private final String DEFINE = "#define ";
    private Set completions = new HashSet();
    private ImageDescriptorRegistry registry = CUIPlugin.getImageDescriptorRegistry();
    private IProblem fLastProblem;
    private ITextViewer fTextViewer;

    public ResultCollector() {
        this.completions.clear();
        this.fTextViewer = null;
    }

    public Set getCompletions() {
        return this.completions;
    }

    public void reset(ITextViewer iTextViewer) {
        this.completions.clear();
        this.fTextViewer = iTextViewer;
        this.fLastProblem = null;
    }

    public CCompletionProposal createProposal(String string, String string2, String string3, String string4, int n, Image image, int n2, int n3, int n4) {
        CCompletionProposal cCompletionProposal = new CCompletionProposal(string, n2, n3, image, string2, n4, this.fTextViewer);
        if (string4 != null && string4.length() > 0) {
            CProposalContextInformation cProposalContextInformation = new CProposalContextInformation(string, string4);
            cProposalContextInformation.setContextInformationPosition(n - 1);
            cCompletionProposal.setContextInformation(cProposalContextInformation);
        }
        if (string3 != null && !string2.equals(string3)) {
            cCompletionProposal.setAdditionalProposalInfo(string3);
        }
        return cCompletionProposal;
    }

    public void acceptField(String string, String string2, ASTAccessVisibility aSTAccessVisibility, int n, int n2, int n3) {
        String string3 = "";
        String string4 = "";
        Image image = null;
        StringBuffer stringBuffer = new StringBuffer();
        string3 = string;
        string4 = string;
        if (string2 != null) {
            string4 = String.valueOf(string4) + " : " + string2;
        }
        ImageDescriptor imageDescriptor = CElementImageProvider.getFieldImageDescriptor(aSTAccessVisibility);
        image = this.registry.get(imageDescriptor);
        CCompletionProposal cCompletionProposal = this.createProposal(string3, string4, stringBuffer.toString(), null, 0, image, n, n2, n3);
        cCompletionProposal.setTriggerCharacters(VAR_TRIGGERS);
        this.completions.add(cCompletionProposal);
    }

    public void acceptClass(String string, int n, int n2, int n3) {
        String string2 = "";
        String string3 = "";
        Image image = null;
        StringBuffer stringBuffer = new StringBuffer();
        string2 = string;
        string3 = string;
        ImageDescriptor imageDescriptor = CElementImageProvider.getClassImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal cCompletionProposal = this.createProposal(string2, string3, stringBuffer.toString(), null, 0, image, n, n2, n3);
        cCompletionProposal.setTriggerCharacters(TYPE_TRIGGERS);
        this.completions.add(cCompletionProposal);
    }

    public void acceptFunction(String string, String string2, String string3, int n, int n2, int n3, boolean bl, int n4) {
        FunctionPrototypeSummary functionPrototypeSummary;
        String string4 = "";
        String string5 = "";
        String string6 = "";
        Image image = null;
        StringBuffer stringBuffer = new StringBuffer();
        string4 = string;
        string5 = string;
        String string7 = String.valueOf(string3) + " " + string;
        if (string2 != null) {
            string7 = string2.indexOf("(") == -1 && string2.indexOf(")") == -1 ? String.valueOf(string7) + "(" + string2 + ")" : String.valueOf(string7) + string2;
        }
        if ((functionPrototypeSummary = new FunctionPrototypeSummary(string7)) != null) {
            string4 = String.valueOf(functionPrototypeSummary.getName()) + "()";
            string5 = functionPrototypeSummary.getPrototypeString(true);
            stringBuffer.append(string5);
            string6 = functionPrototypeSummary.getArguments();
        }
        ImageDescriptor imageDescriptor = CElementImageProvider.getFunctionImageDescriptor();
        image = this.registry.get(imageDescriptor);
        if (!bl) {
            string4 = "";
        }
        CCompletionProposal cCompletionProposal = this.createProposal(string4, string5, stringBuffer.toString(), string6, n4, image, n, n2, n3);
        boolean bl2 = string6 != null && string6.length() > 0 && bl;
        char[] cArray = bl2 ? METHOD_WITH_ARGUMENTS_TRIGGERS : METHOD_TRIGGERS;
        cCompletionProposal.setTriggerCharacters(cArray);
        if (bl2) {
            cCompletionProposal.setCursorPosition(string4.length() - 1);
        }
        this.completions.add(cCompletionProposal);
    }

    public void acceptLocalVariable(String string, String string2, int n, int n2, int n3) {
        String string3 = "";
        String string4 = "";
        Image image = null;
        StringBuffer stringBuffer = new StringBuffer();
        string3 = string;
        string4 = string;
        if (string2 != null) {
            string4 = String.valueOf(string4) + " : " + string2;
        }
        ImageDescriptor imageDescriptor = CElementImageProvider.getLocalVariableImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal cCompletionProposal = this.createProposal(string3, string4, stringBuffer.toString(), null, 0, image, n, n2, n3);
        cCompletionProposal.setTriggerCharacters(VAR_TRIGGERS);
        this.completions.add(cCompletionProposal);
    }

    public void acceptMacro(String string, int n, int n2, int n3, int n4) {
        boolean bl;
        FunctionPrototypeSummary functionPrototypeSummary;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        Image image = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string5 = "";
        int n5 = string.indexOf(123);
        string5 = string.startsWith("#define ") ? string.substring("#define ".length(), n5 == -1 ? string.length() : n5) : string;
        int n6 = string5.indexOf(40);
        int n7 = string5.lastIndexOf(41);
        if (n6 == -1 && n7 == -1) {
            string2 = string5;
            string3 = string5;
        } else {
            functionPrototypeSummary = new FunctionPrototypeSummary(string5);
            if (functionPrototypeSummary != null) {
                string2 = String.valueOf(functionPrototypeSummary.getName()) + "()";
                string3 = functionPrototypeSummary.getPrototypeString(true, false);
                stringBuffer.append(string3);
                string4 = functionPrototypeSummary.getArguments();
            } else {
                string2 = string5;
                string3 = string5;
            }
        }
        functionPrototypeSummary = CElementImageProvider.getMacroImageDescriptor();
        image = this.registry.get((ImageDescriptor)functionPrototypeSummary);
        CCompletionProposal cCompletionProposal = this.createProposal(string2, string3, stringBuffer.toString(), string4, n4, image, n, n2, n3);
        cCompletionProposal.setTriggerCharacters(VAR_TRIGGERS);
        boolean bl2 = bl = string4 != null && string4.length() > 0;
        if (bl) {
            cCompletionProposal.setCursorPosition(string2.length() - 1);
        }
        this.completions.add(cCompletionProposal);
    }

    public void acceptMethod(String string, String string2, String string3, ASTAccessVisibility aSTAccessVisibility, int n, int n2, int n3, boolean bl, int n4) {
        FunctionPrototypeSummary functionPrototypeSummary;
        String string4 = "";
        String string5 = "";
        String string6 = "";
        Image image = null;
        StringBuffer stringBuffer = new StringBuffer();
        string4 = string;
        string5 = string;
        String string7 = String.valueOf(string3) + " " + string;
        if (string2 != null) {
            string7 = string2.indexOf("(") == -1 && string2.indexOf(")") == -1 ? String.valueOf(string7) + "(" + string2 + ")" : String.valueOf(string7) + string2;
        }
        if ((functionPrototypeSummary = new FunctionPrototypeSummary(string7)) != null) {
            string4 = String.valueOf(functionPrototypeSummary.getName()) + "()";
            string5 = functionPrototypeSummary.getPrototypeString(true);
            stringBuffer.append(string5);
            string6 = functionPrototypeSummary.getArguments();
        }
        ImageDescriptor imageDescriptor = CElementImageProvider.getMethodImageDescriptor(aSTAccessVisibility);
        image = this.registry.get(imageDescriptor);
        if (!bl) {
            string4 = "";
        }
        CCompletionProposal cCompletionProposal = this.createProposal(string4, string5, stringBuffer.toString(), string6, n4, image, n, n2, n3);
        boolean bl2 = string6 != null && string6.length() > 0 && bl;
        char[] cArray = bl2 ? METHOD_WITH_ARGUMENTS_TRIGGERS : METHOD_TRIGGERS;
        cCompletionProposal.setTriggerCharacters(cArray);
        if (bl2) {
            cCompletionProposal.setCursorPosition(string4.length() - 1);
        }
        this.completions.add(cCompletionProposal);
    }

    public void acceptNamespace(String string, int n, int n2, int n3) {
        String string2 = "";
        String string3 = "";
        Image image = null;
        StringBuffer stringBuffer = new StringBuffer();
        string2 = string;
        string3 = string;
        ImageDescriptor imageDescriptor = CElementImageProvider.getNamespaceImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal cCompletionProposal = this.createProposal(string2, string3, stringBuffer.toString(), null, 0, image, n, n2, n3);
        cCompletionProposal.setTriggerCharacters(TYPE_TRIGGERS);
        this.completions.add(cCompletionProposal);
    }

    public void acceptStruct(String string, int n, int n2, int n3) {
        String string2 = "";
        String string3 = "";
        Image image = null;
        StringBuffer stringBuffer = new StringBuffer();
        string2 = string;
        string3 = string;
        ImageDescriptor imageDescriptor = CElementImageProvider.getStructImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal cCompletionProposal = this.createProposal(string2, string3, stringBuffer.toString(), null, 0, image, n, n2, n3);
        cCompletionProposal.setTriggerCharacters(TYPE_TRIGGERS);
        this.completions.add(cCompletionProposal);
    }

    public void acceptUnion(String string, int n, int n2, int n3) {
        String string2 = "";
        String string3 = "";
        Image image = null;
        StringBuffer stringBuffer = new StringBuffer();
        string2 = string;
        string3 = string;
        ImageDescriptor imageDescriptor = CElementImageProvider.getUnionImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal cCompletionProposal = this.createProposal(string2, string3, stringBuffer.toString(), null, 0, image, n, n2, n3);
        cCompletionProposal.setTriggerCharacters(TYPE_TRIGGERS);
        this.completions.add(cCompletionProposal);
    }

    public void acceptVariable(String string, String string2, int n, int n2, int n3) {
        String string3 = "";
        String string4 = "";
        Image image = null;
        StringBuffer stringBuffer = new StringBuffer();
        string3 = string;
        string4 = string;
        if (string2 != null) {
            string4 = String.valueOf(string4) + " : " + string2;
        }
        ImageDescriptor imageDescriptor = CElementImageProvider.getVariableImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal cCompletionProposal = this.createProposal(string3, string4, stringBuffer.toString(), null, 0, image, n, n2, n3);
        cCompletionProposal.setTriggerCharacters(VAR_TRIGGERS);
        this.completions.add(cCompletionProposal);
    }

    public void acceptEnumeration(String string, int n, int n2, int n3) {
        String string2 = "";
        String string3 = "";
        Image image = null;
        StringBuffer stringBuffer = new StringBuffer();
        string2 = string;
        string3 = string;
        ImageDescriptor imageDescriptor = CElementImageProvider.getEnumerationImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal cCompletionProposal = this.createProposal(string2, string3, stringBuffer.toString(), null, 0, image, n, n2, n3);
        cCompletionProposal.setTriggerCharacters(TYPE_TRIGGERS);
        this.completions.add(cCompletionProposal);
    }

    public void acceptEnumerator(String string, int n, int n2, int n3) {
        String string2 = "";
        String string3 = "";
        Image image = null;
        StringBuffer stringBuffer = new StringBuffer();
        string2 = string;
        string3 = string;
        ImageDescriptor imageDescriptor = CElementImageProvider.getEnumeratorImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal cCompletionProposal = this.createProposal(string2, string3, stringBuffer.toString(), null, 0, image, n, n2, n3);
        cCompletionProposal.setTriggerCharacters(VAR_TRIGGERS);
        this.completions.add(cCompletionProposal);
    }

    public void acceptTypedef(String string, int n, int n2, int n3) {
        String string2 = "";
        String string3 = "";
        Image image = null;
        StringBuffer stringBuffer = new StringBuffer();
        string2 = string;
        string3 = string;
        ImageDescriptor imageDescriptor = CElementImageProvider.getTypedefImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal cCompletionProposal = this.createProposal(string2, string3, stringBuffer.toString(), null, 0, image, n, n2, n3);
        cCompletionProposal.setTriggerCharacters(TYPE_TRIGGERS);
        this.completions.add(cCompletionProposal);
    }

    public void acceptKeyword(String string, int n, int n2, int n3) {
        String string2 = "";
        String string3 = "";
        Image image = null;
        StringBuffer stringBuffer = new StringBuffer();
        string2 = string;
        string3 = string;
        ImageDescriptor imageDescriptor = CElementImageProvider.getKeywordImageDescriptor();
        image = this.registry.get(imageDescriptor);
        CCompletionProposal cCompletionProposal = this.createProposal(string2, string3, stringBuffer.toString(), null, 0, image, n, n2, n3);
        cCompletionProposal.setTriggerCharacters(VAR_TRIGGERS);
        this.completions.add(cCompletionProposal);
    }

    public void acceptError(IProblem iProblem) {
        this.fLastProblem = iProblem;
    }

    public String getErrorMessage() {
        if (this.fLastProblem != null) {
            return this.fLastProblem.getMessage();
        }
        return "";
    }
}

