/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.link;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.text.link.LinkedPositionListener;
import org.eclipse.cdt.internal.ui.text.link.LinkedPositionMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.util.Assert;

public class LinkedPositionManager
implements IDocumentListener,
IPositionUpdater {
    private static final String LINKED_POSITION = "LinkedPositionManager.linked.position";
    private static final Comparator fgPositionComparator = new PositionComparator();
    private static final Map fgActiveManagers = new HashMap();
    private IDocument fDocument;
    private LinkedPositionListener fListener;

    public LinkedPositionManager(IDocument iDocument) {
        Assert.isNotNull((Object)iDocument);
        this.fDocument = iDocument;
        this.install();
    }

    public void setLinkedPositionListener(LinkedPositionListener linkedPositionListener) {
        this.fListener = linkedPositionListener;
    }

    public void addPosition(int n, int n2) throws BadLocationException {
        String string;
        Position[] positionArray = LinkedPositionManager.getPositions(this.fDocument);
        if (positionArray != null) {
            int n3 = 0;
            while (n3 < positionArray.length) {
                if (LinkedPositionManager.collides(positionArray[n3], n, n2)) {
                    throw new BadLocationException(LinkedPositionMessages.getString("LinkedPositionManager.error.position.collision"));
                }
                ++n3;
            }
        }
        if (this.containsLineDelimiters(string = this.fDocument.get(n, n2))) {
            throw new BadLocationException(LinkedPositionMessages.getString("LinkedPositionManager.error.contains.line.delimiters"));
        }
        try {
            this.fDocument.addPosition(LINKED_POSITION, (Position)new TypedPosition(n, n2, string));
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            CUIPlugin.getDefault().log(badPositionCategoryException);
            Assert.isTrue((boolean)false);
        }
    }

    public static boolean hasActiveManager(IDocument iDocument) {
        return fgActiveManagers.get(iDocument) != null;
    }

    private void install() {
        LinkedPositionManager linkedPositionManager = (LinkedPositionManager)fgActiveManagers.get(this.fDocument);
        if (linkedPositionManager != null) {
            linkedPositionManager.leave(true);
        }
        fgActiveManagers.put(this.fDocument, this);
        this.fDocument.addPositionCategory(LINKED_POSITION);
        this.fDocument.addPositionUpdater((IPositionUpdater)this);
        this.fDocument.addDocumentListener((IDocumentListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uninstall(boolean bl) {
        this.fDocument.removeDocumentListener((IDocumentListener)this);
        try {
            try {
                Position[] positionArray = LinkedPositionManager.getPositions(this.fDocument);
                if (!bl && positionArray != null) {
                    int n = 0;
                    while (n != positionArray.length) {
                        TypedPosition typedPosition = (TypedPosition)positionArray[n];
                        this.fDocument.replace(typedPosition.getOffset(), typedPosition.getLength(), typedPosition.getType());
                        ++n;
                    }
                }
                this.fDocument.removePositionCategory(LINKED_POSITION);
            }
            catch (BadLocationException badLocationException) {
                CUIPlugin.getDefault().log(badLocationException);
                Assert.isTrue((boolean)false);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                CUIPlugin.getDefault().log(badPositionCategoryException);
                Assert.isTrue((boolean)false);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.fDocument.removePositionUpdater((IPositionUpdater)this);
            fgActiveManagers.remove(this.fDocument);
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.fDocument.removePositionUpdater((IPositionUpdater)this);
        fgActiveManagers.remove(this.fDocument);
    }

    public Position getFirstPosition() {
        return this.getNextPosition(-1);
    }

    public Position getNextPosition(int n) {
        Position[] positionArray = LinkedPositionManager.getPositions(this.fDocument);
        return LinkedPositionManager.findNextPosition(positionArray, n);
    }

    private static Position findNextPosition(Position[] positionArray, int n) {
        int n2 = 0;
        while (n2 != positionArray.length) {
            if (positionArray[n2].getOffset() > n) {
                String string = ((TypedPosition)positionArray[n2]).getType();
                int n3 = 0;
                while (n3 != n2) {
                    if (((TypedPosition)positionArray[n3]).getType().equals(string)) break;
                    ++n3;
                }
                if (n3 == n2) {
                    return positionArray[n2];
                }
            }
            ++n2;
        }
        return null;
    }

    public Position getPreviousPosition(int n) {
        Position[] positionArray = LinkedPositionManager.getPositions(this.fDocument);
        if (positionArray == null) {
            return null;
        }
        Position position = null;
        Position position2 = this.getFirstPosition();
        while (position2 != null && position2.getOffset() < n) {
            position = position2;
            position2 = LinkedPositionManager.findNextPosition(positionArray, position2.getOffset());
        }
        return position;
    }

    private static Position[] getPositions(IDocument iDocument) {
        try {
            Position[] positionArray = iDocument.getPositions(LINKED_POSITION);
            Arrays.sort(positionArray, fgPositionComparator);
            return positionArray;
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            CUIPlugin.getDefault().log(badPositionCategoryException);
            Assert.isTrue((boolean)false);
            return null;
        }
    }

    public static boolean includes(Position position, int n, int n2) {
        return n >= position.getOffset() && n + n2 <= position.getOffset() + position.getLength();
    }

    public static boolean excludes(Position position, int n, int n2) {
        return n + n2 <= position.getOffset() || position.getOffset() + position.getLength() <= n;
    }

    private static boolean collides(Position position, int n, int n2) {
        return n <= position.getOffset() + position.getLength() && position.getOffset() <= n + n2;
    }

    private void leave(boolean bl) {
        this.uninstall(bl);
        if (this.fListener != null) {
            this.fListener.exit(bl);
        }
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        IDocument iDocument = documentEvent.getDocument();
        Position[] positionArray = LinkedPositionManager.getPositions(iDocument);
        Position position = LinkedPositionManager.findCurrentEditablePosition(positionArray, documentEvent.getOffset());
        if (position == null) {
            position = LinkedPositionManager.findCurrentPosition(positionArray, documentEvent.getOffset());
            if (position == null) {
                if (documentEvent.getText().length() == 0 && LinkedPositionManager.findCurrentPosition(positionArray, documentEvent.getOffset()) != null && LinkedPositionManager.findCurrentPosition(positionArray, documentEvent.getOffset() + documentEvent.getLength()) != null) {
                    this.leave(true);
                }
            } else {
                this.leave(true);
            }
        } else if (LinkedPositionManager.includes(position, documentEvent.getOffset(), documentEvent.getLength())) {
            if (this.containsLineDelimiters(documentEvent.getText())) {
                this.leave(true);
            }
        } else {
            this.leave(true);
        }
    }

    public void documentChanged(DocumentEvent documentEvent) {
        IDocument iDocument = documentEvent.getDocument();
        Position[] positionArray = LinkedPositionManager.getPositions(iDocument);
        TypedPosition typedPosition = (TypedPosition)LinkedPositionManager.findCurrentEditablePosition(positionArray, documentEvent.getOffset());
        if (typedPosition == null) {
            return;
        }
        int n = documentEvent.getOffset() - typedPosition.getOffset();
        if (this.fListener != null) {
            this.fListener.setCurrentPosition((Position)typedPosition, n + documentEvent.getText().length());
        }
        int n2 = 0;
        while (n2 != positionArray.length) {
            TypedPosition typedPosition2 = (TypedPosition)positionArray[n2];
            if (typedPosition2.getType().equals(typedPosition.getType()) && !typedPosition2.equals((Object)typedPosition)) {
                Replace replace = new Replace((Position)typedPosition2, n, documentEvent.getLength(), documentEvent.getText());
                ((IDocumentExtension)iDocument).registerPostNotificationReplace((IDocumentListener)this, (IDocumentExtension.IReplace)replace);
            }
            ++n2;
        }
    }

    public void update(DocumentEvent documentEvent) {
        int n = documentEvent.getText().length() - documentEvent.getLength();
        Position[] positionArray = LinkedPositionManager.getPositions(documentEvent.getDocument());
        TypedPosition typedPosition = (TypedPosition)LinkedPositionManager.findCurrentPosition(positionArray, documentEvent.getOffset());
        if (typedPosition == null) {
            int n2 = 0;
            while (n2 != positionArray.length) {
                TypedPosition typedPosition2 = (TypedPosition)positionArray[n2];
                int n3 = typedPosition2.getOffset();
                if (n3 >= documentEvent.getOffset()) {
                    typedPosition2.setOffset(n3 + n);
                }
                ++n2;
            }
        } else {
            int n4 = typedPosition.getLength();
            int n5 = 0;
            while (n5 != positionArray.length) {
                TypedPosition typedPosition3 = (TypedPosition)positionArray[n5];
                int n6 = typedPosition3.getOffset();
                if (typedPosition3.equals((Object)typedPosition)) {
                    typedPosition3.setLength(n4 + n);
                } else if (n6 > typedPosition.getOffset()) {
                    typedPosition3.setOffset(n6 + n);
                }
                ++n5;
            }
        }
    }

    private static Position findCurrentPosition(Position[] positionArray, int n) {
        int n2 = 0;
        while (n2 != positionArray.length) {
            if (LinkedPositionManager.includes(positionArray[n2], n, 0)) {
                return positionArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private static Position findCurrentEditablePosition(Position[] positionArray, int n) {
        Position position = positionArray[0];
        while (position != null && !LinkedPositionManager.includes(position, n, 0)) {
            position = LinkedPositionManager.findNextPosition(positionArray, position.getOffset());
        }
        return position;
    }

    private boolean containsLineDelimiters(String string) {
        String[] stringArray = this.fDocument.getLegalLineDelimiters();
        int n = 0;
        while (n != stringArray.length) {
            if (string.indexOf(stringArray[n]) != -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean anyPositionIncludes(int n, int n2) {
        Position[] positionArray = LinkedPositionManager.getPositions(this.fDocument);
        Position position = LinkedPositionManager.findCurrentEditablePosition(positionArray, n);
        if (position == null) {
            return false;
        }
        return LinkedPositionManager.includes(position, n, n2);
    }

    private static class PositionComparator
    implements Comparator {
        PositionComparator() {
        }

        public int compare(Object object, Object object2) {
            Position position = (Position)object;
            Position position2 = (Position)object2;
            return position.getOffset() - position2.getOffset();
        }
    }

    private class Replace
    implements IDocumentExtension.IReplace {
        private Position fReplacePosition;
        private int fReplaceDeltaOffset;
        private int fReplaceLength;
        private String fReplaceText;

        public Replace(Position position, int n, int n2, String string) {
            this.fReplacePosition = position;
            this.fReplaceDeltaOffset = n;
            this.fReplaceLength = n2;
            this.fReplaceText = string;
        }

        public void perform(IDocument iDocument, IDocumentListener iDocumentListener) {
            iDocument.removeDocumentListener(iDocumentListener);
            try {
                iDocument.replace(this.fReplacePosition.getOffset() + this.fReplaceDeltaOffset, this.fReplaceLength, this.fReplaceText);
            }
            catch (BadLocationException badLocationException) {
                CUIPlugin.getDefault().log(badLocationException);
            }
            iDocument.addDocumentListener(iDocumentListener);
        }
    }
}

