/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.template;

import org.eclipse.cdt.internal.corext.template.TemplateMessages;
import org.eclipse.cdt.internal.corext.template.TemplateVariable;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class TemplateVariableProposal
implements ICompletionProposal {
    private TemplateVariable fVariable;
    private int fOffset;
    private int fLength;
    private ITextViewer fViewer;
    private Point fSelection;

    public TemplateVariableProposal(TemplateVariable templateVariable, int n, int n2, ITextViewer iTextViewer) {
        this.fVariable = templateVariable;
        this.fOffset = n;
        this.fLength = n2;
        this.fViewer = iTextViewer;
    }

    public void apply(IDocument iDocument) {
        try {
            String string = this.fVariable.getName().equals("dollar") ? "$$" : "${" + this.fVariable.getName() + '}';
            iDocument.replace(this.fOffset, this.fLength, string);
            this.fSelection = new Point(this.fOffset + string.length(), 0);
        }
        catch (BadLocationException badLocationException) {
            CUIPlugin.getDefault().log(badLocationException);
            Shell shell = this.fViewer.getTextWidget().getShell();
            MessageDialog.openError((Shell)shell, (String)TemplateMessages.getString("TemplateVariableProposal.error.title"), (String)badLocationException.getMessage());
        }
    }

    public Point getSelection(IDocument iDocument) {
        return this.fSelection;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return String.valueOf(this.fVariable.getName()) + " - " + this.fVariable.getDescription();
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

