/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.IColorManagerExtension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class CColorManager
implements IColorManager,
IColorManagerExtension {
    protected Map fKeyTable = new HashMap(10);
    protected Map fDisplayTable = new HashMap(2);

    protected void dispose(Display display) {
        Map map = (Map)this.fDisplayTable.get(display);
        if (map != null) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                ((Color)iterator.next()).dispose();
            }
        }
    }

    public Color getColor(RGB rGB) {
        Color color;
        if (rGB == null) {
            return null;
        }
        final Display display = Display.getCurrent();
        HashMap<RGB, Color> hashMap = (HashMap<RGB, Color>)this.fDisplayTable.get(display);
        if (hashMap == null) {
            hashMap = new HashMap<RGB, Color>(10);
            this.fDisplayTable.put(display, hashMap);
            display.disposeExec(new Runnable(){

                public void run() {
                    CColorManager.this.dispose(display);
                }
            });
        }
        if ((color = (Color)hashMap.get(rGB)) == null) {
            color = new Color((Device)Display.getCurrent(), rGB);
            hashMap.put(rGB, color);
        }
        return color;
    }

    public void dispose() {
    }

    public Color getColor(String string) {
        if (string == null) {
            return null;
        }
        RGB rGB = (RGB)this.fKeyTable.get(string);
        return this.getColor(rGB);
    }

    public void bindColor(String string, RGB rGB) {
        Object v = this.fKeyTable.get(string);
        if (v != null) {
            throw new UnsupportedOperationException();
        }
        this.fKeyTable.put(string, rGB);
    }

    public void unbindColor(String string) {
        this.fKeyTable.remove(string);
    }
}

