/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.ITranslationUnitEditorInput;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorUtility {
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    static /* synthetic */ Class class$0;

    private EditorUtility() {
    }

    public static IEditorPart isOpenInEditor(Object object) {
        IWorkbenchPage iWorkbenchPage;
        IEditorInput iEditorInput = null;
        try {
            iEditorInput = EditorUtility.getEditorInput(object);
        }
        catch (CModelException cModelException) {}
        if (iEditorInput != null && (iWorkbenchPage = CUIPlugin.getActivePage()) != null) {
            return iWorkbenchPage.findEditor(iEditorInput);
        }
        return null;
    }

    public static IEditorPart openInEditor(Object object) throws CModelException, PartInitException {
        return EditorUtility.openInEditor(object, true);
    }

    public static IEditorPart openInEditor(Object object, boolean bl) throws CModelException, PartInitException {
        if (object instanceof IFile) {
            return EditorUtility.openInEditor((IFile)object, bl);
        }
        IEditorInput iEditorInput = EditorUtility.getEditorInput(object);
        if (iEditorInput != null) {
            return EditorUtility.openInEditor(iEditorInput, EditorUtility.getEditorID(iEditorInput, object), bl);
        }
        return null;
    }

    public static void revealInEditor(IEditorPart iEditorPart, ICElement iCElement) {
        if (iCElement != null && iEditorPart instanceof CEditor) {
            ((CEditor)iEditorPart).setSelection(iCElement);
        }
    }

    private static IEditorPart openInEditor(IFile iFile, boolean bl) throws PartInitException {
        if (!iFile.getProject().isAccessible()) {
            EditorUtility.closedProject(iFile.getProject());
            return null;
        }
        if (iFile != null) {
            try {
                Object object;
                File file = iFile.getRawLocation().toFile();
                if (file != null) {
                    object = null;
                    try {
                        object = file.getCanonicalPath();
                    }
                    catch (IOException iOException) {}
                    if (object != null) {
                        Path path = new Path((String)object);
                        iFile = CUIPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                    }
                }
                if ((object = EditorUtility.getEditorInput(iFile)) != null) {
                    return EditorUtility.openInEditor(object, EditorUtility.getEditorID(object, iFile), bl);
                }
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    private static void closedProject(IProject iProject) {
        MessageBox messageBox = new MessageBox(CUIPlugin.getActiveWorkbenchShell(), 33);
        messageBox.setText(CUIPlugin.getResourceString("EditorUtility.closedproject"));
        String string = CUIPlugin.getResourceString("Editorutility.closedproject.description");
        messageBox.setMessage(MessageFormat.format(string, iProject.getName()));
        messageBox.open();
    }

    private static IEditorPart openInEditor(IEditorInput iEditorInput, String string, boolean bl) throws PartInitException {
        IWorkbenchPage iWorkbenchPage;
        if (iEditorInput != null && (iWorkbenchPage = CUIPlugin.getActivePage()) != null) {
            IEditorPart iEditorPart = iWorkbenchPage.openEditor(iEditorInput, string, bl);
            EditorUtility.initializeHighlightRange(iEditorPart);
            return iEditorPart;
        }
        return null;
    }

    private static void initializeHighlightRange(IEditorPart iEditorPart) {
        boolean cfr_ignored_0 = iEditorPart instanceof ITextEditor;
    }

    private static IEditorInput getEditorInput(ICElement iCElement) throws CModelException {
        while (iCElement != null) {
            ITranslationUnit iTranslationUnit;
            if (iCElement instanceof IWorkingCopy && ((IWorkingCopy)iCElement).isWorkingCopy()) {
                iCElement = ((IWorkingCopy)iCElement).getOriginalElement();
            }
            if (iCElement instanceof ISourceReference && (iTranslationUnit = ((ISourceReference)iCElement).getTranslationUnit()) != null) {
                iCElement = iTranslationUnit;
            }
            if (iCElement instanceof ITranslationUnit) {
                iTranslationUnit = (ITranslationUnit)iCElement;
                IResource iResource = iTranslationUnit.getResource();
                if (iResource instanceof IFile) {
                    return new FileEditorInput((IFile)iResource);
                }
                return new ExternalEditorInput(iTranslationUnit, EditorUtility.getStorage(iTranslationUnit));
            }
            if (iCElement instanceof IBinary) {
                return new ExternalEditorInput(EditorUtility.getStorage((IBinary)iCElement), null);
            }
            iCElement = iCElement.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object object) throws CModelException {
        if (object instanceof ICElement) {
            return EditorUtility.getEditorInput((ICElement)object);
        }
        if (object instanceof IFile) {
            return new FileEditorInput((IFile)object);
        }
        if (object instanceof IStorage) {
            return new ExternalEditorInput((IStorage)object, null);
        }
        return null;
    }

    public static ICElement getActiveEditorCInput() {
        IEditorInput iEditorInput;
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage = CUIPlugin.getActivePage();
        if (iWorkbenchPage != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) != null && (iEditorInput = iEditorPart.getEditorInput()) != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ICElement)iEditorInput.getAdapter((Class)clazz);
        }
        return null;
    }

    public static ITranslationUnit getWorkingCopy(ITranslationUnit iTranslationUnit) {
        if (iTranslationUnit == null) {
            return null;
        }
        if (iTranslationUnit.isWorkingCopy()) {
            return iTranslationUnit;
        }
        return iTranslationUnit.findSharedWorkingCopy(CUIPlugin.getDefault().getBufferFactory());
    }

    public static String getEditorID(String string) {
        IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (iEditorRegistry != null) {
            IEditorDescriptor iEditorDescriptor = iEditorRegistry.getDefaultEditor(string);
            if (iEditorDescriptor != null) {
                return iEditorDescriptor.getId();
            }
            return iEditorRegistry.findEditor(DEFAULT_TEXT_EDITOR_ID).getId();
        }
        return null;
    }

    public static String getEditorID(IEditorInput iEditorInput, Object object) {
        String string = EditorUtility.getEditorID(iEditorInput.getName());
        if (!DEFAULT_TEXT_EDITOR_ID.equals(string)) {
            return string;
        }
        ITranslationUnit iTranslationUnit = null;
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            IFile iFile = iFileEditorInput.getFile();
            ICElement iCElement = CoreModel.getDefault().create(iFile);
            if (iCElement instanceof ITranslationUnit) {
                iTranslationUnit = (ITranslationUnit)iCElement;
            }
        } else if (iEditorInput instanceof ITranslationUnitEditorInput) {
            ITranslationUnitEditorInput iTranslationUnitEditorInput = (ITranslationUnitEditorInput)iEditorInput;
            iTranslationUnit = iTranslationUnitEditorInput.getTranslationUnit();
        }
        if (iTranslationUnit != null) {
            if (iTranslationUnit.isCLanguage()) {
                return EditorUtility.getEditorID("No_ExIsTeNt_FiLe.c");
            }
            if (iTranslationUnit.isCXXLanguage()) {
                return EditorUtility.getEditorID("No_ExIsTeNt_FiLe.cpp");
            }
        }
        return string;
    }

    public static int findLocalizedModifier(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static String getModifierString(int n) {
        String string = "";
        if ((n & 0x40000) == 262144) {
            string = EditorUtility.appendModifierString(string, 262144);
        }
        if ((n & 0x10000) == 65536) {
            string = EditorUtility.appendModifierString(string, 65536);
        }
        if ((n & 0x20000) == 131072) {
            string = EditorUtility.appendModifierString(string, 131072);
        }
        if ((n & 0x400000) == 0x400000) {
            string = EditorUtility.appendModifierString(string, 0x400000);
        }
        return string;
    }

    private static String appendModifierString(String string, int n) {
        if (string == null) {
            string = "";
        }
        String string2 = Action.findModifierString((int)n);
        if (string.length() == 0) {
            return string2;
        }
        return CEditorMessages.getFormattedString("EditorUtility.concatModifierStrings", new String[]{string, string2});
    }

    public static IStorage getStorage(IBinary iBinary) {
        FileStorage fileStorage = null;
        try {
            fileStorage = new FileStorage((InputStream)new ByteArrayInputStream(iBinary.getBuffer().getContents().getBytes()), iBinary.getPath());
        }
        catch (CModelException cModelException) {}
        return fileStorage;
    }

    public static IStorage getStorage(ITranslationUnit iTranslationUnit) {
        FileStorage fileStorage = null;
        try {
            fileStorage = new FileStorage((InputStream)new ByteArrayInputStream(iTranslationUnit.getBuffer().getContents().getBytes()), iTranslationUnit.getPath());
        }
        catch (CModelException cModelException) {}
        return fileStorage;
    }
}

