/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.internal.ui.editor.TranslationUnitAnnotationModelEvent;
import org.eclipse.cdt.internal.ui.util.IProblemChangedListener;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.widgets.Display;

public class ProblemMarkerManager
implements IResourceChangeListener,
IAnnotationModelListener,
IAnnotationModelListenerExtension {
    private ListenerList fListeners = new ListenerList(5);

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        HashSet hashSet = new HashSet();
        try {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            if (iResourceDelta != null) {
                iResourceDelta.accept((IResourceDeltaVisitor)new ProjectErrorVisitor(hashSet));
            }
        }
        catch (CoreException coreException) {
            CUIPlugin.getDefault().log(coreException.getStatus());
        }
        if (!hashSet.isEmpty()) {
            this.fireChanges(hashSet);
        }
    }

    public void modelChanged(IAnnotationModel iAnnotationModel) {
    }

    public void modelChanged(AnnotationModelEvent annotationModelEvent) {
        IResource iResource;
        TranslationUnitAnnotationModelEvent translationUnitAnnotationModelEvent;
        if (annotationModelEvent instanceof TranslationUnitAnnotationModelEvent && (translationUnitAnnotationModelEvent = (TranslationUnitAnnotationModelEvent)annotationModelEvent).includesProblemMarkerAnnotationChanges() && (iResource = translationUnitAnnotationModelEvent.getUnderlyingResource()) != null) {
            this.fireChanges(Collections.singleton(iResource.getFullPath()));
        }
    }

    public void addListener(IProblemChangedListener iProblemChangedListener) {
        if (this.fListeners.isEmpty()) {
            CUIPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            CUIPlugin.getDefault().getDocumentProvider().addGlobalAnnotationModelListener(this);
        }
        this.fListeners.add((Object)iProblemChangedListener);
    }

    public void removeListener(IProblemChangedListener iProblemChangedListener) {
        this.fListeners.remove((Object)iProblemChangedListener);
        if (this.fListeners.isEmpty()) {
            CUIPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            CUIPlugin.getDefault().getDocumentProvider().removeGlobalAnnotationModelListener(this);
        }
    }

    private void fireChanges(final Set set) {
        Display display = SWTUtil.getStandardDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    Object[] objectArray = ProblemMarkerManager.this.fListeners.getListeners();
                    int n = 0;
                    while (n < objectArray.length) {
                        IProblemChangedListener iProblemChangedListener = (IProblemChangedListener)objectArray[n];
                        iProblemChangedListener.problemsChanged(set);
                        ++n;
                    }
                }
            });
        }
    }

    private static class ProjectErrorVisitor
    implements IResourceDeltaVisitor {
        private HashSet fChangedElements;

        public ProjectErrorVisitor(HashSet hashSet) {
            this.fChangedElements = hashSet;
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            IResource iResource = iResourceDelta.getResource();
            if (iResource instanceof IProject && iResourceDelta.getKind() == 4) {
                try {
                    IProject iProject = (IProject)iResource;
                    if (!iProject.isAccessible() || !iProject.hasNature("org.eclipse.cdt.core.cnature")) {
                        return false;
                    }
                }
                catch (CoreException coreException) {
                    CUIPlugin.getDefault().log(coreException.getStatus());
                    return false;
                }
            }
            this.checkInvalidate(iResourceDelta, iResource.getFullPath());
            return true;
        }

        private void checkInvalidate(IResourceDelta iResourceDelta, IPath iPath) {
            int n = iResourceDelta.getKind();
            if (n == 2 || n == 1 || n == 4 && this.isErrorDelta(iResourceDelta)) {
                while (!(iPath.isEmpty() || iPath.isRoot() || this.fChangedElements.contains(iPath))) {
                    this.fChangedElements.add(iPath);
                    iPath = iPath.removeLastSegments(1);
                }
            }
        }

        private boolean isErrorDelta(IResourceDelta iResourceDelta) {
            if ((iResourceDelta.getFlags() & 0x20000) != 0) {
                IMarkerDelta[] iMarkerDeltaArray = iResourceDelta.getMarkerDeltas();
                int n = 0;
                while (n < iMarkerDeltaArray.length) {
                    if (iMarkerDeltaArray[n].isSubtypeOf("org.eclipse.cdt.core.problem")) {
                        int n2 = iMarkerDeltaArray[n].getKind();
                        if (n2 == 1 || n2 == 2) {
                            return true;
                        }
                        int n3 = iMarkerDeltaArray[n].getAttribute("severity", -1);
                        int n4 = iMarkerDeltaArray[n].getMarker().getAttribute("severity", -1);
                        if (n4 != n3) {
                            return true;
                        }
                    }
                    ++n;
                }
            }
            return false;
        }
    }
}

