/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.ArrayList;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.ProblemsLabelDecorator;
import org.eclipse.cdt.internal.ui.util.ResourceToItemsMapper;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class ProblemTableViewer
extends TableViewer {
    protected ResourceToItemsMapper fResourceToItemsMapper;

    public ProblemTableViewer(Composite composite) {
        super(composite);
        this.initMapper();
    }

    public ProblemTableViewer(Composite composite, int n) {
        super(composite, n);
        this.initMapper();
    }

    public ProblemTableViewer(Table table) {
        super(table);
        this.initMapper();
    }

    private void initMapper() {
        this.fResourceToItemsMapper = new ResourceToItemsMapper((ContentViewer)this);
    }

    protected void mapElement(Object object, Widget widget) {
        super.mapElement(object, widget);
        if (widget instanceof Item) {
            this.fResourceToItemsMapper.addToMap(object, (Item)widget);
        }
    }

    protected void unmapElement(Object object, Widget widget) {
        if (widget instanceof Item) {
            this.fResourceToItemsMapper.removeFromMap(object, (Item)widget);
        }
        super.unmapElement(object, widget);
    }

    protected void unmapAllElements() {
        this.fResourceToItemsMapper.clearMap();
        super.unmapAllElements();
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
        Object[] objectArray;
        if (labelProviderChangedEvent instanceof ProblemsLabelDecorator.ProblemsLabelChangedEvent && !(objectArray = (Object[])labelProviderChangedEvent).isMarkerChange() && this.canIgnoreChangesFromAnnotionModel()) {
            return;
        }
        objectArray = labelProviderChangedEvent.getElements();
        if (objectArray != null && !this.fResourceToItemsMapper.isEmpty()) {
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (object instanceof IResource) {
                    this.fResourceToItemsMapper.resourceChanged((IResource)object);
                } else {
                    arrayList.add(object);
                }
                ++n;
            }
            if (arrayList.isEmpty()) {
                return;
            }
            labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)labelProviderChangedEvent.getSource(), arrayList.toArray());
        }
        super.handleLabelProviderChanged(labelProviderChangedEvent);
    }

    private boolean canIgnoreChangesFromAnnotionModel() {
        return true;
    }
}

