/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.Set;
import org.eclipse.cdt.internal.ui.util.IProblemChangedListener;
import org.eclipse.cdt.internal.ui.util.ProblemItemMapper;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class ProblemTreeViewer
extends TreeViewer
implements IProblemChangedListener {
    protected ProblemItemMapper fProblemItemMapper;

    public ProblemTreeViewer(Composite composite) {
        super(composite);
        this.initMapper();
    }

    public ProblemTreeViewer(Composite composite, int n) {
        super(composite, n);
        this.initMapper();
    }

    public ProblemTreeViewer(Tree tree) {
        super(tree);
        this.initMapper();
    }

    private void initMapper() {
        this.fProblemItemMapper = new ProblemItemMapper();
    }

    public void problemsChanged(final Set set) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ProblemTreeViewer.this.fProblemItemMapper.problemsChanged(set, (ILabelProvider)ProblemTreeViewer.this.getLabelProvider());
                }
            });
        }
    }

    protected void mapElement(Object object, Widget widget) {
        super.mapElement(object, widget);
        if (widget instanceof Item) {
            this.fProblemItemMapper.addToMap(object, (Item)widget);
        }
    }

    protected void unmapElement(Object object, Widget widget) {
        if (widget instanceof Item) {
            this.fProblemItemMapper.removeFromMap(object, (Item)widget);
        }
        super.unmapElement(object);
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
        Object object = labelProviderChangedEvent.getElement();
        if (object == null) {
            super.handleLabelProviderChanged(labelProviderChangedEvent);
            return;
        }
        super.handleLabelProviderChanged(labelProviderChangedEvent);
    }

    protected void handleInvalidSelection(ISelection iSelection, ISelection iSelection2) {
        super.handleInvalidSelection(iSelection, iSelection2);
    }

    public boolean isExpandable(Object object) {
        ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.getContentProvider();
        if (iTreeContentProvider == null) {
            return false;
        }
        return iTreeContentProvider.hasChildren(object);
    }
}

