/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;

public class ResourceToItemsMapper {
    private static final int NUMBER_LIST_REUSE = 10;
    private HashMap fResourceToItem = new HashMap();
    private Stack fReuseLists = new Stack();
    private ContentViewer fContentViewer;

    public ResourceToItemsMapper(ContentViewer contentViewer) {
        this.fContentViewer = contentViewer;
    }

    public void resourceChanged(IResource iResource) {
        Object v = this.fResourceToItem.get(iResource);
        if (v != null) {
            if (v instanceof Item) {
                this.updateItem((Item)v);
            } else {
                List list = (List)v;
                int n = 0;
                while (n < list.size()) {
                    this.updateItem((Item)list.get(n));
                    ++n;
                }
            }
        }
    }

    private void updateItem(Item item) {
        if (!item.isDisposed()) {
            ILabelProvider iLabelProvider = (ILabelProvider)this.fContentViewer.getLabelProvider();
            Object object = item.getData();
            if (iLabelProvider instanceof IViewerLabelProvider) {
                IViewerLabelProvider iViewerLabelProvider = (IViewerLabelProvider)iLabelProvider;
                ViewerLabel viewerLabel = new ViewerLabel(item.getText(), item.getImage());
                iViewerLabelProvider.updateLabel(viewerLabel, object);
                if (viewerLabel.hasNewImage()) {
                    item.setImage(viewerLabel.getImage());
                }
                if (viewerLabel.hasNewText()) {
                    item.setText(viewerLabel.getText());
                }
            } else {
                Image image = item.getImage();
                Image image2 = iLabelProvider.getImage(object);
                if (image2 != null && !image2.equals((Object)image)) {
                    item.setImage(image2);
                }
                String string = item.getText();
                String string2 = iLabelProvider.getText(object);
                if (string2 != null && !string2.equals(string)) {
                    item.setText(string2);
                }
            }
        }
    }

    public void addToMap(Object object, Item item) {
        IResource iResource = ResourceToItemsMapper.getCorrespondingResource(object);
        if (iResource != null) {
            Object v = this.fResourceToItem.get(iResource);
            if (v == null) {
                this.fResourceToItem.put(iResource, item);
            } else if (v instanceof Item) {
                if (v != item) {
                    List list = this.getNewList();
                    list.add(v);
                    list.add(item);
                    this.fResourceToItem.put(iResource, list);
                }
            } else {
                List list = (List)v;
                if (!list.contains(item)) {
                    list.add(item);
                }
            }
        }
    }

    public void removeFromMap(Object object, Item item) {
        IResource iResource = ResourceToItemsMapper.getCorrespondingResource(object);
        if (iResource != null) {
            Object v = this.fResourceToItem.get(iResource);
            if (v == null) {
                return;
            }
            if (v instanceof Item) {
                this.fResourceToItem.remove(iResource);
            } else {
                List list = (List)v;
                list.remove(item);
                if (list.isEmpty()) {
                    this.fResourceToItem.remove(list);
                    this.releaseList(list);
                }
            }
        }
    }

    private List getNewList() {
        if (!this.fReuseLists.isEmpty()) {
            return (List)this.fReuseLists.pop();
        }
        return new ArrayList(2);
    }

    private void releaseList(List list) {
        if (this.fReuseLists.size() < 10) {
            this.fReuseLists.push(list);
        }
    }

    public void clearMap() {
        this.fResourceToItem.clear();
    }

    public boolean isEmpty() {
        return this.fResourceToItem.isEmpty();
    }

    private static IResource getCorrespondingResource(Object object) {
        if (object instanceof ICElement) {
            ICElement iCElement = (ICElement)object;
            if (!iCElement.isReadOnly()) {
                ITranslationUnit iTranslationUnit;
                IResource iResource = iCElement.getResource();
                if (iResource == null && (iTranslationUnit = (ITranslationUnit)iCElement.getAncestor(60)) != null) {
                    iResource = iTranslationUnit.getResource();
                }
                return iResource;
            }
            return null;
        }
        if (object instanceof IResource) {
            return (IResource)object;
        }
        return null;
    }
}

