/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.corext.CorextMessages;
import org.eclipse.cdt.internal.ui.CUIStatus;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class Resources {
    private Resources() {
    }

    public static IStatus checkInSync(IResource iResource) {
        return Resources.checkInSync(new IResource[]{iResource});
    }

    public static IStatus checkInSync(IResource[] iResourceArray) {
        IStatus iStatus = null;
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (!iResource.isSynchronized(2)) {
                iStatus = Resources.addOutOfSync(iStatus, iResource);
            }
            ++n;
        }
        if (iStatus != null) {
            return iStatus;
        }
        return new Status(0, CUIPlugin.getPluginId(), 0, "", null);
    }

    public static IStatus makeCommittable(IResource iResource, Object object) {
        return Resources.makeCommittable(new IResource[]{iResource}, object);
    }

    public static IStatus makeCommittable(IResource[] iResourceArray, Object object) {
        IResource iResource;
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        int n = 0;
        while (n < iResourceArray.length) {
            iResource = iResourceArray[n];
            if (iResource.getType() == 1 && iResource.isReadOnly()) {
                arrayList.add(iResource);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return new Status(0, CUIPlugin.getPluginId(), 0, "", null);
        }
        Map map = Resources.createModificationStampMap(arrayList);
        iResource = ResourcesPlugin.getWorkspace().validateEdit(arrayList.toArray(new IFile[arrayList.size()]), object);
        if (!iResource.isOK()) {
            return iResource;
        }
        IStatus iStatus = null;
        Map map2 = Resources.createModificationStampMap(arrayList);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            IFile iFile = (IFile)iterator.next();
            if (map.get(iFile).equals(map2.get(iFile))) continue;
            iStatus = Resources.addModified(iStatus, iFile);
        }
        if (iStatus != null) {
            return iStatus;
        }
        return new Status(0, CUIPlugin.getPluginId(), 0, "", null);
    }

    private static Map createModificationStampMap(List list) {
        HashMap<IFile, Long> hashMap = new HashMap<IFile, Long>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IFile iFile = (IFile)iterator.next();
            hashMap.put(iFile, new Long(iFile.getModificationStamp()));
        }
        return hashMap;
    }

    private static IStatus addModified(IStatus iStatus, IFile iFile) {
        IStatus iStatus2 = CUIStatus.createError(10003, CorextMessages.getFormattedString("Resources.fileModified", iFile.getFullPath().toString()), null);
        if (iStatus == null) {
            return iStatus2;
        }
        if (iStatus.isMultiStatus()) {
            ((MultiStatus)iStatus).add(iStatus2);
            return iStatus;
        }
        MultiStatus multiStatus = new MultiStatus(CUIPlugin.getPluginId(), 10003, CorextMessages.getString("Resources.modifiedResources"), null);
        multiStatus.add(iStatus);
        multiStatus.add(iStatus2);
        return multiStatus;
    }

    private static IStatus addOutOfSync(IStatus iStatus, IResource iResource) {
        Status status = new Status(4, ResourcesPlugin.getPlugin().getBundle().getSymbolicName(), 274, CorextMessages.getFormattedString("Resources.outOfSync", iResource.getFullPath().toString()), null);
        if (iStatus == null) {
            return status;
        }
        if (iStatus.isMultiStatus()) {
            ((MultiStatus)iStatus).add((IStatus)status);
            return iStatus;
        }
        MultiStatus multiStatus = new MultiStatus(ResourcesPlugin.getPlugin().getBundle().getSymbolicName(), 274, CorextMessages.getString("Resources.outOfSyncResources"), null);
        multiStatus.add(iStatus);
        multiStatus.add((IStatus)status);
        return multiStatus;
    }

    public static String[] getLocationOSStrings(IResource[] iResourceArray) {
        ArrayList<String> arrayList = new ArrayList<String>(iResourceArray.length);
        int n = 0;
        while (n < iResourceArray.length) {
            IPath iPath = iResourceArray[n].getLocation();
            if (iPath != null) {
                arrayList.add(iPath.toOSString());
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

