/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableLayoutComposite
extends Composite {
    private List columns = new ArrayList();

    public TableLayoutComposite(Composite composite, int n) {
        super(composite, n);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = TableLayoutComposite.this.getClientArea();
                Table table = (Table)TableLayoutComposite.this.getChildren()[0];
                Point point = TableLayoutComposite.this.computeTableSize(table);
                int n = rectangle.width - 2 * table.getBorderWidth();
                if (point.y > rectangle.height) {
                    Point point2 = table.getVerticalBar().getSize();
                    n -= point2.x;
                }
                TableLayoutComposite.this.layoutTable(table, n, rectangle, table.getSize().x < rectangle.width);
            }
        });
    }

    public void addColumnData(ColumnLayoutData columnLayoutData) {
        this.columns.add(columnLayoutData);
    }

    private Point computeTableSize(Table table) {
        Point point = table.computeSize(-1, -1);
        int n = 0;
        int n2 = this.columns.size();
        int n3 = 0;
        while (n3 < n2) {
            ColumnPixelData columnPixelData;
            ColumnLayoutData columnLayoutData = (ColumnLayoutData)this.columns.get(n3);
            if (columnLayoutData instanceof ColumnPixelData) {
                columnPixelData = (ColumnPixelData)columnLayoutData;
                n += columnPixelData.width;
            } else if (columnLayoutData instanceof ColumnWeightData) {
                columnPixelData = (ColumnWeightData)columnLayoutData;
                n += columnPixelData.minimumWidth;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++n3;
        }
        if (n > point.x) {
            point.x = n;
        }
        return point;
    }

    private void layoutTable(Table table, int n, Rectangle rectangle, boolean bl) {
        int n2;
        int n3;
        if (n <= 1) {
            return;
        }
        TableColumn[] tableColumnArray = table.getColumns();
        int n4 = Math.min(this.columns.size(), tableColumnArray.length);
        int[] nArray = new int[n4];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n4) {
            ColumnLayoutData columnLayoutData = (ColumnLayoutData)this.columns.get(n8);
            if (columnLayoutData instanceof ColumnPixelData) {
                nArray[n8] = n3 = ((ColumnPixelData)columnLayoutData).width;
                n5 += n3;
            } else if (columnLayoutData instanceof ColumnWeightData) {
                ColumnWeightData columnWeightData = (ColumnWeightData)columnLayoutData;
                ++n6;
                n2 = columnWeightData.weight;
                n7 += n2;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++n8;
        }
        if (n6 > 0) {
            ColumnWeightData columnWeightData;
            n8 = n - n5;
            int n9 = 0;
            n3 = 0;
            while (n3 < n4) {
                ColumnLayoutData columnLayoutData = (ColumnLayoutData)this.columns.get(n3);
                if (columnLayoutData instanceof ColumnWeightData) {
                    int n10;
                    columnWeightData = (ColumnWeightData)columnLayoutData;
                    int n11 = columnWeightData.weight;
                    int n12 = n10 = n7 == 0 ? 0 : n11 * n8 / n7;
                    if (n10 < columnWeightData.minimumWidth) {
                        n10 = columnWeightData.minimumWidth;
                    }
                    n9 += n10;
                    nArray[n3] = n10;
                }
                ++n3;
            }
            n3 = n8 - n9;
            n2 = 0;
            while (n3 > 0) {
                if (n2 == n4) {
                    n2 = 0;
                }
                if ((columnWeightData = (ColumnLayoutData)this.columns.get(n2)) instanceof ColumnWeightData) {
                    int n13 = n2;
                    nArray[n13] = nArray[n13] + 1;
                    --n3;
                }
                ++n2;
            }
        }
        if (bl) {
            table.setSize(rectangle.width, rectangle.height);
        }
        n8 = 0;
        while (n8 < n4) {
            tableColumnArray[n8].setWidth(nArray[n8]);
            ++n8;
        }
        if (!bl) {
            table.setSize(rectangle.width, rectangle.height);
        }
    }
}

