/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class CElementLabels {
    public static final int M_PARAMETER_TYPES = 1;
    public static final int M_PARAMETER_NAMES = 2;
    public static final int M_EXCEPTIONS = 4;
    public static final int M_APP_RETURNTYPE = 8;
    public static final int M_PRE_RETURNTYPE = 16;
    public static final int M_FULLY_QUALIFIED = 32;
    public static final int M_POST_QUALIFIED = 64;
    public static final int I_FULLY_QUALIFIED = 128;
    public static final int I_POST_QUALIFIED = 256;
    public static final int F_APP_TYPE_SIGNATURE = 512;
    public static final int F_PRE_TYPE_SIGNATURE = 1024;
    public static final int F_FULLY_QUALIFIED = 2048;
    public static final int F_POST_QUALIFIED = 4096;
    public static final int T_FULLY_QUALIFIED = 8192;
    public static final int T_CONTAINER_QUALIFIED = 16384;
    public static final int T_POST_QUALIFIED = 32768;
    public static final int D_QUALIFIED = 65536;
    public static final int D_POST_QUALIFIED = 131072;
    public static final int CF_QUALIFIED = 262144;
    public static final int CF_POST_QUALIFIED = 524288;
    public static final int CU_QUALIFIED = 0x100000;
    public static final int CU_POST_QUALIFIED = 0x200000;
    public static final int P_QUALIFIED = 0x400000;
    public static final int P_POST_QUALIFIED = 0x800000;
    public static final int ROOT_VARIABLE = 0x1000000;
    public static final int ROOT_QUALIFIED = 0x2000000;
    public static final int ROOT_POST_QUALIFIED = 0x4000000;
    public static final int APPEND_ROOT_PATH = 0x8000000;
    public static final int PREPEND_ROOT_PATH = 0x10000000;
    public static final int P_COMPRESSED = 0x20000000;
    public static final int REFERENCED_ROOT_POST_QUALIFIED = 0x40000000;
    public static final int ALL_FULLY_QUALIFIED = 39135392;
    public static final int ALL_POST_QUALIFIED = 78287168;
    public static final int ALL_DEFAULT = 1;
    public static final int DEFAULT_QUALIFIED = 1386656;
    public static final int DEFAULT_POST_QUALIFIED = 2789696;
    public static final String CONCAT_STRING = CSearchMessages.getString("CElementLabels.concat_string");
    public static final String COMMA_STRING = CSearchMessages.getString("CElementLabels.comma_string");
    public static final String DECL_STRING = CSearchMessages.getString("CElementLabels.declseparator_string");
    static /* synthetic */ Class class$0;

    public static String getTextLabel(Object object, int n) {
        if (object instanceof ICElement) {
            return CElementLabels.getElementLabel((ICElement)object, n);
        }
        if (object instanceof IAdaptable) {
            IWorkbenchAdapter iWorkbenchAdapter;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iWorkbenchAdapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return iWorkbenchAdapter.getLabel(object);
            }
        }
        return "";
    }

    public static String getElementLabel(ICElement iCElement, int n) {
        StringBuffer stringBuffer = new StringBuffer(60);
        CElementLabels.getElementLabel(iCElement, n, stringBuffer);
        return stringBuffer.toString();
    }

    public static void getElementLabel(ICElement iCElement, int n, StringBuffer stringBuffer) {
        int n2 = iCElement.getElementType();
        ISourceRoot iSourceRoot = null;
        if (!(n2 == 10 || n2 == 11 || n2 == 12 && iCElement instanceof ISourceRoot)) {
            iSourceRoot = CModelUtil.getSourceRoot(iCElement);
        }
        if (iSourceRoot != null && CElementLabels.getFlag(n, 0x10000000)) {
            CElementLabels.getSourceRootLabel(iSourceRoot, 0x2000000, stringBuffer);
            stringBuffer.append(CONCAT_STRING);
        }
        switch (n2) {
            case 67: {
                CElementLabels.getMethodLabel((IMethod)iCElement, n, stringBuffer);
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                CElementLabels.getTypeLabel(iCElement, n, stringBuffer);
                break;
            }
            case 60: {
                CElementLabels.getTranslationUnitLabel((ITranslationUnit)iCElement, n, stringBuffer);
                break;
            }
            case 12: {
                ICContainer iCContainer = (ICContainer)iCElement;
                if (iCContainer instanceof ISourceRoot) {
                    CElementLabels.getSourceRootLabel((ISourceRoot)iCContainer, n, stringBuffer);
                    break;
                }
                CElementLabels.getContainerLabel(iCContainer, n, stringBuffer);
                break;
            }
            case 10: 
            case 11: {
                stringBuffer.append(iCElement.getElementName());
                break;
            }
            default: {
                stringBuffer.append(iCElement.getElementName());
            }
        }
        if (iSourceRoot != null && CElementLabels.getFlag(n, 0x8000000)) {
            stringBuffer.append(CONCAT_STRING);
            CElementLabels.getSourceRootLabel(iSourceRoot, 0x2000000, stringBuffer);
        }
    }

    public static void getMethodLabel(IMethod iMethod, int n, StringBuffer stringBuffer) {
        try {
            String[] stringArray;
            if (CElementLabels.getFlag(n, 16) && iMethod.exists() && !iMethod.isConstructor()) {
                stringBuffer.append(iMethod.getReturnType());
                stringBuffer.append(' ');
            }
            if (CElementLabels.getFlag(n, 32) && (stringArray = iMethod.getParent()) != null && stringArray.exists()) {
                CElementLabels.getTypeLabel((ICElement)stringArray, 0x2000 | n & 0x20000000, stringBuffer);
                stringBuffer.append("::");
            }
            stringBuffer.append(iMethod.getElementName());
            if (CElementLabels.getFlag(n, 3)) {
                stringBuffer.append('(');
                stringArray = CElementLabels.getFlag(n, 1) ? iMethod.getParameterTypes() : null;
                String[] stringArray2 = null;
                int n2 = stringArray != null ? stringArray.length : stringArray2.length;
                int n3 = 0;
                while (n3 < n2) {
                    if (n3 > 0) {
                        stringBuffer.append(COMMA_STRING);
                    }
                    if (stringArray != null) {
                        stringBuffer.append(stringArray[n3]);
                    }
                    if (stringArray2 != null) {
                        if (stringArray != null) {
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append(stringArray2[n3]);
                    }
                    ++n3;
                }
                stringBuffer.append(')');
            }
            if (CElementLabels.getFlag(n, 4) && iMethod.exists() && (stringArray = iMethod.getExceptions()).length > 0) {
                stringBuffer.append(" throw( ");
                int n4 = 0;
                while (n4 < stringArray.length) {
                    if (n4 > 0) {
                        stringBuffer.append(COMMA_STRING);
                    }
                    stringBuffer.append(stringArray[n4]);
                    ++n4;
                }
                stringBuffer.append(" )");
            }
            if (CElementLabels.getFlag(n, 8) && iMethod.exists() && !iMethod.isConstructor()) {
                stringBuffer.append(DECL_STRING);
                stringBuffer.append(iMethod.getReturnType());
            }
            if (CElementLabels.getFlag(n, 64)) {
                stringBuffer.append(CONCAT_STRING);
                CElementLabels.getTypeLabel(iMethod.getParent(), 0x2000 | n & 0x20000000, stringBuffer);
            }
        }
        catch (CModelException cModelException) {
            CUIPlugin.getDefault().log(cModelException);
        }
    }

    public static void getSourceRootLabel(ISourceRoot iSourceRoot, int n, StringBuffer stringBuffer) {
        CElementLabels.getFolderLabel((ICContainer)iSourceRoot, n, stringBuffer);
    }

    public static void getContainerLabel(ICContainer iCContainer, int n, StringBuffer stringBuffer) {
        CElementLabels.getFolderLabel(iCContainer, n, stringBuffer);
    }

    private static void getFolderLabel(ICContainer iCContainer, int n, StringBuffer stringBuffer) {
        boolean bl;
        IResource iResource = iCContainer.getResource();
        boolean bl2 = CElementLabels.getFlag(n, 0x2000000);
        boolean bl3 = bl = CElementLabels.getFlag(n, 0x40000000) && iCContainer instanceof ISourceRoot && CModelUtil.isReferenced((ISourceRoot)iCContainer) && iResource != null;
        if (bl2) {
            stringBuffer.append(iCContainer.getPath().makeRelative().toString());
        } else {
            if (iResource != null) {
                stringBuffer.append(iResource.getProjectRelativePath().toString());
            } else {
                stringBuffer.append(iCContainer.getElementName());
            }
            if (bl) {
                stringBuffer.append(CONCAT_STRING);
                stringBuffer.append(iResource.getProject().getName());
            } else if (CElementLabels.getFlag(n, 0x4000000)) {
                stringBuffer.append(CONCAT_STRING);
                stringBuffer.append(iCContainer.getParent().getElementName());
            }
        }
    }

    public static void getTranslationUnitLabel(ITranslationUnit iTranslationUnit, int n, StringBuffer stringBuffer) {
        if (CElementLabels.getFlag(n, 0x100000)) {
            ISourceRoot iSourceRoot = CModelUtil.getSourceRoot((ICElement)iTranslationUnit);
            stringBuffer.append(iSourceRoot.getElementName());
            stringBuffer.append('.');
        }
        stringBuffer.append(iTranslationUnit.getElementName());
        if (CElementLabels.getFlag(n, 0x200000)) {
            stringBuffer.append(CONCAT_STRING);
            CElementLabels.getSourceRootLabel((ISourceRoot)iTranslationUnit.getParent(), 0, stringBuffer);
        }
    }

    public static void getTypeLabel(ICElement iCElement, int n, StringBuffer stringBuffer) {
        Object object;
        if (CElementLabels.getFlag(n, 8192) && (object = CModelUtil.getSourceRoot(iCElement)) != null) {
            CElementLabels.getSourceRootLabel((ISourceRoot)object, n & 0x20000000, stringBuffer);
            stringBuffer.append(object.getElementName());
            stringBuffer.append('.');
        }
        object = iCElement.getElementName();
        ((String)object).length();
        stringBuffer.append((String)object);
    }

    private static boolean getFlag(int n, int n2) {
        return (n & n2) != 0;
    }
}

