/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.dialogfields;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class CheckedListDialogField
extends ListDialogField {
    private int fCheckAllButtonIndex = -1;
    private int fUncheckAllButtonIndex = -1;
    private List fCheckElements = new ArrayList();

    public CheckedListDialogField(IListAdapter iListAdapter, String[] stringArray, ILabelProvider iLabelProvider) {
        super(iListAdapter, stringArray, iLabelProvider);
    }

    public void setCheckAllButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fCheckAllButtonIndex = n;
    }

    public void setUncheckAllButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fUncheckAllButtonIndex = n;
    }

    protected TableViewer createTableViewer(Composite composite) {
        Table table = new Table(composite, 32 + this.getListStyle());
        CheckboxTableViewer checkboxTableViewer = new CheckboxTableViewer(table);
        checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                CheckedListDialogField.this.doCheckStateChanged(checkStateChangedEvent);
            }
        });
        return checkboxTableViewer;
    }

    public Control getListControl(Composite composite) {
        Control control = super.getListControl(composite);
        if (composite != null) {
            ((CheckboxTableViewer)this.fTable).setCheckedElements(this.fCheckElements.toArray());
        }
        return control;
    }

    public void dialogFieldChanged() {
        int n = this.fCheckElements.size() - 1;
        while (n >= 0) {
            if (!this.fElements.contains(this.fCheckElements.get(n))) {
                this.fCheckElements.remove(n);
            }
            --n;
        }
        super.dialogFieldChanged();
    }

    private void checkStateChanged() {
        super.dialogFieldChanged();
    }

    public List getCheckedElements() {
        return new ArrayList(this.fCheckElements);
    }

    public boolean isChecked(Object object) {
        return this.fCheckElements.contains(object);
    }

    public void setCheckedElements(List list) {
        this.fCheckElements = new ArrayList(list);
        if (this.fTable != null) {
            ((CheckboxTableViewer)this.fTable).setCheckedElements(list.toArray());
        }
        this.checkStateChanged();
    }

    public void setChecked(Object object, boolean bl) {
        this.setCheckedWithoutUpdate(object, bl);
        this.checkStateChanged();
    }

    public void setCheckedWithoutUpdate(Object object, boolean bl) {
        if (!this.fCheckElements.contains(object)) {
            this.fCheckElements.add(object);
        }
        if (this.fTable != null) {
            ((CheckboxTableViewer)this.fTable).setChecked(object, bl);
        }
    }

    public void checkAll(boolean bl) {
        if (bl) {
            this.fCheckElements = this.getElements();
        } else {
            this.fCheckElements.clear();
        }
        if (this.fTable != null) {
            ((CheckboxTableViewer)this.fTable).setAllChecked(bl);
        }
        this.checkStateChanged();
    }

    protected void doCheckStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
        if (checkStateChangedEvent.getChecked()) {
            this.fCheckElements.add(checkStateChangedEvent.getElement());
        } else {
            this.fCheckElements.remove(checkStateChangedEvent.getElement());
        }
        this.checkStateChanged();
    }

    protected boolean getManagedButtonState(ISelection iSelection, int n) {
        if (n == this.fCheckAllButtonIndex) {
            return !this.fElements.isEmpty();
        }
        if (n == this.fUncheckAllButtonIndex) {
            return !this.fElements.isEmpty();
        }
        return super.getManagedButtonState(iSelection, n);
    }

    protected boolean managedButtonPressed(int n) {
        if (n == this.fCheckAllButtonIndex) {
            this.checkAll(true);
        } else if (n == this.fUncheckAllButtonIndex) {
            this.checkAll(false);
        } else {
            return super.managedButtonPressed(n);
        }
        return true;
    }
}

