/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.dialogfields;

import java.io.File;
import org.eclipse.cdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class LinkToFileGroup
extends StringButtonDialogField {
    private String fText;
    protected Listener listener;
    private String initialLinkTarget;
    private int type;
    protected boolean createLink = false;
    protected Text linkTargetField;
    protected Button linkButton;
    protected Button browseButton;
    private Label resolvedPathLabelText;
    private Label resolvedPathLabelData;
    private boolean preventDialogFieldChanged = false;

    public LinkToFileGroup(IStringButtonAdapter iStringButtonAdapter, Listener listener) {
        super(iStringButtonAdapter);
        this.listener = listener;
        this.type = 1;
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        label.setLayoutData((Object)DialogField.gridDataForLabel(1));
        this.getLinkCheckButtonControl(composite);
        Text text = this.getTextControl(composite);
        text.setLayoutData((Object)LinkToFileGroup.gridDataForText(2));
        Button button = this.getBrowseButtonControl(composite);
        button.setLayoutData((Object)StringButtonDialogField.gridDataForButton(button, 1));
        DialogField.createEmptySpace(composite);
        this.resolvedPathLabelText = new Label(composite, 4);
        this.resolvedPathLabelText.setText(NewWizardMessages.getString("CreateLinkedResourceGroup.resolvedPathLabel"));
        this.resolvedPathLabelText.setVisible(true);
        this.resolvedPathLabelData = new Label(composite, 4);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.resolvedPathLabelData.setLayoutData((Object)gridData);
        this.resolvedPathLabelData.setVisible(true);
        return null;
    }

    public int getNumberOfControls() {
        return 4;
    }

    public Button getLinkCheckButtonControl(Composite composite) {
        if (this.linkButton == null) {
            this.linkButton = new Button(composite, 32);
            this.linkButton.setText(NewWizardMessages.getString("NewClassWizardPage.files.linkFileButton"));
            this.linkButton.setSelection(this.createLink);
            this.linkButton.setFont(composite.getFont());
            SelectionAdapter selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    LinkToFileGroup.this.createLink = LinkToFileGroup.this.linkButton.getSelection();
                    LinkToFileGroup.this.browseButton.setEnabled(LinkToFileGroup.this.createLink);
                    LinkToFileGroup.this.linkTargetField.setEnabled(LinkToFileGroup.this.createLink);
                    LinkToFileGroup.this.resolveVariable();
                    if (LinkToFileGroup.this.listener != null) {
                        LinkToFileGroup.this.listener.handleEvent(new Event());
                    }
                    if (!LinkToFileGroup.this.preventDialogFieldChanged) {
                        LinkToFileGroup.this.dialogFieldChanged();
                    }
                }
            };
            this.linkButton.addSelectionListener((SelectionListener)selectionAdapter);
        }
        return this.linkButton;
    }

    public String getText() {
        return this.linkTargetField.getText();
    }

    public void setText(String string) {
        this.fText = string;
        if (this.isOkToUse((Control)this.linkTargetField)) {
            this.preventDialogFieldChanged = true;
            this.linkTargetField.setText(string);
            this.preventDialogFieldChanged = false;
        }
    }

    public Text getTextControl(Composite composite) {
        if (this.linkTargetField == null) {
            this.assertCompositeNotNull(composite);
            this.linkTargetField = new Text(composite, 2048);
            this.linkTargetField.setFont(composite.getFont());
            this.linkTargetField.setEnabled(this.createLink);
            this.linkTargetField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    LinkToFileGroup.this.resolveVariable();
                    if (LinkToFileGroup.this.listener != null) {
                        LinkToFileGroup.this.listener.handleEvent(new Event());
                    }
                    if (!LinkToFileGroup.this.preventDialogFieldChanged) {
                        LinkToFileGroup.this.dialogFieldChanged();
                    }
                }
            });
            if (this.initialLinkTarget != null) {
                this.linkTargetField.setText(this.initialLinkTarget);
            }
        }
        return this.linkTargetField;
    }

    public static GridData gridDataForText(int n) {
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalSpan = n;
        return gridData;
    }

    public Button getBrowseButtonControl(Composite composite) {
        if (this.browseButton == null) {
            this.assertCompositeNotNull(composite);
            this.browseButton = new Button(composite, 8);
            this.browseButton.setFont(composite.getFont());
            this.browseButton.setText(NewWizardMessages.getString("CreateLinkedResourceGroup.browseButton"));
            this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    LinkToFileGroup.this.handleLinkTargetBrowseButtonPressed();
                }
            });
            this.browseButton.setEnabled(this.createLink);
        }
        return this.browseButton;
    }

    private IStatus createStatus(int n, String string) {
        return new Status(n, CUIPlugin.getPluginId(), n, string, null);
    }

    public String getLinkTarget() {
        if (this.createLink && this.linkTargetField != null && !this.linkTargetField.isDisposed()) {
            return this.linkTargetField.getText();
        }
        return null;
    }

    public String getResolvedPath() {
        if (this.createLink && this.resolvedPathLabelData != null && !this.resolvedPathLabelData.isDisposed()) {
            return this.resolvedPathLabelData.getText();
        }
        return null;
    }

    protected void handleLinkTargetBrowseButtonPressed() {
        String string = this.linkTargetField.getText();
        File file = null;
        String string2 = null;
        if (!"".equals(string) && !(file = new File(string)).exists()) {
            file = null;
        }
        if (this.type == 1) {
            FileDialog fileDialog = new FileDialog(this.linkTargetField.getShell());
            fileDialog.setText(NewWizardMessages.getString("CreateLinkedResourceGroup.open"));
            if (file != null) {
                if (file.isFile()) {
                    fileDialog.setFileName(string);
                } else {
                    fileDialog.setFilterPath(string);
                }
            }
            string2 = fileDialog.open();
        } else {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.linkTargetField.getShell());
            directoryDialog.setText(NewWizardMessages.getString("CreateLinkedResourceGroup.open"));
            if (file != null) {
                if (file.isFile()) {
                    string = file.getParent();
                }
                if (string != null) {
                    directoryDialog.setFilterPath(string);
                }
            }
            directoryDialog.setMessage(NewWizardMessages.getString("CreateLinkedResourceGroup.targetSelectionLabel"));
            string2 = directoryDialog.open();
        }
        if (string2 != null) {
            this.linkTargetField.setText(string2);
            if (!this.preventDialogFieldChanged) {
                this.dialogFieldChanged();
            }
        }
    }

    protected void resolveVariable() {
        if (!this.linkTargetField.isEnabled()) {
            this.resolvedPathLabelData.setText("");
            return;
        }
        IPathVariableManager iPathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        Path path = new Path(this.linkTargetField.getText());
        IPath iPath = iPathVariableManager.resolvePath((IPath)path);
        this.resolvedPathLabelData.setText(iPath.toOSString());
    }

    public void setLinkTarget(String string) {
        this.initialLinkTarget = string;
        if (this.linkTargetField != null && !this.linkTargetField.isDisposed()) {
            this.linkTargetField.setText(string);
            if (!this.preventDialogFieldChanged) {
                this.dialogFieldChanged();
            }
        }
    }

    private IStatus validateFileType(File file) {
        if (this.type == 1 && !file.isFile()) {
            return this.createStatus(4, NewWizardMessages.getString("CreateLinkedResourceGroup.linkTargetNotFile"));
        }
        if (this.type == 2 && !file.isDirectory()) {
            return this.createStatus(4, NewWizardMessages.getString("CreateLinkedResourceGroup.linkTargetNotFolder"));
        }
        return this.createStatus(0, "");
    }

    public IStatus validateLinkLocation(IResource iResource) {
        if (this.linkTargetField == null || this.linkTargetField.isDisposed()) {
            return this.createStatus(0, "");
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        String string = this.linkTargetField.getText();
        Path path = new Path(string);
        if (!this.createLink) {
            return this.createStatus(0, "");
        }
        IStatus iStatus = iWorkspace.validateLinkLocation(iResource, (IPath)path);
        if (iStatus.getSeverity() == 4) {
            return iStatus;
        }
        string = this.resolvedPathLabelData.getText();
        path = new Path(string);
        File file = new Path(string).toFile();
        if (file.exists()) {
            IStatus iStatus2 = this.validateFileType(file);
            if (!iStatus2.isOK()) {
                return iStatus2;
            }
        } else if (iStatus.getSeverity() == 0) {
            return this.createStatus(2, NewWizardMessages.getString("CreateLinkedResourceGroup.linkTargetNonExistent"));
        }
        return iStatus;
    }

    public boolean linkCreated() {
        return this.createLink;
    }
}

