/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import org.eclipse.cdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.help.WorkbenchHelp;

public class EditWorkingSetAction
extends Action {
    private Shell fShell;
    private WorkingSetFilterActionGroup fActionGroup;

    public EditWorkingSetAction(WorkingSetFilterActionGroup workingSetFilterActionGroup, Shell shell) {
        super(WorkingSetMessages.getString("EditWorkingSetAction.text"));
        Assert.isNotNull((Object)((Object)workingSetFilterActionGroup));
        this.setToolTipText(WorkingSetMessages.getString("EditWorkingSetAction.toolTip"));
        this.setEnabled(workingSetFilterActionGroup.getWorkingSet() != null);
        this.fShell = shell;
        this.fActionGroup = workingSetFilterActionGroup;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.edit_working_set_action");
    }

    public void run() {
        if (this.fShell == null) {
            this.fShell = CUIPlugin.getActiveWorkbenchShell();
        }
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet iWorkingSet = this.fActionGroup.getWorkingSet();
        if (iWorkingSet == null) {
            this.setEnabled(false);
            return;
        }
        IWorkingSetEditWizard iWorkingSetEditWizard = iWorkingSetManager.createWorkingSetEditWizard(iWorkingSet);
        if (iWorkingSetEditWizard == null) {
            String string = WorkingSetMessages.getString("EditWorkingSetAction.nowizard.title");
            String string2 = WorkingSetMessages.getString("EditWorkingSetAction.nowizard.message");
            MessageDialog.openError((Shell)this.fShell, (String)string, (String)string2);
            return;
        }
        WizardDialog wizardDialog = new WizardDialog(this.fShell, (IWizard)iWorkingSetEditWizard);
        wizardDialog.create();
        if (wizardDialog.open() == 0) {
            this.fActionGroup.setWorkingSet(iWorkingSetEditWizard.getSelection(), true);
        }
    }
}

