/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import org.eclipse.cdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class SelectWorkingSetAction
extends Action {
    private Shell fShell;
    private WorkingSetFilterActionGroup fActionGroup;

    public SelectWorkingSetAction(WorkingSetFilterActionGroup workingSetFilterActionGroup, Shell shell) {
        super(WorkingSetMessages.getString("SelectWorkingSetAction.text"));
        Assert.isNotNull((Object)((Object)workingSetFilterActionGroup));
        this.setToolTipText(WorkingSetMessages.getString("SelectWorkingSetAction.toolTip"));
        this.fShell = shell;
        this.fActionGroup = workingSetFilterActionGroup;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.select_working_set_action");
    }

    public void run() {
        if (this.fShell == null) {
            this.fShell = CUIPlugin.getActiveWorkbenchShell();
        }
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog iWorkingSetSelectionDialog = iWorkingSetManager.createWorkingSetSelectionDialog(this.fShell, false);
        IWorkingSet iWorkingSet = this.fActionGroup.getWorkingSet();
        if (iWorkingSet != null) {
            iWorkingSetSelectionDialog.setSelection(new IWorkingSet[]{iWorkingSet});
        }
        if (iWorkingSetSelectionDialog.open() == 0) {
            IWorkingSet[] iWorkingSetArray = iWorkingSetSelectionDialog.getSelection();
            if (iWorkingSetArray != null && iWorkingSetArray.length > 0) {
                this.fActionGroup.setWorkingSet(iWorkingSetArray[0], true);
                iWorkingSetManager.addRecentWorkingSet(iWorkingSetArray[0]);
            } else {
                this.fActionGroup.setWorkingSet(null, true);
            }
        }
    }
}

