/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.ui.workingsets.ClearWorkingSetAction;
import org.eclipse.cdt.internal.ui.workingsets.EditWorkingSetAction;
import org.eclipse.cdt.internal.ui.workingsets.SelectWorkingSetAction;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetComparator;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetFilter;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMenuContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;

public class WorkingSetFilterActionGroup
extends ActionGroup {
    private static final String TAG_WORKING_SET_NAME = "workingSetName";
    private static final String SEPARATOR_ID = "workingSetGroupSeparator";
    private WorkingSetFilter fWorkingSetFilter;
    private IWorkingSet fWorkingSet = null;
    private ClearWorkingSetAction fClearWorkingSetAction;
    private SelectWorkingSetAction fSelectWorkingSetAction;
    private EditWorkingSetAction fEditWorkingSetAction;
    private IPropertyChangeListener fWorkingSetListener;
    private IPropertyChangeListener fChangeListener;
    private int fLRUMenuCount;
    private IMenuManager fMenuManager;
    private IMenuListener fMenuListener;

    public WorkingSetFilterActionGroup(String string, Shell shell, IPropertyChangeListener iPropertyChangeListener) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)iPropertyChangeListener);
        this.fChangeListener = iPropertyChangeListener;
        this.fClearWorkingSetAction = new ClearWorkingSetAction(this);
        this.fSelectWorkingSetAction = new SelectWorkingSetAction(this, shell);
        this.fEditWorkingSetAction = new EditWorkingSetAction(this, shell);
        this.fWorkingSetListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WorkingSetFilterActionGroup.this.doPropertyChange(propertyChangeEvent);
            }
        };
        this.fWorkingSetFilter = new WorkingSetFilter();
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        iWorkingSetManager.addPropertyChangeListener(this.fWorkingSetListener);
    }

    public boolean isFiltered(Object object, Object object2) {
        if (this.fWorkingSetFilter == null) {
            return false;
        }
        return !this.fWorkingSetFilter.select(null, object, object2);
    }

    public IWorkingSet getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(IWorkingSet iWorkingSet, boolean bl) {
        this.fClearWorkingSetAction.setEnabled(iWorkingSet != null);
        this.fEditWorkingSetAction.setEnabled(iWorkingSet != null);
        this.fWorkingSet = iWorkingSet;
        this.fWorkingSetFilter.setWorkingSet(iWorkingSet);
        if (bl) {
            this.fChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "workingSetContentChange", null, (Object)iWorkingSet));
        }
    }

    public void saveState(IMemento iMemento) {
        String string = "";
        if (this.fWorkingSet != null) {
            string = this.fWorkingSet.getName();
        }
        iMemento.putString(TAG_WORKING_SET_NAME, string);
    }

    public void restoreState(IMemento iMemento) {
        String string = iMemento.getString(TAG_WORKING_SET_NAME);
        IWorkingSet iWorkingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(string);
        this.setWorkingSet(iWorkingSet, false);
    }

    public void fillActionBars(IActionBars iActionBars) {
        this.contributeToToolBar(iActionBars.getToolBarManager());
        this.contributeToMenu(iActionBars.getMenuManager());
    }

    public void contributeToToolBar(IToolBarManager iToolBarManager) {
    }

    public void contributeToMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.fSelectWorkingSetAction);
        iMenuManager.add((IAction)this.fClearWorkingSetAction);
        iMenuManager.add((IAction)this.fEditWorkingSetAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IContributionItem)new Separator(SEPARATOR_ID));
        this.addLRUWorkingSetActions(iMenuManager);
        this.fMenuManager = iMenuManager;
        this.fMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                WorkingSetFilterActionGroup.this.removePreviousLRUWorkingSetActions(iMenuManager);
                WorkingSetFilterActionGroup.this.addLRUWorkingSetActions(iMenuManager);
            }
        };
        this.fMenuManager.addMenuListener(this.fMenuListener);
    }

    private void removePreviousLRUWorkingSetActions(IMenuManager iMenuManager) {
        int n = 1;
        while (n <= this.fLRUMenuCount) {
            iMenuManager.remove(WorkingSetMenuContributionItem.getId(n));
            ++n;
        }
    }

    private void addLRUWorkingSetActions(IMenuManager iMenuManager) {
        IWorkingSet[] iWorkingSetArray = PlatformUI.getWorkbench().getWorkingSetManager().getRecentWorkingSets();
        List<IWorkingSet> list = Arrays.asList(iWorkingSetArray);
        Collections.sort(list, new WorkingSetComparator());
        Iterator<IWorkingSet> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            IWorkingSet iWorkingSet = iterator.next();
            if (iWorkingSet == null) continue;
            WorkingSetMenuContributionItem workingSetMenuContributionItem = new WorkingSetMenuContributionItem(++n, this, iWorkingSet);
            iMenuManager.insertBefore(SEPARATOR_ID, (IContributionItem)workingSetMenuContributionItem);
        }
        this.fLRUMenuCount = n;
    }

    public void dispose() {
        if (this.fMenuManager != null) {
            this.fMenuManager.removeMenuListener(this.fMenuListener);
        }
        if (this.fWorkingSetListener != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.fWorkingSetListener);
            this.fWorkingSetListener = null;
        }
        this.fChangeListener = null;
        super.dispose();
    }

    public ViewerFilter getWorkingSetFilter() {
        return this.fWorkingSetFilter;
    }

    private void doPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        IWorkingSet iWorkingSet;
        String string = propertyChangeEvent.getProperty();
        if ("workingSetNameChange".equals(string)) {
            this.fChangeListener.propertyChange(propertyChangeEvent);
        } else if ("workingSetContentChange".equals(string) && (iWorkingSet = (IWorkingSet)propertyChangeEvent.getNewValue()).equals(this.fWorkingSet)) {
            this.fChangeListener.propertyChange(propertyChangeEvent);
        }
    }
}

