/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.ui.BaseCElementContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class CElementContentProvider
extends BaseCElementContentProvider
implements ITreeContentProvider,
IElementChangedListener {
    protected StructuredViewer fViewer;
    protected Object fInput;

    public void dispose() {
        super.dispose();
        CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        super.inputChanged(viewer, object, object2);
        this.fViewer = (StructuredViewer)viewer;
        if (object == null && object2 != null) {
            CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this);
        } else if (object != null && object2 == null) {
            CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInput = object2;
    }

    public CElementContentProvider() {
    }

    public CElementContentProvider(boolean bl, boolean bl2) {
        super(bl, bl2);
    }

    public void elementChanged(ElementChangedEvent elementChangedEvent) {
        try {
            this.processDelta(elementChangedEvent.getDelta());
        }
        catch (CModelException cModelException) {
            CUIPlugin.getDefault().log(cModelException);
            cModelException.printStackTrace();
        }
    }

    protected boolean isPathEntryChange(ICElementDelta iCElementDelta) {
        int n = iCElementDelta.getFlags();
        return iCElementDelta.getKind() == 4 && ((n & 0x800000) != 0 || (n & 0x1000) != 0 || (n & 0x100) != 0 || (n & 0x2000) != 0 || (n & 0x40000) != 0 || (n & 0x200) != 0 || (n & 0x800) != 0);
    }

    protected void processDelta(ICElementDelta iCElementDelta) throws CModelException {
        int n;
        IResourceDelta[] iResourceDeltaArray;
        int n2 = iCElementDelta.getKind();
        int n3 = iCElementDelta.getFlags();
        ICElement iCElement = iCElementDelta.getElement();
        if ((n3 & 0x80) != 0 || (n3 & 0x40) != 0) {
            this.postRefresh(iCElement);
        }
        if (n2 == 2) {
            iResourceDeltaArray = this.internalGetParent(iCElement);
            this.postRemove(iCElement);
            if (this.updateContainer(iCElement)) {
                this.postRefresh(iResourceDeltaArray);
            }
        }
        if (n2 == 1) {
            iResourceDeltaArray = this.internalGetParent(iCElement);
            this.postAdd(iResourceDeltaArray, iCElement);
            if (this.updateContainer(iCElement)) {
                this.postRefresh(iResourceDeltaArray);
            }
        }
        if (n2 == 4) {
            if (iCElement instanceof ITranslationUnit || iCElement instanceof IBinary || iCElement instanceof IArchive) {
                this.postRefresh(iCElement);
                return;
            }
            if (iCElement instanceof ArchiveContainer || iCElement instanceof BinaryContainer) {
                this.postContainerRefresh((IParent)iCElement, iCElement.getCProject());
            }
        }
        if (this.isPathEntryChange(iCElementDelta)) {
            this.postRefresh(iCElement.getCProject());
        }
        if (iCElementDelta.getResourceDeltas() != null) {
            iResourceDeltaArray = iCElementDelta.getResourceDeltas();
            n = 0;
            while (n < iResourceDeltaArray.length) {
                this.processResourceDelta(iResourceDeltaArray[n], iCElement);
                ++n;
            }
        }
        iResourceDeltaArray = iCElementDelta.getAffectedChildren();
        n = 0;
        while (n < iResourceDeltaArray.length) {
            this.processDelta((ICElementDelta)iResourceDeltaArray[n]);
            ++n;
        }
    }

    private void processResourceDelta(IResourceDelta iResourceDelta, Object object) {
        IResourceDelta[] iResourceDeltaArray;
        int n = iResourceDelta.getKind();
        IResource iResource = iResourceDelta.getResource();
        if (iResource == null) {
            return;
        }
        if ((n & 2) != 0) {
            this.postRemove(iResource);
        }
        if ((n & 1) != 0) {
            this.postAdd(object, iResource);
        }
        if ((iResourceDeltaArray = iResourceDelta.getAffectedChildren()).length > 1) {
            this.postRefresh(iResource);
            return;
        }
        int n2 = 0;
        while (n2 < iResourceDeltaArray.length) {
            this.processResourceDelta(iResourceDeltaArray[n2], iResource);
            ++n2;
        }
    }

    private boolean updateContainer(ICElement iCElement) throws CModelException {
        IArchiveContainer iArchiveContainer = null;
        ICProject iCProject = null;
        if (iCElement instanceof IBinary) {
            IBinary iBinary = (IBinary)iCElement;
            if (iBinary.isExecutable() || iBinary.isSharedLib()) {
                iCProject = iBinary.getCProject();
                iArchiveContainer = iCProject.getBinaryContainer();
            }
        } else if (iCElement instanceof IArchive) {
            iCProject = iCElement.getCProject();
            iArchiveContainer = iCProject.getArchiveContainer();
        }
        if (iArchiveContainer != null) {
            this.postContainerRefresh((IParent)iArchiveContainer, iCProject);
            return true;
        }
        return false;
    }

    private void postContainerRefresh(final IParent iParent, final ICProject iCProject) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = CElementContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    if (iParent.hasChildren()) {
                        if (CElementContentProvider.this.fViewer.testFindItem((Object)iParent) != null) {
                            CElementContentProvider.this.fViewer.refresh((Object)iParent);
                        } else {
                            CElementContentProvider.this.fViewer.refresh((Object)iCProject);
                        }
                    } else {
                        CElementContentProvider.this.fViewer.refresh((Object)iCProject);
                    }
                }
            }
        });
    }

    private void postRefresh(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = CElementContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    if (object instanceof IWorkingCopy) {
                        if (CElementContentProvider.this.fViewer.testFindItem(object) != null) {
                            CElementContentProvider.this.fViewer.refresh(object);
                        } else {
                            CElementContentProvider.this.fViewer.refresh((Object)((IWorkingCopy)object).getOriginalElement());
                        }
                    } else {
                        CElementContentProvider.this.fViewer.refresh(object);
                    }
                }
            }
        });
    }

    private void postAdd(final Object object, Object object2) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = CElementContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    if (object instanceof IWorkingCopy) {
                        if (CElementContentProvider.this.fViewer.testFindItem(object) != null) {
                            CElementContentProvider.this.fViewer.refresh(object);
                        } else {
                            CElementContentProvider.this.fViewer.refresh((Object)((IWorkingCopy)object).getOriginalElement());
                        }
                    } else {
                        CElementContentProvider.this.fViewer.refresh(object);
                    }
                }
            }
        });
    }

    private void postRemove(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = CElementContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    Object object2 = CElementContentProvider.this.internalGetParent(object);
                    if (object2 instanceof IWorkingCopy) {
                        if (CElementContentProvider.this.fViewer.testFindItem(object2) != null) {
                            CElementContentProvider.this.fViewer.refresh(object2);
                        } else {
                            CElementContentProvider.this.fViewer.refresh((Object)((IWorkingCopy)object2).getOriginalElement());
                        }
                    } else {
                        CElementContentProvider.this.fViewer.refresh(object2);
                    }
                }
            }
        });
    }

    private void postRunnable(Runnable runnable) {
        Control control = this.fViewer.getControl();
        if (control != null && !control.isDisposed()) {
            control.getDisplay().asyncExec(runnable);
        }
    }
}

