/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class CElementImageDescriptor
extends CompositeImageDescriptor {
    public static final int TEMPLATE = 1;
    public static final int CONSTANT = 2;
    public static final int VOLATILE = 4;
    public static final int STATIC = 8;
    public static final int RUNNABLE = 16;
    public static final int WARNING = 32;
    public static final int ERROR = 64;
    public static final int OVERRIDES = 128;
    public static final int IMPLEMENTS = 256;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;
    static /* synthetic */ Class class$0;

    public CElementImageDescriptor(ImageDescriptor imageDescriptor, int n, Point point) {
        this.fBaseImage = imageDescriptor;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = n;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = point;
        Assert.isNotNull((Object)this.fSize);
    }

    public void setAdornments(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fFlags = n;
    }

    public int getAdronments() {
        return this.fFlags;
    }

    public void setImageSize(Point point) {
        Assert.isNotNull((Object)point);
        Assert.isTrue((point.x >= 0 && point.y >= 0 ? 1 : 0) != 0);
        this.fSize = point;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.ui.CElementImageDescriptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.equals(object.getClass())) {
            return false;
        }
        CElementImageDescriptor cElementImageDescriptor = (CElementImageDescriptor)((Object)object);
        return this.fBaseImage.equals(cElementImageDescriptor.fBaseImage) && this.fFlags == cElementImageDescriptor.fFlags && this.fSize.equals((Object)cElementImageDescriptor.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }

    protected void drawCompositeImage(int n, int n2) {
        ImageData imageData = this.fBaseImage.getImageData();
        if (imageData == null) {
            imageData = ImageDescriptor.DEFAULT_IMAGE_DATA;
        }
        this.drawImage(imageData, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    private void drawTopRight() {
        int n = this.getSize().x;
        ImageData imageData = null;
        if ((this.fFlags & 4) != 0) {
            imageData = CPluginImages.DESC_OVR_VOLATILE.getImageData();
            this.drawImage(imageData, n -= imageData.width, 0);
        }
        if ((this.fFlags & 2) != 0) {
            imageData = CPluginImages.DESC_OVR_CONSTANT.getImageData();
            this.drawImage(imageData, n -= imageData.width, 0);
        }
        if ((this.fFlags & 8) != 0) {
            imageData = CPluginImages.DESC_OVR_STATIC.getImageData();
            this.drawImage(imageData, n -= imageData.width, 0);
        }
        if ((this.fFlags & 1) != 0) {
            imageData = CPluginImages.DESC_OVR_TEMPLATE.getImageData();
            this.drawImage(imageData, n -= imageData.width, 0);
        }
    }

    private void drawBottomRight() {
    }

    private void drawBottomLeft() {
        Point point = this.getSize();
        int n = 0;
        ImageData imageData = null;
        if ((this.fFlags & 0x40) != 0) {
            imageData = CPluginImages.DESC_OVR_ERROR.getImageData();
            this.drawImage(imageData, n, point.y - imageData.height);
            n += imageData.width;
        }
        if ((this.fFlags & 0x20) != 0) {
            imageData = CPluginImages.DESC_OVR_WARNING.getImageData();
            this.drawImage(imageData, n, point.y - imageData.height);
            n += imageData.width;
        }
    }
}

