/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.IWorkingCopyProvider;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.cdt.internal.ui.CElementAdapterFactory;
import org.eclipse.cdt.internal.ui.ResourceAdapterFactory;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleManager;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.CustomBufferFactory;
import org.eclipse.cdt.internal.ui.editor.SharedTextColors;
import org.eclipse.cdt.internal.ui.editor.WorkingCopyManager;
import org.eclipse.cdt.internal.ui.editor.asm.AsmTextTools;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.PreferencesAdapter;
import org.eclipse.cdt.internal.ui.text.c.hover.CEditorTextHoverDescriptor;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.internal.ui.util.ProblemMarkerManager;
import org.eclipse.cdt.internal.ui.util.Util;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;
import org.osgi.framework.BundleContext;

public class CUIPlugin
extends AbstractUIPlugin {
    private ISharedTextColors fSharedTextColors;
    public static final String PLUGIN_ID = "org.eclipse.cdt.ui";
    public static final String PLUGIN_CORE_ID = "org.eclipse.cdt.core";
    public static final String EDITOR_ID = "org.eclipse.cdt.ui.editor.CEditor";
    public static final String CVIEW_ID = "org.eclipse.cdt.ui.CView";
    public static final String C_PROBLEMMARKER = "org.eclipse.cdt.core.problem";
    public static final String C_PROJECT_WIZARD_ID = "org.eclipse.cdt.ui.wizards.StdCWizard";
    public static final String CPP_PROJECT_WIZARD_ID = "org.eclipse.cdt.ui.wizards.StdCCWizard";
    public static final String FILE_WIZARD_ID = "org.eclipse.ui.wizards.new.file";
    public static final String FOLDER_WIZARD_ID = "org.eclipse.ui.wizards.new.folder";
    public static final String CLASS_WIZARD_ID = "org.eclipse.cdt.ui.wizards.NewClassWizard";
    public static final String SEARCH_ACTION_SET_ID = "org.eclipse.cdt.ui.SearchActionSet";
    public static final String FOLDER_ACTION_SET_ID = "org.eclipse.cdt.ui.CFolderActionSet";
    public static final String BUILDER_ID = "org.eclipse.cdt.core.cbuilder";
    private static CUIPlugin fgCPlugin;
    private static ResourceBundle fgResourceBundle;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private CEditorTextHoverDescriptor[] fCEditorTextHoverDescriptors;
    private IPreferenceStore fCombinedPreferenceStore;
    static String SEPARATOR;
    private static final String CONTENTASSIST = "org.eclipse.cdt.ui/debug/contentassist";
    public static final String ID_CPERSPECTIVE = "org.eclipse.cdt.ui.CPerspective";
    public static final String ID_CHIERARCHY_PERSPECTIVE = "org.eclipse.cdt.ui.CHierarchyPerspective";
    public static final String ID_CBROWSING_PERSPECTIVE = "org.eclipse.cdt.ui.CBrowsingPerspective";
    public static String ID_PROJECTS_VIEW;
    public static String ID_NAMESPACES_VIEW;
    public static String ID_TYPES_VIEW;
    public static String ID_MEMBERS_VIEW;
    private CoreModel fCoreModel;
    private CDocumentProvider fDocumentProvider;
    private IBufferFactory fBufferFactory;
    private WorkingCopyManager fWorkingCopyManager;
    private CTextTools fTextTools;
    private AsmTextTools fAsmTextTools;
    private ProblemMarkerManager fProblemMarkerManager;
    private BuildConsoleManager fBuildConsoleManager;
    private ResourceAdapterFactory fResourceAdapterFactory;
    private CElementAdapterFactory fCElementAdapterFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        SEPARATOR = System.getProperty("file.separator");
        ID_PROJECTS_VIEW = "org.eclipse.cdt.ui.ProjectsView";
        ID_NAMESPACES_VIEW = "org.eclipse.cdt.ui.NamespacesView";
        ID_TYPES_VIEW = "org.eclipse.cdt.ui.TypesView";
        ID_MEMBERS_VIEW = "org.eclipse.cdt.ui.MembersView";
        try {
            fgResourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.internal.ui.CPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            fgResourceBundle = null;
        }
    }

    public synchronized IBufferFactory getBufferFactory() {
        if (this.fBufferFactory == null) {
            this.fBufferFactory = new CustomBufferFactory();
        }
        return this.fBufferFactory;
    }

    public static IWorkingCopy[] getSharedWorkingCopies() {
        return CCorePlugin.getSharedWorkingCopies((IBufferFactory)CUIPlugin.getDefault().getBufferFactory());
    }

    public static String getResourceString(String string) {
        try {
            return fgResourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + string + "!";
        }
        catch (NullPointerException nullPointerException) {
            return "#" + string + "#";
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getFormattedString(String string, String string2) {
        return MessageFormat.format(CUIPlugin.getResourceString(string), string2);
    }

    public static String getFormattedString(String string, String[] stringArray) {
        return MessageFormat.format(CUIPlugin.getResourceString(string), stringArray);
    }

    public static ResourceBundle getResourceBundle() {
        return fgResourceBundle;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return CUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = CUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = CUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }

    public static CUIPlugin getDefault() {
        return fgCPlugin;
    }

    public void log(Throwable throwable) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", throwable));
    }

    public void log(IStatus iStatus) {
        this.getLog().log(iStatus);
    }

    public void logErrorMessage(String string) {
        this.log((IStatus)new Status(4, CUIPlugin.getPluginId(), 10001, string, null));
    }

    public static void errorDialog(Shell shell, String string, String string2, IStatus iStatus) {
        CUIPlugin.getDefault().log(iStatus);
        if (iStatus != null && string2.equals(iStatus.getMessage())) {
            string2 = null;
        }
        ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)iStatus);
    }

    public static void errorDialog(Shell shell, String string, String string2, Throwable throwable) {
        IStatus iStatus;
        CUIPlugin.getDefault().log(throwable);
        if (throwable instanceof CoreException) {
            iStatus = ((CoreException)throwable).getStatus();
            if (iStatus != null && string2.equals(iStatus.getMessage())) {
                string2 = null;
            }
        } else {
            iStatus = new Status(4, PLUGIN_ID, -1, "Internal Error: ", throwable);
        }
        ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)iStatus);
    }

    public CUIPlugin() {
        fgCPlugin = this;
        this.fDocumentProvider = null;
        this.fTextTools = null;
    }

    public synchronized CDocumentProvider getDocumentProvider() {
        if (this.fDocumentProvider == null) {
            this.fDocumentProvider = new CDocumentProvider();
        }
        return this.fDocumentProvider;
    }

    public synchronized IWorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            CDocumentProvider cDocumentProvider = this.getDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(cDocumentProvider);
        }
        return this.fWorkingCopyManager;
    }

    public CTextTools getTextTools() {
        if (this.fTextTools == null) {
            this.fTextTools = new CTextTools(this.getPreferenceStore(), CCorePlugin.getDefault().getPluginPreferences());
        }
        return this.fTextTools;
    }

    public AsmTextTools getAsmTextTools() {
        if (this.fAsmTextTools == null) {
            this.fAsmTextTools = new AsmTextTools(this.getPreferenceStore(), CCorePlugin.getDefault().getPluginPreferences());
        }
        return this.fAsmTextTools;
    }

    public IBuildConsoleManager getConsoleManager() {
        if (this.fBuildConsoleManager == null) {
            this.fBuildConsoleManager = new BuildConsoleManager();
            this.fBuildConsoleManager.startup();
        }
        return this.fBuildConsoleManager;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.configurePluginDebugOptions();
        this.registerAdapters();
        AllTypesCache.initialize((IWorkingCopyProvider)new IWorkingCopyProvider(){

            public IWorkingCopy[] getWorkingCopies() {
                return CUIPlugin.getSharedWorkingCopies();
            }
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
        AllTypesCache.terminate();
        if (this.fTextTools != null) {
            this.fTextTools.dispose();
        }
        if (this.fImageDescriptorRegistry != null) {
            this.fImageDescriptorRegistry.dispose();
        }
        if (this.fBuildConsoleManager != null) {
            this.fBuildConsoleManager.shutdown();
            this.fBuildConsoleManager = null;
        }
        this.unregisterAdapters();
        if (this.fWorkingCopyManager != null) {
            this.fWorkingCopyManager.shutdown();
            this.fWorkingCopyManager = null;
        }
        if (this.fDocumentProvider != null) {
            this.fDocumentProvider.shutdown();
            this.fDocumentProvider = null;
        }
        Refactoring.getUndoManager().shutdown();
        super.stop(bundleContext);
    }

    public CoreModel getCoreModel() {
        return this.fCoreModel;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return CUIPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    protected void registerAdapters() {
        this.fResourceAdapterFactory = new ResourceAdapterFactory();
        this.fCElementAdapterFactory = new CElementAdapterFactory();
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)this.fResourceAdapterFactory, (Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.core.model.ICElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)this.fCElementAdapterFactory, (Class)clazz2);
    }

    private void unregisterAdapters() {
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        iAdapterManager.unregisterAdapters((IAdapterFactory)this.fResourceAdapterFactory);
        iAdapterManager.unregisterAdapters((IAdapterFactory)this.fCElementAdapterFactory);
    }

    public ISharedTextColors getSharedTextColors() {
        if (this.fSharedTextColors == null) {
            this.fSharedTextColors = new SharedTextColors();
        }
        return this.fSharedTextColors;
    }

    public void configurePluginDebugOptions() {
        String string;
        if (this.isDebugging() && (string = Platform.getDebugOption((String)CONTENTASSIST)) != null) {
            Util.VERBOSE_CONTENTASSIST = string.equalsIgnoreCase("true");
        }
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore iPreferenceStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), new PreferencesAdapter(CCorePlugin.getDefault().getPluginPreferences()), iPreferenceStore});
        }
        return this.fCombinedPreferenceStore;
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> hashSet = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>(0);
        IWorkbench iWorkbench = CUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IEditorPart[] iEditorPartArray = iWorkbenchPageArray[n2].getDirtyEditors();
                int n3 = 0;
                while (n3 < iEditorPartArray.length) {
                    IEditorPart iEditorPart = iEditorPartArray[n3];
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (!hashSet.contains(iEditorInput)) {
                        hashSet.add(iEditorInput);
                        arrayList.add(iEditorPart);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new IEditorPart[arrayList.size()]);
    }

    public static IEditorPart[] getInstanciatedEditors() {
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>(0);
        IWorkbench iWorkbench = CUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IEditorReference[] iEditorReferenceArray = iWorkbenchPageArray[n2].getEditorReferences();
                int n3 = 0;
                while (n3 < iEditorReferenceArray.length) {
                    IEditorPart iEditorPart = iEditorReferenceArray[n3].getEditor(false);
                    if (iEditorPart != null) {
                        arrayList.add(iEditorPart);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new IEditorPart[arrayList.size()]);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void createStandardGroups(IMenuManager iMenuManager) {
        if (!iMenuManager.isEmpty()) {
            return;
        }
        iMenuManager.add((IContributionItem)new Separator("group.new"));
        iMenuManager.add((IContributionItem)new GroupMarker("group.goto"));
        iMenuManager.add((IContributionItem)new Separator("group.open"));
        iMenuManager.add((IContributionItem)new GroupMarker("group.show"));
        iMenuManager.add((IContributionItem)new Separator("group.reorganize"));
        iMenuManager.add((IContributionItem)new Separator("group.generate"));
        iMenuManager.add((IContributionItem)new Separator("group.search"));
        iMenuManager.add((IContributionItem)new Separator("group.build"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator("group.viewerSetup"));
        iMenuManager.add((IContributionItem)new Separator("group.properties"));
    }

    public CEditorTextHoverDescriptor[] getCEditorTextHoverDescriptors() {
        if (this.fCEditorTextHoverDescriptors == null) {
            this.fCEditorTextHoverDescriptors = CEditorTextHoverDescriptor.getContributedHovers();
            ConfigurationElementSorter configurationElementSorter = new ConfigurationElementSorter(){

                public IConfigurationElement getConfigurationElement(Object object) {
                    return ((CEditorTextHoverDescriptor)object).getConfigurationElement();
                }
            };
            configurationElementSorter.sort((Object[])this.fCEditorTextHoverDescriptors);
            int n = this.fCEditorTextHoverDescriptors.length;
            int n2 = -1;
            int n3 = n - 1;
            int n4 = -1;
            int n5 = -1;
            int n6 = 0;
            while (n6 < n) {
                if (!this.fCEditorTextHoverDescriptors[n6].getId().startsWith(PLUGIN_ID)) {
                    if (n4 != -1 && n5 != -1) {
                        n3 = n6 - 1;
                        break;
                    }
                } else {
                    if (n2 == -1) {
                        n2 = n6;
                    }
                    if (this.fCEditorTextHoverDescriptors[n6].getId().equals("org.eclipse.cdt.ui.AnnotationHover")) {
                        n5 = n6;
                    } else if (this.fCEditorTextHoverDescriptors[n6].getId().equals("org.eclipse.cdt.ui.ProblemHover")) {
                        n4 = n6;
                    }
                }
                ++n6;
            }
            CEditorTextHoverDescriptor cEditorTextHoverDescriptor = null;
            if (n2 > -1 && n4 > -1 && n4 != n2) {
                cEditorTextHoverDescriptor = this.fCEditorTextHoverDescriptors[n2];
                this.fCEditorTextHoverDescriptors[n2] = this.fCEditorTextHoverDescriptors[n4];
                this.fCEditorTextHoverDescriptors[n4] = cEditorTextHoverDescriptor;
                if (n5 == n2) {
                    n5 = n4;
                }
            }
            if (n5 > -1 && n5 != n3) {
                cEditorTextHoverDescriptor = this.fCEditorTextHoverDescriptors[n3];
                this.fCEditorTextHoverDescriptors[n3] = this.fCEditorTextHoverDescriptors[n5];
                this.fCEditorTextHoverDescriptors[n5] = cEditorTextHoverDescriptor;
            }
        }
        return this.fCEditorTextHoverDescriptors;
    }

    public void resetCEditorTextHoverDescriptors() {
        this.fCEditorTextHoverDescriptors = null;
    }
}

