/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.internal.ui.filters.CustomFiltersDialog;
import org.eclipse.cdt.internal.ui.filters.FilterDescriptor;
import org.eclipse.cdt.internal.ui.filters.FilterMessages;
import org.eclipse.cdt.internal.ui.filters.NamePatternFilter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionGroup;

public class CustomFiltersActionGroup
extends ActionGroup {
    private static final String TAG_CUSTOM_FILTERS = "customFilters";
    private static final String TAG_USER_DEFINED_PATTERNS_ENABLED = "userDefinedPatternsEnabled";
    private static final String TAG_USER_DEFINED_PATTERNS = "userDefinedPatterns";
    private static final String TAG_XML_DEFINED_FILTERS = "xmlDefinedFilters";
    private static final String TAG_LRU_FILTERS = "lastRecentlyUsedFilters";
    private static final String TAG_CHILD = "child";
    private static final String TAG_PATTERN = "pattern";
    private static final String TAG_FILTER_ID = "filterId";
    private static final String TAG_IS_ENABLED = "isEnabled";
    private static final String SEPARATOR = ",";
    private static final int MAX_FILTER_MENU_ENTRIES = 3;
    private static final String RECENT_FILTERS_GROUP_NAME = "recentFiltersGroup";
    private StructuredViewer fViewer;
    private NamePatternFilter fPatternFilter;
    private Map fInstalledBuiltInFilters;
    private Map fEnabledFilterIds;
    private boolean fUserDefinedPatternsEnabled;
    private String[] fUserDefinedPatterns;
    private Stack fLRUFilterIdsStack;
    private IMenuManager fMenuManager;
    private IMenuListener fMenuListener;
    private String[] fFilterIdsUsedInLastViewMenu;
    private HashMap fFilterDescriptorMap;
    private String fTargetId;

    public CustomFiltersActionGroup(IViewPart iViewPart, StructuredViewer structuredViewer) {
        this(iViewPart.getViewSite().getId(), structuredViewer);
    }

    public CustomFiltersActionGroup(String string, StructuredViewer structuredViewer) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)structuredViewer);
        this.fTargetId = string;
        this.fViewer = structuredViewer;
        this.fLRUFilterIdsStack = new Stack();
        this.initializeWithPluginContributions();
        this.initializeWithViewDefaults();
        this.installFilters();
    }

    public void fillActionBars(IActionBars iActionBars) {
        this.fillToolBar(iActionBars.getToolBarManager());
        this.fillViewMenu(iActionBars.getMenuManager());
    }

    public String[] removeFiltersFor(Object object, Object object2, IContentProvider iContentProvider) {
        String[] stringArray = this.getEnabledFilterIds();
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            ViewerFilter viewerFilter = (ViewerFilter)this.fInstalledBuiltInFilters.get(string);
            if (viewerFilter == null) {
                hashSet.add(string);
            } else if (this.isSelected(object, object2, iContentProvider, viewerFilter)) {
                hashSet.add(string);
            }
            ++n;
        }
        if (hashSet.size() == stringArray.length) {
            return new String[0];
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public void setFilters(String[] stringArray) {
        this.setEnabledFilterIds(stringArray);
        this.updateViewerFilters(true);
    }

    private boolean isSelected(Object object, Object object2, IContentProvider iContentProvider, ViewerFilter viewerFilter) {
        if (iContentProvider instanceof ITreeContentProvider) {
            ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)iContentProvider;
            while (object2 != null && !(object2 instanceof ICModel)) {
                if (!viewerFilter.select((Viewer)this.fViewer, object, object2)) {
                    return false;
                }
                object2 = iTreeContentProvider.getParent(object2);
            }
            return true;
        }
        return viewerFilter.select((Viewer)this.fViewer, object, object2);
    }

    private void setFilter(String string, boolean bl) {
        this.fLRUFilterIdsStack.remove(string);
        this.fLRUFilterIdsStack.add(0, string);
        this.fEnabledFilterIds.put(string, new Boolean(bl));
        this.storeViewDefaults();
        this.updateViewerFilters(true);
    }

    private String[] getEnabledFilterIds() {
        HashSet<String> hashSet = new HashSet<String>(this.fEnabledFilterIds.size());
        Iterator iterator = this.fEnabledFilterIds.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            boolean bl = (Boolean)entry.getValue();
            if (!bl) continue;
            hashSet.add(string);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private void setEnabledFilterIds(String[] stringArray) {
        Iterator iterator = this.fEnabledFilterIds.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.fEnabledFilterIds.put(string, Boolean.FALSE);
        }
        int n = 0;
        while (n < stringArray.length) {
            this.fEnabledFilterIds.put(stringArray[n], Boolean.TRUE);
            ++n;
        }
    }

    private void setUserDefinedPatterns(String[] stringArray) {
        this.fUserDefinedPatterns = stringArray;
        this.cleanUpPatternDuplicates();
    }

    private void setRecentlyChangedFilters(Stack stack) {
        Stack<String> stack2 = new Stack<String>();
        int n = Math.min(stack.size(), 3);
        int n2 = 0;
        while (n2 < n) {
            stack2.push(((FilterDescriptor)stack.pop()).getId());
            ++n2;
        }
        n = Math.min(this.fLRUFilterIdsStack.size(), 3 - stack2.size());
        n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Object e = this.fLRUFilterIdsStack.remove(n2);
            if (!stack2.contains(e)) {
                stack2.push((String)e);
            }
            ++n3;
        }
        this.fLRUFilterIdsStack = stack2;
    }

    private boolean areUserDefinedPatternsEnabled() {
        return this.fUserDefinedPatternsEnabled;
    }

    private void setUserDefinedPatternsEnabled(boolean bl) {
        this.fUserDefinedPatternsEnabled = bl;
    }

    private void fillToolBar(IToolBarManager iToolBarManager) {
    }

    public void fillViewMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("filters"));
        iMenuManager.add((IContributionItem)new GroupMarker(RECENT_FILTERS_GROUP_NAME));
        iMenuManager.add((IAction)new ShowFilterDialogAction());
        this.fMenuManager = iMenuManager;
        this.fMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                CustomFiltersActionGroup.this.removePreviousLRUFilterActions(iMenuManager);
                CustomFiltersActionGroup.this.addLRUFilterActions(iMenuManager);
            }
        };
        this.fMenuManager.addMenuListener(this.fMenuListener);
    }

    private void removePreviousLRUFilterActions(IMenuManager iMenuManager) {
        if (this.fFilterIdsUsedInLastViewMenu == null) {
            return;
        }
        int n = 0;
        while (n < this.fFilterIdsUsedInLastViewMenu.length) {
            iMenuManager.remove(this.fFilterIdsUsedInLastViewMenu[n]);
            ++n;
        }
    }

    private void addLRUFilterActions(IMenuManager iMenuManager) {
        if (this.fLRUFilterIdsStack.isEmpty()) {
            this.fFilterIdsUsedInLastViewMenu = null;
            return;
        }
        TreeSet treeSet = new TreeSet(this.fLRUFilterIdsStack);
        String[] stringArray = treeSet.toArray(new String[treeSet.size()]);
        this.fFilterIdsUsedInLastViewMenu = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string;
            this.fFilterIdsUsedInLastViewMenu[n] = string = stringArray[n];
            boolean bl = this.fEnabledFilterIds.containsKey(string) && (Boolean)this.fEnabledFilterIds.get(string) != false;
            FilterDescriptor filterDescriptor = (FilterDescriptor)this.fFilterDescriptorMap.get(string);
            if (filterDescriptor != null) {
                FilterActionMenuContributionItem filterActionMenuContributionItem = new FilterActionMenuContributionItem(this, string, filterDescriptor.getName(), bl, n + 1);
                iMenuManager.insertBefore(RECENT_FILTERS_GROUP_NAME, (IContributionItem)filterActionMenuContributionItem);
            }
            ++n;
        }
    }

    public void dispose() {
        if (this.fMenuManager != null) {
            this.fMenuManager.removeMenuListener(this.fMenuListener);
        }
        super.dispose();
    }

    private void initializeWithPluginContributions() {
        this.fUserDefinedPatterns = new String[0];
        this.fUserDefinedPatternsEnabled = false;
        FilterDescriptor[] filterDescriptorArray = FilterDescriptor.getFilterDescriptors(this.fTargetId);
        this.fFilterDescriptorMap = new HashMap(filterDescriptorArray.length);
        this.fEnabledFilterIds = new HashMap(filterDescriptorArray.length);
        int n = 0;
        while (n < filterDescriptorArray.length) {
            String string = filterDescriptorArray[n].getId();
            Boolean bl = new Boolean(filterDescriptorArray[n].isEnabled());
            this.fEnabledFilterIds.put(string, bl);
            this.fFilterDescriptorMap.put(string, filterDescriptorArray[n]);
            ++n;
        }
    }

    private void installFilters() {
        this.fInstalledBuiltInFilters = new HashMap(this.fEnabledFilterIds.size());
        this.fPatternFilter = new NamePatternFilter();
        this.fPatternFilter.setPatterns(this.getUserAndBuiltInPatterns());
        this.fViewer.addFilter((ViewerFilter)this.fPatternFilter);
        this.updateBuiltInFilters();
    }

    private void updateViewerFilters(boolean bl) {
        String[] stringArray = this.getUserAndBuiltInPatterns();
        this.fPatternFilter.setPatterns(stringArray);
        this.fViewer.getControl().setRedraw(false);
        this.updateBuiltInFilters();
        if (bl) {
            this.fViewer.refresh();
        }
        this.fViewer.getControl().setRedraw(true);
    }

    private void updateBuiltInFilters() {
        Object object;
        Set set = this.fInstalledBuiltInFilters.keySet();
        HashSet<String> hashSet = new HashSet<String>(this.fEnabledFilterIds.size());
        HashSet<String> hashSet2 = new HashSet<String>(this.fEnabledFilterIds.size());
        Iterator iterator = this.fEnabledFilterIds.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            String string = (String)object.getKey();
            boolean bl = (Boolean)object.getValue();
            if (bl && !set.contains(string)) {
                hashSet.add(string);
                continue;
            }
            if (bl || !set.contains(string)) continue;
            hashSet2.add(string);
        }
        object = FilterDescriptor.getFilterDescriptors(this.fTargetId);
        int n = 0;
        while (n < ((Object)object).length) {
            String string = ((FilterDescriptor)object[n]).getId();
            boolean bl = ((FilterDescriptor)object[n]).isCustomFilter();
            if (bl) {
                ViewerFilter viewerFilter;
                if (hashSet.contains(string) && (viewerFilter = ((FilterDescriptor)object[n]).createViewerFilter()) != null) {
                    this.fViewer.addFilter(viewerFilter);
                    this.fInstalledBuiltInFilters.put(string, viewerFilter);
                }
                if (hashSet2.contains(string)) {
                    this.fViewer.removeFilter((ViewerFilter)this.fInstalledBuiltInFilters.get(string));
                    this.fInstalledBuiltInFilters.remove(string);
                }
            }
            ++n;
        }
    }

    private String[] getUserAndBuiltInPatterns() {
        ArrayList<String> arrayList = new ArrayList<String>(this.fUserDefinedPatterns.length);
        if (this.areUserDefinedPatternsEnabled()) {
            arrayList.addAll(Arrays.asList(this.fUserDefinedPatterns));
        }
        FilterDescriptor[] filterDescriptorArray = FilterDescriptor.getFilterDescriptors(this.fTargetId);
        int n = 0;
        while (n < filterDescriptorArray.length) {
            String string = filterDescriptorArray[n].getId();
            boolean bl = filterDescriptorArray[n].isPatternFilter();
            Object v = this.fEnabledFilterIds.get(string);
            if (v != null && bl && ((Boolean)v).booleanValue()) {
                arrayList.add(filterDescriptorArray[n].getPattern());
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void initializeWithViewDefaults() {
        Object object;
        String string;
        IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        if (!iPreferenceStore.contains(this.getPreferenceKey("TAG_DUMMY_TO_TEST_EXISTENCE"))) {
            return;
        }
        this.fUserDefinedPatternsEnabled = iPreferenceStore.getBoolean(this.getPreferenceKey(TAG_USER_DEFINED_PATTERNS_ENABLED));
        this.setUserDefinedPatterns(CustomFiltersDialog.convertFromString(iPreferenceStore.getString(this.getPreferenceKey(TAG_USER_DEFINED_PATTERNS)), SEPARATOR));
        Iterator iterator = this.fEnabledFilterIds.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = new Boolean(iPreferenceStore.getBoolean(string));
            this.fEnabledFilterIds.put(string, object);
        }
        this.fLRUFilterIdsStack.clear();
        string = iPreferenceStore.getString(TAG_LRU_FILTERS);
        object = new StringTokenizer(string, SEPARATOR);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string2 = ((StringTokenizer)object).nextToken();
            if (!this.fFilterDescriptorMap.containsKey(string2) || this.fLRUFilterIdsStack.contains(string2)) continue;
            this.fLRUFilterIdsStack.push(string2);
        }
    }

    private void storeViewDefaults() {
        Object object;
        IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(this.getPreferenceKey("TAG_DUMMY_TO_TEST_EXISTENCE"), "storedViewPreferences");
        iPreferenceStore.setValue(this.getPreferenceKey(TAG_USER_DEFINED_PATTERNS_ENABLED), this.fUserDefinedPatternsEnabled);
        iPreferenceStore.setValue(this.getPreferenceKey(TAG_USER_DEFINED_PATTERNS), CustomFiltersDialog.convertToString(this.fUserDefinedPatterns, SEPARATOR));
        Iterator iterator = this.fEnabledFilterIds.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            String string = (String)object.getKey();
            boolean bl = (Boolean)object.getValue();
            iPreferenceStore.setValue(string, bl);
        }
        object = new StringBuffer(this.fLRUFilterIdsStack.size() * 20);
        iterator = this.fLRUFilterIdsStack.iterator();
        while (iterator.hasNext()) {
            ((StringBuffer)object).append((String)((Object)iterator.next()));
            ((StringBuffer)object).append(SEPARATOR);
        }
        iPreferenceStore.setValue(TAG_LRU_FILTERS, ((StringBuffer)object).toString());
    }

    private String getPreferenceKey(String string) {
        return "CustomFiltersActionGroup." + this.fTargetId + '.' + string;
    }

    public void saveState(IMemento iMemento) {
        IMemento iMemento2 = iMemento.createChild(TAG_CUSTOM_FILTERS);
        iMemento2.putString(TAG_USER_DEFINED_PATTERNS_ENABLED, new Boolean(this.fUserDefinedPatternsEnabled).toString());
        this.saveUserDefinedPatterns(iMemento2);
        this.saveXmlDefinedFilters(iMemento2);
        this.saveLRUFilters(iMemento2);
    }

    private void saveXmlDefinedFilters(IMemento iMemento) {
        if (this.fEnabledFilterIds != null && !this.fEnabledFilterIds.isEmpty()) {
            IMemento iMemento2 = iMemento.createChild(TAG_XML_DEFINED_FILTERS);
            Iterator iterator = this.fEnabledFilterIds.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Boolean bl = (Boolean)entry.getValue();
                IMemento iMemento3 = iMemento2.createChild(TAG_CHILD);
                iMemento3.putString(TAG_FILTER_ID, string);
                iMemento3.putString(TAG_IS_ENABLED, bl.toString());
            }
        }
    }

    private void saveLRUFilters(IMemento iMemento) {
        if (this.fLRUFilterIdsStack != null && !this.fLRUFilterIdsStack.isEmpty()) {
            IMemento iMemento2 = iMemento.createChild(TAG_LRU_FILTERS);
            Iterator iterator = this.fLRUFilterIdsStack.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                IMemento iMemento3 = iMemento2.createChild(TAG_CHILD);
                iMemento3.putString(TAG_FILTER_ID, string);
            }
        }
    }

    private void saveUserDefinedPatterns(IMemento iMemento) {
        if (this.fUserDefinedPatterns != null && this.fUserDefinedPatterns.length > 0) {
            IMemento iMemento2 = iMemento.createChild(TAG_USER_DEFINED_PATTERNS);
            int n = 0;
            while (n < this.fUserDefinedPatterns.length) {
                IMemento iMemento3 = iMemento2.createChild(TAG_CHILD);
                iMemento3.putString(TAG_PATTERN, this.fUserDefinedPatterns[n]);
                ++n;
            }
        }
    }

    public void restoreState(IMemento iMemento) {
        if (iMemento == null) {
            return;
        }
        IMemento iMemento2 = iMemento.getChild(TAG_CUSTOM_FILTERS);
        if (iMemento2 == null) {
            return;
        }
        String string = iMemento2.getString(TAG_USER_DEFINED_PATTERNS_ENABLED);
        if (string == null) {
            return;
        }
        this.fUserDefinedPatternsEnabled = Boolean.valueOf(string);
        this.restoreUserDefinedPatterns(iMemento2);
        this.restoreXmlDefinedFilters(iMemento2);
        this.restoreLRUFilters(iMemento2);
        this.updateViewerFilters(false);
    }

    private void restoreUserDefinedPatterns(IMemento iMemento) {
        IMemento iMemento2 = iMemento.getChild(TAG_USER_DEFINED_PATTERNS);
        if (iMemento2 != null) {
            IMemento[] iMementoArray = iMemento2.getChildren(TAG_CHILD);
            String[] stringArray = new String[iMementoArray.length];
            int n = 0;
            while (n < iMementoArray.length) {
                stringArray[n] = iMementoArray[n].getString(TAG_PATTERN);
                ++n;
            }
            this.setUserDefinedPatterns(stringArray);
        } else {
            this.setUserDefinedPatterns(new String[0]);
        }
    }

    private void restoreXmlDefinedFilters(IMemento iMemento) {
        IMemento iMemento2 = iMemento.getChild(TAG_XML_DEFINED_FILTERS);
        if (iMemento2 != null) {
            IMemento[] iMementoArray = iMemento2.getChildren(TAG_CHILD);
            int n = 0;
            while (n < iMementoArray.length) {
                String string = iMementoArray[n].getString(TAG_FILTER_ID);
                Boolean bl = new Boolean(iMementoArray[n].getString(TAG_IS_ENABLED));
                this.fEnabledFilterIds.put(string, bl);
                ++n;
            }
        }
    }

    private void restoreLRUFilters(IMemento iMemento) {
        IMemento iMemento2 = iMemento.getChild(TAG_LRU_FILTERS);
        this.fLRUFilterIdsStack.clear();
        if (iMemento2 != null) {
            IMemento[] iMementoArray = iMemento2.getChildren(TAG_CHILD);
            int n = 0;
            while (n < iMementoArray.length) {
                String string = iMementoArray[n].getString(TAG_FILTER_ID);
                if (this.fFilterDescriptorMap.containsKey(string) && !this.fLRUFilterIdsStack.contains(string)) {
                    this.fLRUFilterIdsStack.push(string);
                }
                ++n;
            }
        }
    }

    private void cleanUpPatternDuplicates() {
        if (!this.areUserDefinedPatternsEnabled()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.fUserDefinedPatterns));
        FilterDescriptor[] filterDescriptorArray = FilterDescriptor.getFilterDescriptors(this.fTargetId);
        int n = 0;
        while (n < filterDescriptorArray.length) {
            String string;
            if (filterDescriptorArray[n].isPatternFilter() && arrayList.contains(string = filterDescriptorArray[n].getPattern())) {
                this.fEnabledFilterIds.put(filterDescriptorArray[n].getId(), Boolean.TRUE);
                boolean bl = true;
                while (bl) {
                    bl = arrayList.remove(string);
                }
            }
            ++n;
        }
        this.fUserDefinedPatterns = arrayList.toArray(new String[arrayList.size()]);
        this.setUserDefinedPatternsEnabled(this.fUserDefinedPatternsEnabled && this.fUserDefinedPatterns.length > 0);
    }

    private void openDialog() {
        CustomFiltersDialog customFiltersDialog = new CustomFiltersDialog(this.fViewer.getControl().getShell(), this.fTargetId, this.areUserDefinedPatternsEnabled(), this.fUserDefinedPatterns, this.getEnabledFilterIds());
        if (customFiltersDialog.open() == 0) {
            this.setEnabledFilterIds(customFiltersDialog.getEnabledFilterIds());
            this.setUserDefinedPatternsEnabled(customFiltersDialog.areUserDefinedPatternsEnabled());
            this.setUserDefinedPatterns(customFiltersDialog.getUserDefinedPatterns());
            this.setRecentlyChangedFilters(customFiltersDialog.getFilterDescriptorChangeHistory());
            this.storeViewDefaults();
            this.updateViewerFilters(true);
        }
    }

    static /* synthetic */ void access$1(CustomFiltersActionGroup customFiltersActionGroup, String string, boolean bl) {
        customFiltersActionGroup.setFilter(string, bl);
    }

    class ShowFilterDialogAction
    extends Action {
        ShowFilterDialogAction() {
            this.setText(FilterMessages.getString("OpenCustomFiltersDialogAction.text"));
        }

        public void run() {
            CustomFiltersActionGroup.this.openDialog();
        }
    }

    class FilterActionMenuContributionItem
    extends ContributionItem {
        private int fItemNumber;
        private boolean fState;
        private String fFilterId;
        private String fFilterName;
        private CustomFiltersActionGroup fActionGroup;

        public FilterActionMenuContributionItem(CustomFiltersActionGroup customFiltersActionGroup2, String string, String string2, boolean bl, int n) {
            super(string);
            Assert.isNotNull((Object)((Object)customFiltersActionGroup2));
            Assert.isNotNull((Object)string);
            Assert.isNotNull((Object)string2);
            this.fActionGroup = customFiltersActionGroup2;
            this.fFilterId = string;
            this.fFilterName = string2;
            this.fState = bl;
            this.fItemNumber = n;
        }

        public void fill(Menu menu, int n) {
            MenuItem menuItem = new MenuItem(menu, 32, n);
            menuItem.setText("&" + this.fItemNumber + " " + this.fFilterName);
            menuItem.setSelection(this.fState);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ FilterActionMenuContributionItem this$1;
                {
                    this.this$1 = filterActionMenuContributionItem;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    FilterActionMenuContributionItem.access$1(this.this$1, !FilterActionMenuContributionItem.access$0(this.this$1));
                    CustomFiltersActionGroup.access$1(FilterActionMenuContributionItem.access$2(this.this$1), FilterActionMenuContributionItem.access$3(this.this$1), FilterActionMenuContributionItem.access$0(this.this$1));
                }
            });
        }

        public boolean isDynamic() {
            return true;
        }

        static /* synthetic */ boolean access$0(FilterActionMenuContributionItem filterActionMenuContributionItem) {
            return filterActionMenuContributionItem.fState;
        }

        static /* synthetic */ void access$1(FilterActionMenuContributionItem filterActionMenuContributionItem, boolean bl) {
            filterActionMenuContributionItem.fState = bl;
        }

        static /* synthetic */ CustomFiltersActionGroup access$2(FilterActionMenuContributionItem filterActionMenuContributionItem) {
            return filterActionMenuContributionItem.fActionGroup;
        }

        static /* synthetic */ String access$3(FilterActionMenuContributionItem filterActionMenuContributionItem) {
            return filterActionMenuContributionItem.fFilterId;
        }
    }
}

