/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.viewsupport.MemberFilter;
import org.eclipse.cdt.internal.ui.viewsupport.MemberFilterAction;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionGroup;

public class MemberFilterActionGroup
extends ActionGroup {
    public static final int FILTER_NONPUBLIC = 1;
    public static final int FILTER_STATIC = 2;
    public static final int FILTER_FIELDS = 4;
    private static final String TAG_HIDEFIELDS = "hidefields";
    private static final String TAG_HIDESTATIC = "hidestatic";
    private static final String TAG_HIDENONPUBLIC = "hidenonpublic";
    private MemberFilterAction[] fFilterActions;
    private MemberFilter fFilter;
    private StructuredViewer fViewer;
    private String fViewerId;
    private boolean fInViewMenu;

    public MemberFilterActionGroup(StructuredViewer structuredViewer, String string) {
        this(structuredViewer, string, false);
    }

    public MemberFilterActionGroup(StructuredViewer structuredViewer, String string, boolean bl) {
        this.fViewer = structuredViewer;
        this.fViewerId = string;
        this.fInViewMenu = bl;
        IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        boolean bl2 = iPreferenceStore.getBoolean(this.getPreferenceKey(4));
        boolean bl3 = iPreferenceStore.getBoolean(this.getPreferenceKey(2));
        boolean bl4 = iPreferenceStore.getBoolean(this.getPreferenceKey(1));
        this.fFilter = new MemberFilter();
        if (bl2) {
            this.fFilter.addFilter(4);
        }
        if (bl3) {
            this.fFilter.addFilter(2);
        }
        if (bl4) {
            this.fFilter.addFilter(1);
        }
        String string2 = ActionMessages.getString("MemberFilterActionGroup.hide_fields.label");
        String string3 = "org.eclipse.cdt.ui.filter_fields_action";
        MemberFilterAction memberFilterAction = new MemberFilterAction(this, string2, 4, string3, bl2);
        memberFilterAction.setDescription(ActionMessages.getString("MemberFilterActionGroup.hide_fields.description"));
        memberFilterAction.setToolTipText(ActionMessages.getString("MemberFilterActionGroup.hide_fields.tooltip"));
        CPluginImages.setImageDescriptors((IAction)memberFilterAction, "lcl16/", "org.eclipse.cdt.ui.fields_co.gif");
        string2 = ActionMessages.getString("MemberFilterActionGroup.hide_static.label");
        string3 = "org.eclipse.cdt.ui.filter_static_action";
        MemberFilterAction memberFilterAction2 = new MemberFilterAction(this, string2, 2, string3, bl3);
        memberFilterAction2.setDescription(ActionMessages.getString("MemberFilterActionGroup.hide_static.description"));
        memberFilterAction2.setToolTipText(ActionMessages.getString("MemberFilterActionGroup.hide_static.tooltip"));
        CPluginImages.setImageDescriptors((IAction)memberFilterAction2, "lcl16/", "org.eclipse.cdt.ui.static_co.gif");
        string2 = ActionMessages.getString("MemberFilterActionGroup.hide_nonpublic.label");
        string3 = "org.eclipse.cdt.ui.filter_public_action";
        MemberFilterAction memberFilterAction3 = new MemberFilterAction(this, string2, 1, string3, bl4);
        memberFilterAction3.setDescription(ActionMessages.getString("MemberFilterActionGroup.hide_nonpublic.description"));
        memberFilterAction3.setToolTipText(ActionMessages.getString("MemberFilterActionGroup.hide_nonpublic.tooltip"));
        CPluginImages.setImageDescriptors((IAction)memberFilterAction3, "lcl16/", "org.eclipse.cdt.ui.public_co.gif");
        this.fFilterActions = new MemberFilterAction[]{memberFilterAction, memberFilterAction2, memberFilterAction3};
        this.fViewer.addFilter((ViewerFilter)this.fFilter);
    }

    private String getPreferenceKey(int n) {
        return "MemberFilterActionGroup." + this.fViewerId + '.' + String.valueOf(n);
    }

    public void setMemberFilter(int n, boolean bl) {
        this.setMemberFilters(new int[]{n}, new boolean[]{bl}, true);
    }

    private void setMemberFilters(int[] nArray, boolean[] blArray, boolean bl) {
        if (nArray.length == 0) {
            return;
        }
        Assert.isTrue((nArray.length == blArray.length ? 1 : 0) != 0);
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            boolean bl2 = blArray[n];
            if (bl2) {
                this.fFilter.addFilter(n2);
            } else {
                this.fFilter.removeFilter(n2);
            }
            IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
            int n3 = 0;
            while (n3 < this.fFilterActions.length) {
                int n4 = this.fFilterActions[n3].getFilterProperty();
                if (n4 == n2) {
                    this.fFilterActions[n3].setChecked(bl2);
                }
                iPreferenceStore.setValue(this.getPreferenceKey(n4), this.hasMemberFilter(n4));
                ++n3;
            }
            ++n;
        }
        if (bl) {
            this.fViewer.getControl().setRedraw(false);
            BusyIndicator.showWhile((Display)this.fViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    MemberFilterActionGroup.this.fViewer.refresh();
                }
            });
            this.fViewer.getControl().setRedraw(true);
        }
    }

    public boolean hasMemberFilter(int n) {
        return this.fFilter.hasFilter(n);
    }

    public void saveState(IMemento iMemento) {
        iMemento.putString(TAG_HIDEFIELDS, String.valueOf(this.hasMemberFilter(4)));
        iMemento.putString(TAG_HIDESTATIC, String.valueOf(this.hasMemberFilter(2)));
        iMemento.putString(TAG_HIDENONPUBLIC, String.valueOf(this.hasMemberFilter(1)));
    }

    public void restoreState(IMemento iMemento) {
        this.setMemberFilters(new int[]{4, 2, 1}, new boolean[]{Boolean.valueOf(iMemento.getString(TAG_HIDEFIELDS)), Boolean.valueOf(iMemento.getString(TAG_HIDESTATIC)), Boolean.valueOf(iMemento.getString(TAG_HIDENONPUBLIC))}, false);
    }

    public void fillActionBars(IActionBars iActionBars) {
        this.contributeToToolBar(iActionBars.getToolBarManager());
    }

    public void contributeToToolBar(IToolBarManager iToolBarManager) {
        if (this.fInViewMenu) {
            return;
        }
        iToolBarManager.add((IAction)this.fFilterActions[0]);
        iToolBarManager.add((IAction)this.fFilterActions[1]);
        iToolBarManager.add((IAction)this.fFilterActions[2]);
    }

    public void contributeToViewMenu(IMenuManager iMenuManager) {
        if (!this.fInViewMenu) {
            return;
        }
        if (iMenuManager.find("filters") != null) {
            iMenuManager.prependToGroup("filters", (IAction)this.fFilterActions[0]);
            iMenuManager.prependToGroup("filters", (IAction)this.fFilterActions[1]);
            iMenuManager.prependToGroup("filters", (IAction)this.fFilterActions[2]);
        } else {
            iMenuManager.add((IAction)this.fFilterActions[0]);
            iMenuManager.add((IAction)this.fFilterActions[1]);
            iMenuManager.add((IAction)this.fFilterActions[2]);
        }
    }

    public void dispose() {
        this.fFilterActions = null;
        this.fFilter = null;
        this.fViewer = null;
        super.dispose();
    }
}

