/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.actions.RedoRefactoringAction;
import org.eclipse.cdt.internal.ui.refactoring.actions.RenameRefactoringAction;
import org.eclipse.cdt.internal.ui.refactoring.actions.UndoRefactoringAction;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class RefactoringActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.cdt.ui.refactoring.menu";
    public static final String GROUP_REORG = "reorgGroup";
    public static final String GROUP_TYPE = "typeGroup";
    public static final String GROUP_CODING = "codingGroup";
    public static final String REFACTOR_RENAME = "org.eclipse.cdt.ui.actions.refactor.RenameAction";
    public static final String REFACTOR_UNDO = "org.eclipse.cdt.ui.actions.refactor.UndoAction";
    public static final String REFACTOR_REDO = "org.eclipse.cdt.ui.actions.refactor.RedoAction";
    private IWorkbenchSite fSite;
    private CEditor fEditor;
    private String fGroupName = "group.reorganize";
    private RenameRefactoringAction fRenameAction;
    private RedoRefactoringAction fRedoAction;
    private UndoRefactoringAction fUndoAction;
    private List fEditorActions;
    private Action fNoActionAvailable = new NoActionAvailable();

    public RefactoringActionGroup(IViewPart iViewPart, String string) {
        this((IWorkbenchSite)iViewPart.getSite(), string);
    }

    public RefactoringActionGroup(Page page, String string) {
        this((IWorkbenchSite)page.getSite(), string);
    }

    public RefactoringActionGroup(CEditor cEditor, String string) {
        this.fSite = cEditor.getEditorSite();
        this.fEditor = cEditor;
        if (string != null && string.length() > 0) {
            this.fGroupName = string;
        }
        ISelectionProvider iSelectionProvider = cEditor.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        this.fEditorActions = new ArrayList(3);
        this.fRenameAction = new RenameRefactoringAction(cEditor);
        this.fRenameAction.update(iSelection);
        cEditor.setAction("RenameElement", (IAction)this.fRenameAction);
        this.fEditorActions.add(this.fRenameAction);
        this.fUndoAction = new UndoRefactoringAction(cEditor);
        this.fUndoAction.update(iSelection);
        cEditor.setAction("UndoAction", (IAction)this.fUndoAction);
        this.fEditorActions.add(this.fUndoAction);
        this.fRedoAction = new RedoRefactoringAction(cEditor);
        this.fRedoAction.update(iSelection);
        cEditor.setAction("RedoAction", (IAction)this.fRedoAction);
        this.fEditorActions.add(this.fRedoAction);
    }

    public RefactoringActionGroup(IWorkbenchSite iWorkbenchSite, String string) {
        this.fSite = iWorkbenchSite;
        if (string != null && string.length() > 0) {
            this.fGroupName = string;
        }
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        this.fRenameAction = new RenameRefactoringAction(iWorkbenchSite);
        RefactoringActionGroup.initAction(this.fRenameAction, iSelectionProvider, iSelection);
        this.fUndoAction = new UndoRefactoringAction(iWorkbenchSite);
        RefactoringActionGroup.initAction(this.fUndoAction, iSelectionProvider, iSelection);
        this.fRedoAction = new RedoRefactoringAction(iWorkbenchSite);
        RefactoringActionGroup.initAction(this.fRedoAction, iSelectionProvider, iSelection);
    }

    private static void initAction(SelectionDispatchAction selectionDispatchAction, ISelectionProvider iSelectionProvider, ISelection iSelection) {
        selectionDispatchAction.update(iSelection);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)selectionDispatchAction);
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        iActionBars.setGlobalActionHandler(REFACTOR_RENAME, (IAction)this.fRenameAction);
        iActionBars.setGlobalActionHandler(REFACTOR_UNDO, (IAction)this.fUndoAction);
        iActionBars.setGlobalActionHandler(REFACTOR_REDO, (IAction)this.fRedoAction);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        this.addRefactorSubmenu(iMenuManager);
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        if (this.fRenameAction != null) {
            this.disposeAction(this.fRenameAction, iSelectionProvider);
            this.fRenameAction = null;
        }
        if (this.fUndoAction != null) {
            this.disposeAction(this.fUndoAction, iSelectionProvider);
            this.fUndoAction.dispose();
            this.fUndoAction = null;
        }
        if (this.fRedoAction != null) {
            this.disposeAction(this.fRedoAction, iSelectionProvider);
            this.fRedoAction.dispose();
            this.fRedoAction = null;
        }
        if (this.fEditorActions != null) {
            this.fEditorActions.clear();
            this.fEditorActions = null;
        }
        super.dispose();
    }

    private void disposeAction(ISelectionChangedListener iSelectionChangedListener, ISelectionProvider iSelectionProvider) {
        iSelectionProvider.removeSelectionChangedListener(iSelectionChangedListener);
    }

    private void addRefactorSubmenu(IMenuManager iMenuManager) {
        MenuManager menuManager = new MenuManager(ActionMessages.getString("RefactorMenu.label"), MENU_ID);
        if (this.fEditor != null) {
            ITextSelection iTextSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
            Iterator iterator = this.fEditorActions.iterator();
            while (iterator.hasNext()) {
                SelectionDispatchAction selectionDispatchAction = (SelectionDispatchAction)((Object)iterator.next());
                selectionDispatchAction.update((ISelection)iTextSelection);
            }
            menuManager.removeAll();
            if (this.fillRefactorMenu((IMenuManager)menuManager) == 0) {
                menuManager.add((IAction)this.fNoActionAvailable);
            }
            iMenuManager.appendToGroup(this.fGroupName, (IContributionItem)menuManager);
        } else if (this.fillRefactorMenu((IMenuManager)menuManager) > 0) {
            iMenuManager.appendToGroup(this.fGroupName, (IContributionItem)menuManager);
        }
    }

    private int fillRefactorMenu(IMenuManager iMenuManager) {
        int n = 0;
        iMenuManager.add((IContributionItem)new Separator(GROUP_REORG));
        n += this.addAction(iMenuManager, (IAction)this.fRenameAction);
        n += this.addAction(iMenuManager, (IAction)this.fUndoAction);
        return n += this.addAction(iMenuManager, (IAction)this.fRedoAction);
    }

    private int addAction(IMenuManager iMenuManager, IAction iAction) {
        if (iAction != null && iAction.isEnabled()) {
            iMenuManager.add(iAction);
            return 1;
        }
        return 0;
    }

    private ICElement getEditorInput() {
        return CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
    }

    private IDocument getDocument() {
        return CUIPlugin.getDefault().getDocumentProvider().getDocument(this.fEditor.getEditorInput());
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(false);
            this.setText(RefactoringMessages.getString("RefactorActionGroup.no_refactoring_available"));
        }
    }
}

