/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.cview.SelectionConverter;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.texteditor.ITextEditor;

public class ShowInCViewAction
extends SelectionProviderAction {
    private IWorkbenchPage page;
    private ITextEditor fEditor;

    public ShowInCViewAction(IWorkbenchSite iWorkbenchSite) {
        this(iWorkbenchSite.getPage(), iWorkbenchSite.getSelectionProvider());
    }

    public ShowInCViewAction(ITextEditor iTextEditor) {
        this(iTextEditor.getEditorSite().getWorkbenchWindow().getActivePage(), iTextEditor.getSelectionProvider());
        this.fEditor = iTextEditor;
    }

    public ShowInCViewAction(IWorkbenchPage iWorkbenchPage, ISelectionProvider iSelectionProvider) {
        super(iSelectionProvider, CEditorMessages.getString("ShowInCView.label"));
        this.setToolTipText(CEditorMessages.getString("ShowInCView.tooltip"));
        this.setDescription(CEditorMessages.getString("ShowInCView.description"));
        this.page = iWorkbenchPage;
        this.setDescription(CEditorMessages.getString("ShowInCView.toolTip"));
    }

    public void run() {
        if (this.page == null) {
            return;
        }
        ISelection iSelection = this.getSelection();
        if (iSelection instanceof ITextSelection) {
            this.run(this.fEditor);
        } else if (iSelection instanceof IStructuredSelection) {
            this.run((IStructuredSelection)iSelection);
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        try {
            IViewPart iViewPart = this.page.showView("org.eclipse.cdt.ui.CView");
            if (iViewPart instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)iViewPart).selectReveal((ISelection)iStructuredSelection);
            }
        }
        catch (PartInitException partInitException) {}
    }

    public void run(ITextEditor iTextEditor) {
        if (iTextEditor != null) {
            try {
                ICElement iCElement = SelectionConverter.getElementAtOffset(iTextEditor);
                if (iCElement != null) {
                    this.run((IStructuredSelection)new StructuredSelection((Object)iCElement));
                }
            }
            catch (CModelException cModelException) {}
        }
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(!this.getSelection().isEmpty());
    }
}

