/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.browser.typeinfo;

import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TypeInfoLabelProvider
extends LabelProvider {
    public static final int SHOW_TYPE_ONLY = 1;
    public static final int SHOW_ENCLOSING_TYPE_ONLY = 2;
    public static final int SHOW_FULLY_QUALIFIED = 4;
    public static final int SHOW_PATH = 8;
    private static final Image HEADER_ICON = CPluginImages.get("org.eclipse.cdt.ui.h_file_obj.gif");
    private static final Image SOURCE_ICON = CPluginImages.get("org.eclipse.cdt.ui.c_file_obj.gif");
    private static final Image NAMESPACE_ICON = CPluginImages.get("org.eclipse.cdt.ui.namespace_obj.gif");
    private static final Image TEMPLATE_ICON = CPluginImages.get("org.eclipse.cdt.ui.template_obj.gif");
    private static final Image CLASS_ICON = CPluginImages.get("org.eclipse.cdt.ui.class_obj.gif");
    private static final Image STRUCT_ICON = CPluginImages.get("org.eclipse.cdt.ui.struct_obj.gif");
    private static final Image TYPEDEF_ICON = CPluginImages.get("org.eclipse.cdt.ui.typedef_obj.gif");
    private static final Image UNION_ICON = CPluginImages.get("org.eclipse.cdt.ui.union_obj.gif");
    private static final Image ENUM_ICON = CPluginImages.get("org.eclipse.cdt.ui.enum_obj.gif");
    private static final Image UNKNOWN_TYPE_ICON = CPluginImages.get("org.eclipse.cdt.ui.unknown_type_obj.gif");
    private int fFlags;

    public TypeInfoLabelProvider(int n) {
        this.fFlags = n;
    }

    private boolean isSet(int n) {
        return (this.fFlags & n) != 0;
    }

    public String getText(Object object) {
        String string;
        if (!(object instanceof ITypeInfo)) {
            return super.getText(object);
        }
        ITypeInfo iTypeInfo = (ITypeInfo)object;
        IQualifiedTypeName iQualifiedTypeName = iTypeInfo.getQualifiedTypeName();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isSet(1)) {
            string = iTypeInfo.getName();
            if (string != null && string.length() > 0) {
                stringBuffer.append(string);
            }
        } else if (this.isSet(2)) {
            string = iQualifiedTypeName.getEnclosingTypeName();
            if (string != null) {
                stringBuffer.append(string.getFullyQualifiedName());
            } else {
                stringBuffer.append(TypeInfoMessages.getString("TypeInfoLabelProvider.globalScope"));
            }
        } else if (this.isSet(4)) {
            stringBuffer.append(iQualifiedTypeName.getFullyQualifiedName());
        }
        if (this.isSet(8)) {
            string = null;
            ITypeReference iTypeReference = iTypeInfo.getResolvedReference();
            if (iTypeReference != null) {
                string = iTypeReference.getPath();
            } else {
                IProject iProject = iTypeInfo.getEnclosingProject();
                if (iProject != null) {
                    string = iProject.getFullPath();
                }
            }
            if (string != null) {
                stringBuffer.append(TypeInfoMessages.getString("TypeInfoLabelProvider.dash"));
                stringBuffer.append(string.toString());
            }
        }
        return stringBuffer.toString();
    }

    public Image getImage(Object object) {
        if (!(object instanceof ITypeInfo)) {
            return super.getImage(object);
        }
        ITypeInfo iTypeInfo = (ITypeInfo)object;
        if (this.isSet(2)) {
            ITypeInfo iTypeInfo2 = iTypeInfo.getEnclosingType();
            if (iTypeInfo2 != null) {
                return TypeInfoLabelProvider.getTypeIcon(iTypeInfo2.getCElementType());
            }
            IPath iPath = null;
            ITypeReference iTypeReference = iTypeInfo.getResolvedReference();
            if (iTypeReference != null) {
                iPath = iTypeReference.getPath();
                if (CoreModel.isValidHeaderUnitName((IProject)iTypeInfo.getEnclosingProject(), (String)iPath.lastSegment())) {
                    return HEADER_ICON;
                }
            }
            return SOURCE_ICON;
        }
        return TypeInfoLabelProvider.getTypeIcon(iTypeInfo.getCElementType());
    }

    public static Image getTypeIcon(int n) {
        switch (n) {
            case 61: {
                return NAMESPACE_ICON;
            }
            case 73: {
                return TEMPLATE_ICON;
            }
            case 64: {
                return CLASS_ICON;
            }
            case 65: {
                return STRUCT_ICON;
            }
            case 66: {
                return UNION_ICON;
            }
            case 63: {
                return ENUM_ICON;
            }
            case 78: {
                return TYPEDEF_ICON;
            }
        }
        return UNKNOWN_TYPE_ICON;
    }
}

