/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.browser.typeinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.internal.ui.util.StringMatcher;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoLabelProvider;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class TypeSelectionDialog
extends TwoPaneElementSelector {
    private static final String DIALOG_SETTINGS;
    private static final String SETTINGS_X_POS = "x";
    private static final String SETTINGS_Y_POS = "y";
    private static final String SETTINGS_WIDTH = "width";
    private static final String SETTINGS_HEIGHT = "height";
    private static final String SETTINGS_SHOW_NAMESPACES = "show_namespaces";
    private static final String SETTINGS_SHOW_CLASSES = "show_classes";
    private static final String SETTINGS_SHOW_STRUCTS = "show_structs";
    private static final String SETTINGS_SHOW_TYPEDEFS = "show_typedefs";
    private static final String SETTINGS_SHOW_ENUMS = "show_enums";
    private static final String SETTINGS_SHOW_UNIONS = "show_unions";
    private static final String SETTINGS_SHOW_LOWLEVEL = "show_lowlevel";
    private static final TypeInfoLabelProvider fElementRenderer;
    private static final TypeInfoLabelProvider fQualifierRenderer;
    private static final TypeFilterMatcher fFilterMatcher;
    private static final StringComparator fStringComparator;
    private static final int[] fAllTypes;
    private Set fKnownTypes = new HashSet(fAllTypes.length);
    private Text fTextWidget;
    private boolean fSelectFilterText = false;
    private FilteredList fNewFilteredList;
    private String fDialogSection;
    private Point fLocation;
    private Point fSize;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.ui.browser.typeinfo.TypeSelectionDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DIALOG_SETTINGS = clazz.getName();
        fElementRenderer = new TypeInfoLabelProvider(1);
        fQualifierRenderer = new TypeInfoLabelProvider(10);
        fFilterMatcher = new TypeFilterMatcher();
        fStringComparator = new StringComparator();
        fAllTypes = new int[]{61, 64, 65, 78, 63, 66};
    }

    public TypeSelectionDialog(Shell shell) {
        super(shell, (ILabelProvider)fElementRenderer, (ILabelProvider)fQualifierRenderer);
        this.setMatchEmptyString(false);
        this.setUpperListLabel(TypeInfoMessages.getString("TypeSelectionDialog.upperLabel"));
        this.setLowerListLabel(TypeInfoMessages.getString("TypeSelectionDialog.lowerLabel"));
        this.setVisibleTypes(fAllTypes);
        this.setDialogSettings(DIALOG_SETTINGS);
    }

    public void setFilter(String string, boolean bl) {
        super.setFilter(string);
        this.fSelectFilterText = bl;
    }

    public void setVisibleTypes(int[] nArray) {
        this.fKnownTypes.clear();
        int n = 0;
        while (n < nArray.length) {
            this.fKnownTypes.add(new Integer(nArray[n]));
            ++n;
        }
    }

    public void setDialogSettings(String string) {
        this.fDialogSection = String.valueOf(string) + "Settings";
    }

    protected Text createFilterText(Composite composite) {
        this.fTextWidget = super.createFilterText(composite);
        this.createTypeFilterArea(composite);
        return this.fTextWidget;
    }

    protected FilteredList createFilteredList(Composite composite) {
        this.fNewFilteredList = super.createFilteredList(composite);
        this.fNewFilteredList.setFilterMatcher((FilteredList.FilterMatcher)fFilterMatcher);
        this.fNewFilteredList.setComparator((Comparator)fStringComparator);
        return this.fNewFilteredList;
    }

    public void create() {
        super.create();
        if (!this.fSelectFilterText) {
            this.fTextWidget.setSelection(0, 0);
        }
    }

    public boolean close() {
        this.writeSettings(this.getDialogSettings());
        return super.close();
    }

    protected Control createContents(Composite composite) {
        this.readSettings(this.getDialogSettings());
        return super.createContents(composite);
    }

    private void createTypeCheckbox(Composite composite, Integer n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 61: {
                string = TypeInfoMessages.getString("TypeSelectionDialog.filterNamespaces");
                break;
            }
            case 64: {
                string = TypeInfoMessages.getString("TypeSelectionDialog.filterClasses");
                break;
            }
            case 65: {
                string = TypeInfoMessages.getString("TypeSelectionDialog.filterStructs");
                break;
            }
            case 78: {
                string = TypeInfoMessages.getString("TypeSelectionDialog.filterTypedefs");
                break;
            }
            case 63: {
                string = TypeInfoMessages.getString("TypeSelectionDialog.filterEnums");
                break;
            }
            case 66: {
                string = TypeInfoMessages.getString("TypeSelectionDialog.filterUnions");
                break;
            }
            default: {
                return;
            }
        }
        Image image = TypeInfoLabelProvider.getTypeIcon(n2);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        final Integer n3 = n;
        Button button = new Button(composite2, 32);
        button.setFont(composite2.getFont());
        button.setImage(image);
        button.setSelection(fFilterMatcher.getVisibleTypes().contains(n3));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.widget instanceof Button) {
                    Button button = (Button)selectionEvent.widget;
                    if (button.getSelection()) {
                        fFilterMatcher.getVisibleTypes().add(n3);
                    } else {
                        fFilterMatcher.getVisibleTypes().remove(n3);
                    }
                    TypeSelectionDialog.this.updateElements();
                }
            }
        });
        Label label = new Label(composite2, 16384);
        label.setFont(composite2.getFont());
        label.setText(string);
    }

    private void createTypeFilterArea(Composite composite) {
        Integer n;
        this.createLabel(composite, TypeInfoMessages.getString("TypeSelectionDialog.filterLabel"));
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(3, true);
        gridLayout.verticalSpacing = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        int n2 = 0;
        while (n2 < fAllTypes.length) {
            n = new Integer(fAllTypes[n2]);
            if (this.fKnownTypes.contains(n)) {
                this.createTypeCheckbox(composite2, n);
            }
            ++n2;
        }
        Composite composite3 = new Composite(composite, 0);
        n = new GridLayout(1, true);
        ((GridLayout)n).verticalSpacing = 2;
        ((GridLayout)n).marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)n);
        Composite composite4 = new Composite(composite3, 0);
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        composite4.setLayout((Layout)gridLayout2);
        String string = TypeInfoMessages.getString("TypeSelectionDialog.filterLowLevelTypes");
        Button button = new Button(composite4, 32);
        button.setFont(composite4.getFont());
        button.setText(string);
        button.setSelection(fFilterMatcher.getShowLowLevelTypes());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.widget instanceof Button) {
                    Button button = (Button)selectionEvent.widget;
                    fFilterMatcher.setShowLowLevelTypes(button.getSelection());
                    TypeSelectionDialog.this.updateElements();
                }
            }
        });
    }

    private void updateElements() {
        this.fNewFilteredList.setFilter(this.fTextWidget.getText());
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = CUIPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(this.fDialogSection);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(this.fDialogSection);
            this.writeDefaultSettings(iDialogSettings2);
        }
        return iDialogSettings2;
    }

    protected void writeSettings(IDialogSettings iDialogSettings) {
        Point point = this.getShell().getLocation();
        iDialogSettings.put(SETTINGS_X_POS, point.x);
        iDialogSettings.put(SETTINGS_Y_POS, point.y);
        Point point2 = this.getShell().getSize();
        iDialogSettings.put(SETTINGS_WIDTH, point2.x);
        iDialogSettings.put(SETTINGS_HEIGHT, point2.y);
        iDialogSettings.put(SETTINGS_SHOW_NAMESPACES, fFilterMatcher.getVisibleTypes().contains(new Integer(61)));
        iDialogSettings.put(SETTINGS_SHOW_CLASSES, fFilterMatcher.getVisibleTypes().contains(new Integer(64)));
        iDialogSettings.put(SETTINGS_SHOW_STRUCTS, fFilterMatcher.getVisibleTypes().contains(new Integer(65)));
        iDialogSettings.put(SETTINGS_SHOW_TYPEDEFS, fFilterMatcher.getVisibleTypes().contains(new Integer(78)));
        iDialogSettings.put(SETTINGS_SHOW_ENUMS, fFilterMatcher.getVisibleTypes().contains(new Integer(63)));
        iDialogSettings.put(SETTINGS_SHOW_UNIONS, fFilterMatcher.getVisibleTypes().contains(new Integer(66)));
        iDialogSettings.put(SETTINGS_SHOW_LOWLEVEL, fFilterMatcher.getShowLowLevelTypes());
    }

    protected void writeDefaultSettings(IDialogSettings iDialogSettings) {
        iDialogSettings.put(SETTINGS_SHOW_NAMESPACES, true);
        iDialogSettings.put(SETTINGS_SHOW_CLASSES, true);
        iDialogSettings.put(SETTINGS_SHOW_STRUCTS, true);
        iDialogSettings.put(SETTINGS_SHOW_TYPEDEFS, true);
        iDialogSettings.put(SETTINGS_SHOW_ENUMS, true);
        iDialogSettings.put(SETTINGS_SHOW_UNIONS, true);
        iDialogSettings.put(SETTINGS_SHOW_LOWLEVEL, false);
    }

    protected void readSettings(IDialogSettings iDialogSettings) {
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        Integer n5;
        Integer n6;
        try {
            int n7 = iDialogSettings.getInt(SETTINGS_X_POS);
            int n8 = iDialogSettings.getInt(SETTINGS_Y_POS);
            this.fLocation = new Point(n7, n8);
            int n9 = iDialogSettings.getInt(SETTINGS_WIDTH);
            int n10 = iDialogSettings.getInt(SETTINGS_HEIGHT);
            this.fSize = new Point(n9, n10);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
            this.fSize = null;
        }
        if (iDialogSettings.getBoolean(SETTINGS_SHOW_NAMESPACES) && this.fKnownTypes.contains(n6 = new Integer(61))) {
            fFilterMatcher.getVisibleTypes().add(n6);
        }
        if (iDialogSettings.getBoolean(SETTINGS_SHOW_CLASSES) && this.fKnownTypes.contains(n5 = new Integer(64))) {
            fFilterMatcher.getVisibleTypes().add(n5);
        }
        if (iDialogSettings.getBoolean(SETTINGS_SHOW_STRUCTS) && this.fKnownTypes.contains(n4 = new Integer(65))) {
            fFilterMatcher.getVisibleTypes().add(n4);
        }
        if (iDialogSettings.getBoolean(SETTINGS_SHOW_TYPEDEFS) && this.fKnownTypes.contains(n3 = new Integer(78))) {
            fFilterMatcher.getVisibleTypes().add(n3);
        }
        if (iDialogSettings.getBoolean(SETTINGS_SHOW_ENUMS) && this.fKnownTypes.contains(n2 = new Integer(63))) {
            fFilterMatcher.getVisibleTypes().add(n2);
        }
        if (iDialogSettings.getBoolean(SETTINGS_SHOW_UNIONS) && this.fKnownTypes.contains(n = new Integer(66))) {
            fFilterMatcher.getVisibleTypes().add(n);
        }
        fFilterMatcher.setShowLowLevelTypes(iDialogSettings.getBoolean(SETTINGS_SHOW_LOWLEVEL));
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        if (this.fSize != null) {
            point.x = Math.max(point.x, this.fSize.x);
            point.y = Math.max(point.y, this.fSize.y);
            Rectangle rectangle = this.getShell().getDisplay().getClientArea();
            point.x = Math.min(point.x, rectangle.width);
            point.y = Math.min(point.y, rectangle.height);
        }
        return point;
    }

    protected Point getInitialLocation(Point point) {
        Point point2 = super.getInitialLocation(point);
        if (this.fLocation != null) {
            int n;
            point2.x = this.fLocation.x;
            point2.y = this.fLocation.y;
            Rectangle rectangle = this.getShell().getDisplay().getClientArea();
            int n2 = point2.x + point.x;
            if (n2 > rectangle.width) {
                point2.x -= n2 - rectangle.width;
            }
            if ((n = point2.y + point.y) > rectangle.height) {
                point2.y -= n - rectangle.height;
            }
        }
        return point2;
    }

    protected void computeResult() {
        ITypeInfo iTypeInfo = (ITypeInfo)this.getLowerSelectedElement();
        if (iTypeInfo == null) {
            return;
        }
        ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>(1);
        arrayList.add(iTypeInfo);
        this.setResult(arrayList);
    }

    private static class TypeFilterMatcher
    implements FilteredList.FilterMatcher {
        private static final char END_SYMBOL = '<';
        private static final char ANY_STRING = '*';
        private StringMatcher fNameMatcher = null;
        private StringMatcher[] fSegmentMatchers = null;
        private boolean fMatchGlobalNamespace = false;
        private Collection fVisibleTypes = new HashSet();
        private boolean fShowLowLevelTypes = false;

        TypeFilterMatcher() {
        }

        public void setFilter(String string, boolean bl, boolean bl2) {
            QualifiedTypeName qualifiedTypeName = new QualifiedTypeName(string);
            String[] stringArray = qualifiedTypeName.segments();
            int n = stringArray.length;
            stringArray[n - 1] = TypeFilterMatcher.adjustPattern(stringArray[n - 1]);
            this.fMatchGlobalNamespace = false;
            this.fSegmentMatchers = new StringMatcher[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                if (stringArray[n3].length() > 0) {
                    this.fSegmentMatchers[n2++] = new StringMatcher(stringArray[n3], bl, bl2);
                } else if (n3 == 0) {
                    this.fMatchGlobalNamespace = true;
                }
                ++n3;
            }
            if (n2 != n) {
                if (n2 > 0) {
                    StringMatcher[] stringMatcherArray = new StringMatcher[n2];
                    System.arraycopy(this.fSegmentMatchers, 0, stringMatcherArray, 0, n2);
                    this.fSegmentMatchers = stringMatcherArray;
                } else {
                    this.fSegmentMatchers = new StringMatcher[1];
                    this.fSegmentMatchers[0] = new StringMatcher(String.valueOf('*'), bl, bl2);
                }
            }
            this.fNameMatcher = this.fSegmentMatchers[this.fSegmentMatchers.length - 1];
        }

        public void setVisibleTypes(Collection collection) {
            this.fVisibleTypes.clear();
            this.fVisibleTypes.addAll(collection);
        }

        public Collection getVisibleTypes() {
            return this.fVisibleTypes;
        }

        public void setShowLowLevelTypes(boolean bl) {
            this.fShowLowLevelTypes = bl;
        }

        public boolean getShowLowLevelTypes() {
            return this.fShowLowLevelTypes;
        }

        public boolean match(Object object) {
            if (!(object instanceof ITypeInfo)) {
                return false;
            }
            ITypeInfo iTypeInfo = (ITypeInfo)object;
            IQualifiedTypeName iQualifiedTypeName = iTypeInfo.getQualifiedTypeName();
            if (this.fVisibleTypes != null && !this.fVisibleTypes.contains(new Integer(iTypeInfo.getCElementType()))) {
                return false;
            }
            if (!this.fShowLowLevelTypes && iQualifiedTypeName.isLowLevel()) {
                return false;
            }
            if (this.fSegmentMatchers.length == 1 && !this.fMatchGlobalNamespace) {
                return this.fNameMatcher.match(iQualifiedTypeName.getName());
            }
            return this.matchQualifiedName(iTypeInfo);
        }

        private boolean matchQualifiedName(ITypeInfo iTypeInfo) {
            IQualifiedTypeName iQualifiedTypeName = iTypeInfo.getQualifiedTypeName();
            String[] stringArray = iQualifiedTypeName.segments();
            if (this.fSegmentMatchers.length != stringArray.length) {
                return false;
            }
            if (this.fMatchGlobalNamespace && iTypeInfo.getRootNamespace(false) != null) {
                return false;
            }
            boolean bl = true;
            int n = Math.min(this.fSegmentMatchers.length, stringArray.length);
            int n2 = 0;
            while (n2 < n) {
                StringMatcher stringMatcher = this.fSegmentMatchers[n2];
                String string = stringArray[n2];
                if (string == null || !stringMatcher.match(string)) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            return bl;
        }

        private static String adjustPattern(String string) {
            int n = string.length();
            if (n > 0) {
                switch (string.charAt(n - 1)) {
                    case '<': {
                        return string.substring(0, n - 1);
                    }
                    case '*': {
                        return string;
                    }
                }
            }
            return String.valueOf(string) + '*';
        }
    }

    private static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            int n = string.compareToIgnoreCase(string2);
            if (n == 0) {
                n = string.compareTo(string2);
            }
            return n;
        }
    }
}

