/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractBinaryParserPage
extends AbstractCOptionPage {
    protected ICOptionPage fCurrentBinaryParserPage;
    protected Map fParserPageMap = null;
    protected Composite fCompositeParent;
    private ICOptionPage fCurrentPage;

    protected AbstractBinaryParserPage(String string) {
        super(string);
        this.initializeParserPageMap();
    }

    protected AbstractBinaryParserPage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
        this.initializeParserPageMap();
    }

    private void initializeParserPageMap() {
        this.fParserPageMap = new HashMap(5);
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui", "BinaryParserPage");
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getName().equals("parserPage")) {
                String string = iConfigurationElementArray[n].getAttribute("parserID");
                this.fParserPageMap.put(string, new BinaryParserPageConfiguration(iConfigurationElementArray[n]));
            }
            ++n;
        }
    }

    protected Composite getCompositeParent() {
        return this.fCompositeParent;
    }

    protected void setCompositeParent(Composite composite) {
        this.fCompositeParent = composite;
        this.fCompositeParent.setLayout((Layout)new TabFolderLayout());
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.handleBinaryParserChanged();
    }

    protected void handleBinaryParserChanged() {
        ICOptionPage iCOptionPage;
        if (this.getCompositeParent() == null) {
            return;
        }
        String[] stringArray = this.getBinaryParserIDs();
        int n = 0;
        while (n < stringArray.length) {
            iCOptionPage = this.getBinaryParserPage(stringArray[n]);
            if (iCOptionPage != null) {
                if (iCOptionPage.getControl() == null) {
                    Composite composite = this.getCompositeParent();
                    iCOptionPage.setContainer(this.getContainer());
                    iCOptionPage.createControl(composite);
                    composite.layout(true);
                } else {
                    iCOptionPage.setVisible(false);
                }
            }
            ++n;
        }
        String string = this.getCurrentBinaryParserID();
        iCOptionPage = this.getBinaryParserPage(string);
        if (iCOptionPage != null) {
            iCOptionPage.setVisible(true);
        }
        this.setCurrentPage(iCOptionPage);
    }

    protected ICOptionPage getCurrentPage() {
        return this.fCurrentPage;
    }

    protected void setCurrentPage(ICOptionPage iCOptionPage) {
        this.fCurrentPage = iCOptionPage;
    }

    protected ICOptionPage getBinaryParserPage(String string) {
        BinaryParserPageConfiguration binaryParserPageConfiguration = (BinaryParserPageConfiguration)this.fParserPageMap.get(string);
        if (binaryParserPageConfiguration != null) {
            try {
                return binaryParserPageConfiguration.getPage();
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    protected abstract String getCurrentBinaryParserID();

    protected abstract String[] getBinaryParserIDs();

    public abstract void createControl(Composite var1);

    public abstract void performApply(IProgressMonitor var1) throws CoreException;

    public abstract void performDefaults();

    protected class BinaryParserPageConfiguration {
        ICOptionPage page;
        IConfigurationElement fElement;

        public BinaryParserPageConfiguration(IConfigurationElement iConfigurationElement) {
            this.fElement = iConfigurationElement;
        }

        public ICOptionPage getPage() throws CoreException {
            if (this.page == null) {
                this.page = (ICOptionPage)this.fElement.createExecutableExtension("class");
            }
            return this.page;
        }
    }
}

