/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public abstract class AbstractErrorParserBlock
extends AbstractCOptionPage {
    private static final String PREFIX = "ErrorParserBlock";
    private static final String LABEL = "ErrorParserBlock.label";
    private static final String DESC = "ErrorParserBlock.desc";
    private static String[] EMPTY = new String[0];
    private Preferences fPrefs;
    protected HashMap mapParsers = new HashMap();
    private CheckedListDialogField fErrorParserList;
    protected boolean listDirty = false;

    public AbstractErrorParserBlock(Preferences preferences) {
        super(CUIPlugin.getResourceString(LABEL));
        this.setDescription(CUIPlugin.getResourceString(DESC));
        this.fPrefs = preferences;
    }

    public Image getImage() {
        return null;
    }

    public void updateValues() {
        this.fErrorParserList.removeAllElements();
        this.setValues();
    }

    protected ILabelProvider getLabelProvider() {
        return new LabelProvider(){

            public String getText(Object object) {
                String string = (String)AbstractErrorParserBlock.this.mapParsers.get(object.toString());
                return string != null ? string : "";
            }
        };
    }

    protected FieldListenerAdapter getFieldListenerAdapter() {
        return new FieldListenerAdapter();
    }

    protected String[] getErrorParserIDs(Preferences preferences) {
        String string = preferences.getString("org.eclipse.cdt.core.errorOutputParser");
        String[] stringArray = new String[]{};
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreElements()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    protected abstract String[] getErrorParserIDs(IProject var1);

    protected String[] getErrorParserIDs() {
        return new String[0];
    }

    protected abstract void saveErrorParsers(IProject var1, String[] var2) throws CoreException;

    protected void saveErrorParsers(Preferences preferences, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]).append(';');
            ++n;
        }
        preferences.setValue("org.eclipse.cdt.core.errorOutputParser", stringBuffer.toString());
    }

    protected void initMapParsers() {
        this.mapParsers.clear();
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "ErrorParser");
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                this.mapParsers.put(iExtensionArray[n].getUniqueIdentifier(), iExtensionArray[n].getLabel());
                ++n;
            }
        }
    }

    protected void initializeValues() {
        this.initMapParsers();
        this.setValues();
    }

    protected void setValues() {
        IProject iProject = this.getContainer().getProject();
        String[] stringArray = iProject == null ? (this.fPrefs != null ? this.getErrorParserIDs(this.fPrefs) : this.getErrorParserIDs()) : this.getErrorParserIDs(iProject);
        List<String> list = Arrays.asList(stringArray);
        this.fErrorParserList.setElements(list);
        this.fErrorParserList.setCheckedElements(list);
        Iterator iterator = this.mapParsers.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) continue;
            this.fErrorParserList.addElement(string);
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.ui.newproj_parser_error");
        String[] stringArray = new String[5];
        stringArray[0] = CUIMessages.getString("AbstractErrorParserBlock.label.up");
        stringArray[1] = CUIMessages.getString("AbstractErrorParserBlock.label.down");
        stringArray[3] = CUIMessages.getString("AbstractErrorParserBlock.label.selectAll");
        stringArray[4] = CUIMessages.getString("AbstractErrorParserBlock.label.unselectAll");
        String[] stringArray2 = stringArray;
        this.fErrorParserList = new CheckedListDialogField(null, stringArray2, this.getLabelProvider());
        this.fErrorParserList.setDialogFieldListener(this.getFieldListenerAdapter());
        this.fErrorParserList.setLabelText(CUIMessages.getString("AbstractErrorParserBlock.label.errorParsers"));
        this.fErrorParserList.setUpButtonIndex(0);
        this.fErrorParserList.setDownButtonIndex(1);
        this.fErrorParserList.setCheckAllButtonIndex(3);
        this.fErrorParserList.setUncheckAllButtonIndex(4);
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fErrorParserList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fErrorParserList.getListControl(null));
        this.initializeValues();
    }

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.listDirty) {
            IProject iProject = this.getContainer().getProject();
            if (iProgressMonitor == null) {
                iProgressMonitor = new NullProgressMonitor();
            }
            iProgressMonitor.beginTask(CUIMessages.getString("AbstractErrorParserBlock.task.setErrorParser"), 1);
            List list = this.fErrorParserList.getElements();
            int n = list.size();
            ArrayList arrayList = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                Object e = list.get(n2);
                if (this.fErrorParserList.isChecked(e)) {
                    arrayList.add(e);
                }
                ++n2;
            }
            String[] stringArray = arrayList.toArray(EMPTY);
            if (iProject == null) {
                this.saveErrorParsers(this.fPrefs, stringArray);
            } else {
                this.saveErrorParsers(iProject, stringArray);
            }
            iProgressMonitor.worked(1);
            iProgressMonitor.done();
        }
    }

    public void performDefaults() {
        this.initializeValues();
    }

    class FieldListenerAdapter
    implements IDialogFieldListener {
        FieldListenerAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            AbstractErrorParserBlock.this.listDirty = true;
        }
    }
}

