/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractGNUBinaryParserPage
extends AbstractCOptionPage {
    public static final String PREF_ADDR2LINE_PATH = "org.eclipse.cdt.ui.addr2line";
    public static final String PREF_CPPFILT_PATH = "org.eclipse.cdt.ui.cppfilt";
    protected Text fAddr2LineCommandText;
    protected Text fCPPFiltCommandText;
    private String parserID = null;

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        String string = this.fAddr2LineCommandText.getText().trim();
        String string2 = this.fCPPFiltCommandText.getText().trim();
        iProgressMonitor.beginTask(CUIMessages.getString("BinaryParserPage.task.savingAttributes"), 1);
        IProject iProject = this.getContainer().getProject();
        if (iProject != null) {
            ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject, false);
            ICExtensionReference[] iCExtensionReferenceArray = iCDescriptor.get("org.eclipse.cdt.core.BinaryParser");
            if (iCExtensionReferenceArray.length > 0) {
                this.initializeParserId();
                int n = 0;
                while (n < iCExtensionReferenceArray.length) {
                    if (iCExtensionReferenceArray[n].getID().equals(this.parserID)) {
                        String string3 = iCExtensionReferenceArray[n].getExtensionData("addr2line");
                        if (string3 == null || !string3.equals(string)) {
                            iCExtensionReferenceArray[n].setExtensionData("addr2line", string);
                        }
                        if ((string3 = iCExtensionReferenceArray[n].getExtensionData("c++filt")) == null || !string3.equals(string2)) {
                            iCExtensionReferenceArray[n].setExtensionData("c++filt", string2);
                        }
                    }
                    ++n;
                }
            }
        } else {
            Preferences preferences = this.getContainer().getPreferences();
            if (preferences != null) {
                preferences.setValue(PREF_ADDR2LINE_PATH, string);
                preferences.setValue(PREF_CPPFILT_PATH, string2);
            }
        }
    }

    private void initializeParserId() {
        if (this.parserID == null) {
            IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui", "BinaryParserPage");
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                String string = iConfigurationElementArray[n].getAttribute("parserID");
                String string2 = iConfigurationElementArray[n].getAttribute("class");
                String string3 = this.getRealBinaryParserPage().getClass().getName();
                if (string2 != null && string2.equals(string3)) {
                    this.parserID = string;
                    return;
                }
                ++n;
            }
            this.parserID = "";
        }
    }

    protected abstract AbstractGNUBinaryParserPage getRealBinaryParserPage();

    public void performDefaults() {
        String string = null;
        String string2 = null;
        IProject iProject = this.getContainer().getProject();
        Preferences preferences = this.getContainer().getPreferences();
        if (preferences != null) {
            if (iProject != null) {
                string = preferences.getString(PREF_ADDR2LINE_PATH);
                string2 = preferences.getString(PREF_CPPFILT_PATH);
            } else {
                string = preferences.getDefaultString(PREF_ADDR2LINE_PATH);
                string2 = preferences.getDefaultString(PREF_CPPFILT_PATH);
            }
            this.fAddr2LineCommandText.setText(string == null || string.length() == 0 ? "addr2line" : string);
            this.fCPPFiltCommandText.setText(string2 == null || string2.length() == 0 ? "c++filt" : string2);
        }
    }

    public void createControl(Composite composite) {
        Group group = new Group(composite, 16);
        group.setText(CUIMessages.getString("BinaryParserBlock.binaryParserOptions"));
        group.setLayout((Layout)new GridLayout(2, true));
        group.setLayoutData((Object)new GridData(768));
        ((GridLayout)group.getLayout()).makeColumnsEqualWidth = false;
        Label label = ControlFactory.createLabel((Composite)group, CUIMessages.getString("BinaryParserPage.label.addr2lineCommand"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fAddr2LineCommandText = ControlFactory.createTextField((Composite)group, 2052);
        this.fAddr2LineCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
            }
        });
        Button button = ControlFactory.createPushButton((Composite)group, CUIMessages.getString("BinaryParserPage.label.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.handleAddr2LineButtonSelected();
            }

            private void handleAddr2LineButtonSelected() {
                String string;
                FileDialog fileDialog = new FileDialog(AbstractGNUBinaryParserPage.this.getShell(), 0);
                fileDialog.setText(CUIMessages.getString("BinaryParserPage.label.addr2lineCommand"));
                String string2 = AbstractGNUBinaryParserPage.this.fAddr2LineCommandText.getText().trim();
                int n = string2.lastIndexOf(File.separator);
                if (n != -1) {
                    fileDialog.setFilterPath(string2.substring(0, n));
                }
                if ((string = fileDialog.open()) == null) {
                    return;
                }
                AbstractGNUBinaryParserPage.this.fAddr2LineCommandText.setText(string);
            }
        });
        label = ControlFactory.createLabel((Composite)group, CUIMessages.getString("BinaryParserPage.label.cppfiltCommand"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fCPPFiltCommandText = ControlFactory.createTextField((Composite)group, 2052);
        gridData = new GridData(768);
        this.fCPPFiltCommandText.setLayoutData((Object)gridData);
        this.fCPPFiltCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
            }
        });
        button = ControlFactory.createPushButton((Composite)group, CUIMessages.getString("BinaryParserPage.label.browse1"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.handleCPPFiltButtonSelected();
            }

            private void handleCPPFiltButtonSelected() {
                String string;
                FileDialog fileDialog = new FileDialog(AbstractGNUBinaryParserPage.this.getShell(), 0);
                fileDialog.setText(CUIMessages.getString("BinaryParserPage.label.cppfiltCommand"));
                String string2 = AbstractGNUBinaryParserPage.this.fCPPFiltCommandText.getText().trim();
                int n = string2.lastIndexOf(File.separator);
                if (n != -1) {
                    fileDialog.setFilterPath(string2.substring(0, n));
                }
                if ((string = fileDialog.open()) == null) {
                    return;
                }
                AbstractGNUBinaryParserPage.this.fCPPFiltCommandText.setText(string);
            }
        });
        this.setControl((Control)group);
        this.initialziedValues();
    }

    private void initialziedValues() {
        String string;
        String string2;
        block7: {
            string2 = null;
            string = null;
            IProject iProject = this.getContainer().getProject();
            if (iProject != null) {
                try {
                    ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject, false);
                    ICExtensionReference[] iCExtensionReferenceArray = iCDescriptor.get("org.eclipse.cdt.core.BinaryParser");
                    if (iCExtensionReferenceArray.length <= 0) break block7;
                    this.initializeParserId();
                    int n = 0;
                    while (n < iCExtensionReferenceArray.length) {
                        if (iCExtensionReferenceArray[n].getID().equals(this.parserID)) {
                            string2 = iCExtensionReferenceArray[0].getExtensionData("addr2line");
                            string = iCExtensionReferenceArray[0].getExtensionData("c++filt");
                            break;
                        }
                        ++n;
                    }
                }
                catch (CoreException coreException) {}
            } else {
                Preferences preferences = this.getContainer().getPreferences();
                if (preferences != null) {
                    string2 = preferences.getString(PREF_ADDR2LINE_PATH);
                    string = preferences.getString(PREF_CPPFILT_PATH);
                }
            }
        }
        this.fAddr2LineCommandText.setText(string2 == null || string2.length() == 0 ? "addr2line" : string2);
        this.fCPPFiltCommandText.setText(string == null || string.length() == 0 ? "c++filt" : string);
    }
}

