/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.AbstractBinaryParserPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class BinaryParserBlock
extends AbstractBinaryParserPage {
    private static final String PREFIX = "BinaryParserBlock";
    private static final String LABEL = "BinaryParserBlock.label";
    private static final String DESC = "BinaryParserBlock.desc";
    private static final String ATTR_FILTER = "filter";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_NAME_VISIBILITY = "visibility";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_VALUE_PRIVATE = "private";
    protected CheckedListDialogField binaryList;
    Map configMap;
    List initialSelected;

    public BinaryParserBlock() {
        super(CUIPlugin.getResourceString(LABEL));
        this.setDescription(CUIPlugin.getResourceString(DESC));
        String[] stringArray = new String[]{CUIMessages.getString("BinaryParserBlock.button.up"), CUIMessages.getString("BinaryParserBlock.button.down")};
        IListAdapter iListAdapter = new IListAdapter(){

            public void customButtonPressed(ListDialogField listDialogField, int n) {
            }

            public void selectionChanged(ListDialogField listDialogField) {
                BinaryParserBlock.this.handleBinaryParserChanged();
            }

            public void doubleClicked(ListDialogField listDialogField) {
            }
        };
        this.binaryList = new CheckedListDialogField(iListAdapter, stringArray, (ILabelProvider)new BinaryParserLabelProvider()){

            protected int getListStyle() {
                int n = super.getListStyle();
                return n & 0xFFFFFFFD;
            }
        };
        this.binaryList.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                if (BinaryParserBlock.this.getContainer() != null) {
                    BinaryParserBlock.this.getContainer().updateContainer();
                    BinaryParserBlock.this.handleBinaryParserChanged();
                }
            }
        });
        this.binaryList.setLabelText(CUIMessages.getString("BinaryParserBlock.binaryParser"));
        this.binaryList.setUpButtonIndex(0);
        this.binaryList.setDownButtonIndex(1);
        this.initializeParserList();
    }

    private void initializeParserList() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "BinaryParser");
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            this.configMap = new HashMap(iExtensionArray.length);
            int n = 0;
            while (n < iExtensionArray.length) {
                if (this.isExtensionVisible(iExtensionArray[n])) {
                    this.configMap.put(iExtensionArray[n].getUniqueIdentifier(), new BinaryParserConfiguration(iExtensionArray[n]));
                }
                ++n;
            }
        }
    }

    private boolean isExtensionVisible(IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[n].getChildren(ATTR_FILTER);
            int n2 = 0;
            while (n2 < iConfigurationElementArray2.length) {
                String string;
                String string2 = iConfigurationElementArray2[n2].getAttribute(ATTR_NAME);
                if (string2 != null && string2.equals(ATTR_NAME_VISIBILITY) && (string = iConfigurationElementArray2[n2].getAttribute(ATTR_VALUE)) != null && string.equals(ATTR_VALUE_PRIVATE)) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public void createControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = ControlFactory.createComposite(composite, 1);
        ((GridData)composite2.getLayoutData()).horizontalAlignment = 768;
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.ui.newproj_parser_binary");
        Composite composite3 = ControlFactory.createComposite(composite2, 1);
        LayoutUtil.doDefaultLayout(composite3, new DialogField[]{this.binaryList}, true);
        LayoutUtil.setHorizontalGrabbing(this.binaryList.getListControl(null));
        int n = pixelConverter.convertWidthInCharsToPixels(15);
        this.binaryList.setButtonsMinWidth(n);
        Composite composite4 = new Composite(composite2, 0);
        GridData gridData = new GridData();
        gridData.heightHint = pixelConverter.convertHorizontalDLUsToPixels(150);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite4.setLayoutData((Object)gridData);
        this.setCompositeParent(composite4);
        this.handleBinaryParserChanged();
        composite.layout(true);
    }

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(CUIMessages.getString("BinaryParserBlock.settingBinaryParser"), 2);
        List list = this.binaryList.getElements();
        final ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < list.size()) {
            if (this.binaryList.isChecked(list.get(n))) {
                arrayList.add(list.get(n));
            }
            ++n;
        }
        if (arrayList != null) {
            if (this.getContainer().getProject() != null) {
                ICDescriptorOperation iCDescriptorOperation = new ICDescriptorOperation(){

                    public void execute(ICDescriptor iCDescriptor, IProgressMonitor iProgressMonitor) throws CoreException {
                        int n;
                        if (BinaryParserBlock.this.initialSelected == null || !arrayList.equals(BinaryParserBlock.this.initialSelected)) {
                            iCDescriptor.remove("org.eclipse.cdt.core.BinaryParser");
                            n = 0;
                            while (n < arrayList.size()) {
                                iCDescriptor.create("org.eclipse.cdt.core.BinaryParser", ((BinaryParserConfiguration)arrayList.get(n)).getID());
                                ++n;
                            }
                        }
                        iProgressMonitor.worked(1);
                        n = 0;
                        while (n < arrayList.size()) {
                            ICOptionPage iCOptionPage = BinaryParserBlock.this.getBinaryParserPage(((BinaryParserConfiguration)arrayList.get(n)).getID());
                            if (iCOptionPage != null && iCOptionPage.getControl() != null) {
                                iCOptionPage.performApply((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                            }
                            ++n;
                        }
                    }
                };
                CCorePlugin.getDefault().getCDescriptorManager().runDescriptorOperation(this.getContainer().getProject(), iCDescriptorOperation, iProgressMonitor);
            } else {
                Preferences preferences;
                if (!(this.initialSelected != null && arrayList.equals(this.initialSelected) || (preferences = this.getContainer().getPreferences()) == null)) {
                    preferences.setValue("binaryparser", this.arrayToString(arrayList.toArray()));
                }
                iProgressMonitor.worked(1);
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    ICOptionPage iCOptionPage = this.getBinaryParserPage(((BinaryParserConfiguration)arrayList.get(n2)).getID());
                    if (iCOptionPage != null && iCOptionPage.getControl() != null) {
                        iCOptionPage.performApply((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    }
                    ++n2;
                }
            }
            this.initialSelected = arrayList;
        }
        iProgressMonitor.done();
    }

    public void setContainer(ICOptionContainer iCOptionContainer) {
        Object object;
        Object object2;
        super.setContainer(iCOptionContainer);
        ArrayList arrayList = new ArrayList();
        if (this.getContainer().getProject() != null) {
            try {
                object2 = CCorePlugin.getDefault().getCProjectDescription(this.getContainer().getProject());
                object = object2.get("org.eclipse.cdt.core.BinaryParser");
                this.initialSelected = new ArrayList(((ICExtensionReference[])object).length);
                int n = 0;
                while (n < ((Object)object).length) {
                    if (this.configMap.get(object[n].getID()) != null) {
                        this.initialSelected.add(this.configMap.get(object[n].getID()));
                        arrayList.add(this.configMap.get(object[n].getID()));
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {}
            object2 = this.configMap.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                if (arrayList.contains(object.getValue())) continue;
                arrayList.add(object.getValue());
            }
            this.binaryList.setElements(arrayList);
            if (this.initialSelected != null) {
                this.binaryList.setCheckedElements(this.initialSelected);
            }
        }
        if (this.initialSelected == null) {
            object2 = this.getContainer().getPreferences();
            object = null;
            if (object2 != null) {
                object = object2.getString("binaryparser");
            }
            if (object != null && ((String)object).length() > 0) {
                String[] stringArray = this.parseStringToArray((String)object);
                this.initialSelected = new ArrayList(stringArray.length);
                int n = 0;
                while (n < stringArray.length) {
                    if (this.configMap.get(stringArray[n]) != null) {
                        this.initialSelected.add(this.configMap.get(stringArray[n]));
                        arrayList.add(this.configMap.get(stringArray[n]));
                    }
                    ++n;
                }
            }
            Iterator iterator = this.configMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (arrayList.contains(entry.getValue())) continue;
                arrayList.add(entry.getValue());
            }
            this.binaryList.setElements(arrayList);
            if (this.initialSelected != null) {
                this.binaryList.setCheckedElements(this.initialSelected);
            }
            this.initialSelected = null;
        }
    }

    private String arrayToString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            stringBuffer.append(objectArray[n].toString()).append(';');
            ++n;
        }
        return stringBuffer.toString();
    }

    private String[] parseStringToArray(String string) {
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreElements()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return new String[0];
    }

    public void performDefaults() {
        String[] stringArray;
        String string = null;
        List list = this.binaryList.getCheckedElements();
        int n = 0;
        while (n < list.size()) {
            stringArray = this.getBinaryParserPage(((BinaryParserConfiguration)list.get(n)).getID());
            if (stringArray != null) {
                stringArray.performDefaults();
            }
            ++n;
        }
        Preferences preferences = this.getContainer().getPreferences();
        if (preferences != null) {
            string = this.getContainer().getProject() != null ? preferences.getString("binaryparser") : preferences.getDefaultString("binaryparser");
        }
        list.clear();
        if (string != null) {
            stringArray = this.parseStringToArray(string);
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (this.configMap.get(stringArray[n2]) != null) {
                    list.add(this.configMap.get(stringArray[n2]));
                }
                ++n2;
            }
        }
        this.binaryList.setCheckedElements(list);
        this.handleBinaryParserChanged();
        this.getContainer().updateContainer();
    }

    protected String getCurrentBinaryParserID() {
        List list = this.binaryList.getSelectedElements();
        if (list.size() > 0) {
            BinaryParserConfiguration binaryParserConfiguration = (BinaryParserConfiguration)list.get(0);
            return binaryParserConfiguration.getID();
        }
        return null;
    }

    protected String[] getBinaryParserIDs() {
        return this.configMap.keySet().toArray(new String[this.configMap.keySet().size()]);
    }

    protected class BinaryParserConfiguration {
        IExtension fExtension;

        public BinaryParserConfiguration(IExtension iExtension) {
            this.fExtension = iExtension;
        }

        public String getID() {
            return this.fExtension.getUniqueIdentifier();
        }

        public String getName() {
            return this.fExtension.getLabel();
        }

        public String toString() {
            return this.fExtension.getUniqueIdentifier();
        }

        public boolean equals(Object object) {
            if (object instanceof BinaryParserConfiguration) {
                return this.getID().equals(((BinaryParserConfiguration)object).getID());
            }
            return super.equals(object);
        }
    }

    protected class BinaryParserLabelProvider
    extends LabelProvider {
        protected BinaryParserLabelProvider() {
        }

        public String getText(Object object) {
            return ((BinaryParserConfiguration)object).getName();
        }
    }
}

