/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IndexerOptionDialogPage
extends DialogPage {
    private static final String ENABLE_PREPROCESSOR_PROBLEMS = CUIMessages.getString("IndexerOptions.enablePreprocessor");
    private static final String ENABLE_SEMANTIC_PROBLEMS = CUIMessages.getString("IndexerOptions.enableSemantic");
    private static final String ENABLE_SYNTACTIC_PROBLEMS = CUIMessages.getString("IndexerOptions.enableSyntactic");
    private static final String ENABLE_INDEXING = CUIMessages.getString("IndexerOptions.enableIndexing");
    private static final String INDEXER = CUIMessages.getString("IndexerOptions.indexer");
    private static final String INDEXER_PROBLEMS = CUIMessages.getString("IndexerOptions.problemReporting");
    private Button indexerEnabled;
    private Button preprocessorProblemsEnabled;
    private Button syntacticProblemsEnabled;
    private Button semanticProblemsEnabled;

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(INDEXER);
        this.indexerEnabled = this.createCheckButton((Composite)group, ENABLE_INDEXING);
        Group group2 = new Group(composite2, 0);
        group2.setLayout((Layout)new GridLayout());
        group2.setLayoutData((Object)new GridData(768));
        group2.setText(INDEXER_PROBLEMS);
        this.preprocessorProblemsEnabled = this.createCheckButton((Composite)group2, ENABLE_PREPROCESSOR_PROBLEMS);
        this.semanticProblemsEnabled = this.createCheckButton((Composite)group2, ENABLE_SEMANTIC_PROBLEMS);
        this.syntacticProblemsEnabled = this.createCheckButton((Composite)group2, ENABLE_SYNTACTIC_PROBLEMS);
        this.setControl((Control)composite2);
    }

    private Button createCheckButton(Composite composite, String string) {
        Button button = new Button(composite, 16416);
        button.setText(string);
        GridData gridData = new GridData();
        button.setLayoutData((Object)gridData);
        return button;
    }

    public void setIndexerValue(boolean bl) {
        this.indexerEnabled.setSelection(bl);
    }

    public void setIndexerProblemValues(int n) {
        this.preprocessorProblemsEnabled.setSelection((n & 1) != 0);
        if (this.syntacticProblemsEnabled != null) {
            this.syntacticProblemsEnabled.setSelection((n & 4) != 0);
        }
        this.semanticProblemsEnabled.setSelection((n & 2) != 0);
    }

    public boolean getIndexerValue() {
        return this.indexerEnabled.getSelection();
    }

    public int getIndexerProblemsValues() {
        int n = 0;
        n |= this.preprocessorProblemsEnabled.getSelection() ? 1 : 0;
        if (this.syntacticProblemsEnabled != null) {
            n |= this.syntacticProblemsEnabled.getSelection() ? 4 : 0;
        }
        return n |= this.semanticProblemsEnabled.getSelection() ? 2 : 0;
    }

    public void persistIndexerValues(IProject iProject) {
        ICDescriptor iCDescriptor = null;
        Element element = null;
        IProject iProject2 = null;
        try {
            iProject2 = iProject;
            iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject2, true);
            element = iCDescriptor.getProjectData("cdt_indexer");
            Node node = element.getFirstChild();
            while (node != null) {
                element.removeChild(node);
                node = element.getFirstChild();
            }
            Document document = element.getOwnerDocument();
            boolean bl = this.getIndexerValue();
            int n = this.getIndexerProblemsValues();
            IndexerOptionDialogPage.saveIndexerEnabled(bl, element, document);
            IndexerOptionDialogPage.saveIndexerProblemsEnabled(n, element, document);
            iCDescriptor.saveProjectData();
            iProject.setSessionProperty(IndexManager.activationKey, (Object)new Boolean(bl));
            iProject.setSessionProperty(IndexManager.problemsActivationKey, (Object)new Integer(n));
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    private static void saveIndexerEnabled(boolean bl, Element element, Document document) {
        Element element2 = document.createElement("indexEnabled");
        Boolean bl2 = new Boolean(bl);
        element2.setAttribute("indexValue", bl2.toString());
        element.appendChild(element2);
    }

    private static void saveIndexerProblemsEnabled(int n, Element element, Document document) {
        Element element2 = document.createElement("indexerProblemsEnabled");
        Integer n2 = new Integer(n);
        element2.setAttribute("indexProblemsValue", n2.toString());
        element.appendChild(element2);
    }
}

