/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.ui.dialogs.IndexerOptionDialogPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IndexerOptionPropertyPage
extends PropertyPage {
    private IndexerOptionDialogPage optionPage = new IndexerOptionDialogPage();
    private boolean oldIndexerValue;
    private int oldIndexerProblemsValue;
    private boolean requestedIndexAll = false;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout());
        this.optionPage.createControl(composite2);
        WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.cdt.ui.std_prop_indexer");
        this.initialize();
        return composite2;
    }

    protected void performDefaults() {
        this.initialize();
        super.performDefaults();
    }

    private void initialize() {
        IProject iProject = this.getProject();
        try {
            this.oldIndexerValue = this.getIndexerEnabled(iProject);
            this.oldIndexerProblemsValue = this.getIndexerProblemsEnabled(iProject);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        this.optionPage.setIndexerValue(this.oldIndexerValue);
        this.optionPage.setIndexerProblemValues(this.oldIndexerProblemsValue);
    }

    public boolean performOk() {
        boolean bl;
        boolean bl2 = this.optionPage.getIndexerValue();
        int n = this.optionPage.getIndexerProblemsValues();
        boolean bl3 = this.oldIndexerValue != bl2;
        boolean bl4 = bl = this.oldIndexerProblemsValue != n;
        if (bl3 || bl) {
            IProject iProject = this.getProject();
            this.optionPage.persistIndexerValues(iProject);
            if (bl && n == 0) {
                CCorePlugin.getDefault().getCoreModel().getIndexManager().removeIndexerProblems((IResource)iProject);
            }
            if (bl3 && bl2 && !this.requestedIndexAll) {
                CCorePlugin.getDefault().getCoreModel().getIndexManager().indexAll(iProject);
                this.requestedIndexAll = true;
            } else if (bl3 && !bl2) {
                CCorePlugin.getDefault().getCoreModel().getIndexManager().discardJobs(iProject.getName());
            }
        }
        return true;
    }

    public IProject getProject() {
        IAdaptable iAdaptable = this.getElement();
        IProject iProject = null;
        if (iAdaptable != null && iAdaptable instanceof IProject) {
            iProject = (IProject)iAdaptable;
        }
        return iProject;
    }

    public boolean getIndexerEnabled(IProject iProject) throws CoreException {
        Boolean bl = (Boolean)iProject.getSessionProperty(IndexManager.activationKey);
        if (bl == null) {
            bl = this.loadIndexerEnabledFromCDescriptor(iProject);
        }
        if (bl != null) {
            iProject.setSessionProperty(IndexManager.activationKey, (Object)bl);
        } else {
            bl = new Boolean(true);
            this.optionPage.setIndexerValue(true);
            this.optionPage.persistIndexerValues(iProject);
        }
        return bl;
    }

    public int getIndexerProblemsEnabled(IProject iProject) throws CoreException {
        Integer n = (Integer)iProject.getSessionProperty(IndexManager.problemsActivationKey);
        if (n == null) {
            n = this.loadIndexerProblemsEnabledFromCDescriptor(iProject);
        }
        if (n != null) {
            iProject.setSessionProperty(IndexManager.problemsActivationKey, (Object)n);
        } else {
            n = new Integer(0);
            this.optionPage.setIndexerProblemValues(0);
            this.optionPage.persistIndexerValues(iProject);
        }
        return n;
    }

    private Boolean loadIndexerEnabledFromCDescriptor(IProject iProject) throws CoreException {
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject, true);
        Node node = iCDescriptor.getProjectData("cdt_indexer").getFirstChild();
        Boolean bl = null;
        while (node != null) {
            if (node.getNodeName().equals("indexEnabled")) {
                bl = Boolean.valueOf(((Element)node).getAttribute("indexValue"));
            }
            node = node.getNextSibling();
        }
        return bl;
    }

    private Integer loadIndexerProblemsEnabledFromCDescriptor(IProject iProject) throws CoreException {
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject, true);
        Node node = iCDescriptor.getProjectData("cdt_indexer").getFirstChild();
        Integer n = null;
        while (node != null) {
            if (node.getNodeName().equals("indexerProblemsEnabled")) {
                String string = ((Element)node).getAttribute("indexProblemsValue");
                try {
                    n = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    Boolean bl = Boolean.valueOf(string);
                    if (bl.booleanValue()) {
                        n = new Integer(1);
                        break;
                    }
                    n = new Integer(0);
                }
                break;
            }
            node = node.getNextSibling();
        }
        return n;
    }
}

