/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.NewCProjectWizardPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class NewCProjectWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    private static final String OP_ERROR = "CProjectWizard.op_error";
    private static final String OP_DESC = "CProjectWizard.op_description";
    private static final String PREFIX = "CProjectWizard";
    private static final String WZ_TITLE = "CProjectWizard.title";
    private static final String WZ_DESC = "CProjectWizard.description";
    private static final String WINDOW_TITLE = "CProjectWizard.windowTitle";
    private String wz_title;
    private String wz_desc;
    private String op_error;
    protected IConfigurationElement fConfigElement;
    protected NewCProjectWizardPage fMainPage;
    protected IProject newProject;
    List tabItemsList = new ArrayList();

    public NewCProjectWizard() {
        this(CUIPlugin.getResourceString(WZ_TITLE), CUIPlugin.getResourceString(WZ_DESC), CUIPlugin.getResourceString(OP_ERROR));
    }

    public NewCProjectWizard(String string, String string2) {
        this(string, string2, CUIPlugin.getResourceString(OP_ERROR));
    }

    public NewCProjectWizard(String string, String string2, String string3) {
        this.setDialogSettings(CUIPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.wz_title = string;
        this.wz_desc = string2;
        this.op_error = string3;
    }

    public void addPages() {
        this.fMainPage = new NewCProjectWizardPage(CUIPlugin.getResourceString(PREFIX));
        this.fMainPage.setTitle(this.wz_title);
        this.fMainPage.setDescription(this.wz_desc);
        this.addPage((IWizardPage)this.fMainPage);
    }

    protected abstract void doRunPrologue(IProgressMonitor var1);

    protected abstract void doRunEpilogue(IProgressMonitor var1);

    protected IStatus isValidName(String string) {
        return new Status(0, "org.eclipse.cdt.ui", 0, "", null);
    }

    protected IStatus isValidLocation(String string) {
        return new Status(0, "org.eclipse.cdt.ui", 0, "", null);
    }

    protected IPath getLocationPath() throws UnsupportedOperationException {
        if (this.fMainPage == null) {
            throw new UnsupportedOperationException();
        }
        return this.fMainPage.getLocationPath();
    }

    protected IProject getProjectHandle() throws UnsupportedOperationException {
        if (this.fMainPage == null) {
            throw new UnsupportedOperationException();
        }
        return this.fMainPage.getProjectHandle();
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    protected IResource getSelectedResource() {
        return this.getNewProject();
    }

    public boolean performFinish() {
        if (!this.invokeRunnable(this.getRunnable())) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        IResource iResource = this.getSelectedResource();
        this.selectAndReveal(iResource);
        if (iResource != null && iResource.getType() == 1) {
            IFile iFile = (IFile)iResource;
            IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
            if (iWorkbenchWindow != null) {
                try {
                    IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                    if (iWorkbenchPage != null) {
                        IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
                    }
                }
                catch (PartInitException partInitException) {
                    MessageDialog.openError((Shell)iWorkbenchWindow.getShell(), (String)CUIPlugin.getResourceString(OP_ERROR), (String)partInitException.getMessage());
                }
            }
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        this.fConfigElement = iConfigurationElement;
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(CPluginImages.DESC_WIZABAN_NEW_PROJ);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super.init(iWorkbench, iStructuredSelection);
        this.setWindowTitle(CUIPlugin.getResourceString(WINDOW_TITLE));
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                if (iProgressMonitor == null) {
                    iProgressMonitor = new NullProgressMonitor();
                }
                iProgressMonitor.beginTask(CUIPlugin.getResourceString(NewCProjectWizard.OP_DESC), 3);
                NewCProjectWizard.this.doRunPrologue((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                try {
                    NewCProjectWizard.this.doRun((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
                NewCProjectWizard.this.doRunEpilogue((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                iProgressMonitor.done();
            }
        };
    }

    protected boolean invokeRunnable(IRunnableWithProgress iRunnableWithProgress) {
        WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation(iRunnableWithProgress);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyDelegatingOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
            Shell shell = this.getShell();
            String string = CUIPlugin.getResourceString("CProjectWizard.op_error.title");
            String string2 = CUIPlugin.getResourceString("CProjectWizard.op_error.message");
            Throwable throwable = invocationTargetException.getTargetException();
            CUIPlugin.errorDialog(shell, string, string2, throwable);
            try {
                this.getProjectHandle().delete(false, false, null);
            }
            catch (CoreException coreException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    protected void doRun(IProgressMonitor iProgressMonitor) throws CoreException {
        this.createNewProject(iProgressMonitor);
    }

    protected IProject createNewProject(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.newProject != null) {
            return this.newProject;
        }
        IProject iProject = null;
        try {
            iProject = this.getProjectHandle();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, unsupportedOperationException.getMessage(), null));
        }
        IPath iPath = Platform.getLocation();
        IPath iPath2 = this.getLocationPath();
        if (iPath.equals((Object)iPath2)) {
            iPath2 = null;
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
        iProjectDescription.setLocation(iPath2);
        this.newProject = CCorePlugin.getDefault().createCProject(iProjectDescription, iProject, iProgressMonitor, this.getProjectID());
        return this.newProject;
    }

    public abstract String getProjectID();
}

