/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.NewClassWizardPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewClassWizard
extends BasicNewResourceWizard
implements INewWizard {
    private NewClassWizardPage fPage;
    private String wz_title;
    private boolean openInEditor = true;
    private static final String WZ_TITLE = "NewClassWizard.title";
    private static final String WZ_DESC = "NewClassWizard.description";
    private static final String PAGE_TITLE = "NewClassWizard.page.title";

    public NewClassWizard() {
        this(CUIPlugin.getResourceString(WZ_TITLE));
    }

    public NewClassWizard(String string) {
        this.wz_title = string;
        this.setDefaultPageImageDescriptor(CPluginImages.DESC_WIZBAN_NEWCLASS);
        this.setWindowTitle(this.wz_title);
        this.setNeedsProgressMonitor(true);
    }

    protected void finishPage(IProgressMonitor iProgressMonitor) throws InterruptedException, CoreException {
        if (this.fPage.createClass(iProgressMonitor)) {
            IResource iResource;
            ITranslationUnit iTranslationUnit = this.fPage.getCreatedClassHeaderFile();
            ITranslationUnit iTranslationUnit2 = this.fPage.getCreatedClassBodyFile();
            if (iTranslationUnit != null) {
                iResource = iTranslationUnit.getResource();
                this.selectAndReveal(iResource);
                if (this.doOpenInEditor()) {
                    this.openResource((IFile)iResource);
                }
            }
            if (iTranslationUnit2 != null) {
                iResource = iTranslationUnit2.getResource();
                this.selectAndReveal(iResource);
                if (this.doOpenInEditor()) {
                    this.openResource((IFile)iResource);
                }
            }
        }
    }

    public boolean performFinish() {
        if (!this.fPage.selectionIsCpp()) {
            return true;
        }
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
                try {
                    NewClassWizard.this.finishPage(iProgressMonitor);
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationCanceledException(interruptedException.getMessage());
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(iWorkspaceRunnable));
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleFinishException(this.getShell(), invocationTargetException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this.fPage = new NewClassWizardPage(this.getSelection());
        this.addPage((IWizardPage)this.fPage);
        this.fPage.setTitle(CUIPlugin.getResourceString(PAGE_TITLE));
        this.fPage.setDescription(CUIPlugin.getResourceString(WZ_DESC));
        this.fPage.init();
    }

    protected void handleFinishException(Shell shell, InvocationTargetException invocationTargetException) {
        String string = NewWizardMessages.getString("NewElementWizard.op_error.title");
        String string2 = NewWizardMessages.getString("NewElementWizard.op_error.message");
        ExceptionHandler.handle(invocationTargetException, shell, string, string2);
    }

    protected void openResource(final IFile iFile) {
        Display display;
        final IWorkbenchPage iWorkbenchPage = CUIPlugin.getActivePage();
        if (iWorkbenchPage != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
                    }
                    catch (PartInitException partInitException) {
                        CUIPlugin.getDefault().log(partInitException);
                    }
                }
            });
        }
    }

    public ICElement getCreatedClassElement() {
        return this.fPage.getCreatedClassElement();
    }

    public boolean doOpenInEditor() {
        return this.openInEditor;
    }

    public void setOpenInEditor(boolean bl) {
        this.openInEditor = bl;
    }
}

