/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.browser.UnknownTypeInfo;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.wizards.BaseClassSelectionDialog;
import org.eclipse.cdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LinkToFileGroup;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.CodeGeneration;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;

public class NewClassWizardPage
extends WizardPage
implements Listener {
    private static final String PAGE_NAME = "NewClassWizardPage";
    private final String HEADER_EXT = ".h";
    private final String BODY_EXT = ".cpp";
    private IStructuredSelection currentSelection;
    private ICElement eSelection = null;
    private IPath defaultSourceFolder = null;
    private ITypeSearchScope fClassScope = null;
    private final int[] fClassTypes = new int[]{64, 65};
    private IProject fSelectedProject = null;
    private ITranslationUnit parentHeaderTU = null;
    private ITranslationUnit parentBodyTU = null;
    private ICElement createdClass = null;
    private ITypeInfo[] elementsOfTypeClassInProject = null;
    private StringDialogField fClassNameDialogField;
    private StringButtonDialogField fBaseClassDialogField;
    private SelectionButtonDialogFieldGroup fAccessButtons;
    private SelectionButtonDialogFieldGroup fConstDestButtons;
    private LinkToFileGroup linkedResourceGroupForHeader;
    private LinkToFileGroup linkedResourceGroupForBody;
    private final int PUBLIC_INDEX = 0;
    private final int PROTECTED_INDEX = 1;
    private final int PRIVATE_INDEX = 2;
    private final int DEFAULT_INDEX = 3;
    private IStatus fCurrStatus;
    protected IStatus fClassNameStatus;
    protected IStatus fBaseClassStatus;
    protected IStatus fLinkedResourceGroupForHeaderStatus;
    protected IStatus fLinkedResourceGroupForBodyStatus;
    private boolean hasCppNature = false;
    private Comparator TYPE_NAME_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((ITypeInfo)object).getName().compareTo(((ITypeInfo)object2).getName());
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public NewClassWizardPage(IStructuredSelection iStructuredSelection) {
        super(PAGE_NAME);
        this.currentSelection = iStructuredSelection;
        this.hasCppNature = this.isSelectionCPP(this.currentSelection);
        if (this.hasCppNature) {
            this.initializePageControls();
        }
    }

    protected void initializePageControls() {
        TypeFieldsAdapter typeFieldsAdapter = new TypeFieldsAdapter();
        this.fClassNameDialogField = new StringDialogField();
        this.fClassNameDialogField.setDialogFieldListener(typeFieldsAdapter);
        this.fClassNameDialogField.setLabelText(NewWizardMessages.getString("NewClassWizardPage.classname.label"));
        this.fBaseClassDialogField = new StringButtonDialogField(typeFieldsAdapter);
        this.fBaseClassDialogField.setDialogFieldListener(typeFieldsAdapter);
        this.fBaseClassDialogField.setLabelText(NewWizardMessages.getString("NewClassWizardPage.baseclass.label"));
        this.fBaseClassDialogField.setButtonLabel(NewWizardMessages.getString("NewClassWizardPage.baseclass.button"));
        String[] stringArray = new String[]{NewWizardMessages.getString("NewClassWizardPage.baseclass.access.public"), NewWizardMessages.getString("NewClassWizardPage.baseclass.access.protected"), NewWizardMessages.getString("NewClassWizardPage.baseclass.access.private"), NewWizardMessages.getString("NewClassWizardPage.baseclass.access.access")};
        this.fAccessButtons = new SelectionButtonDialogFieldGroup(16, stringArray, 4);
        this.fAccessButtons.setDialogFieldListener(typeFieldsAdapter);
        this.fAccessButtons.setLabelText(NewWizardMessages.getString("NewClassWizardPage.baseclass.access.label"));
        this.fAccessButtons.setSelection(0, true);
        String[] stringArray2 = new String[]{NewWizardMessages.getString("NewClassWizardPage.constdest.inline"), NewWizardMessages.getString("NewClassWizardPage.constdest.virtualdestructor"), NewWizardMessages.getString("NewClassWizardPage.constdest.includeguard")};
        this.fConstDestButtons = new SelectionButtonDialogFieldGroup(32, stringArray2, 3);
        this.fConstDestButtons.setDialogFieldListener(typeFieldsAdapter);
        this.fConstDestButtons.setSelection(1, true);
        this.fConstDestButtons.setSelection(2, true);
        this.linkedResourceGroupForHeader = new LinkToFileGroup(typeFieldsAdapter, this);
        this.linkedResourceGroupForHeader.setDialogFieldListener(typeFieldsAdapter);
        this.linkedResourceGroupForHeader.setLabelText(NewWizardMessages.getString("NewClassWizardPage.files.header"));
        this.linkedResourceGroupForBody = new LinkToFileGroup(typeFieldsAdapter, this);
        this.linkedResourceGroupForBody.setDialogFieldListener(typeFieldsAdapter);
        this.linkedResourceGroupForBody.setLabelText(NewWizardMessages.getString("NewClassWizardPage.files.body"));
        this.fClassNameStatus = new StatusInfo();
        ((StatusInfo)this.fClassNameStatus).setError(NewWizardMessages.getString("NewClassWizardPage.error.EnterClassName"));
        this.fBaseClassStatus = new StatusInfo();
        this.fLinkedResourceGroupForHeaderStatus = new StatusInfo();
        this.fLinkedResourceGroupForBodyStatus = new StatusInfo();
    }

    public void init() {
        this.eSelection = this.getSelectionCElement(this.currentSelection);
        this.fSelectedProject = this.getSelectionProject(this.currentSelection);
        this.fClassScope = new TypeSearchScope();
        this.fClassScope.add(this.fSelectedProject);
        IResource iResource = this.getSelectionResourceElement(this.currentSelection);
        if (iResource != null) {
            this.defaultSourceFolder = iResource.getFullPath();
        }
        if (this.fSelectedProject != null && this.hasCppNature && this.defaultSourceFolder != null) {
            this.fAccessButtons.setEnabled(false);
            this.setPageComplete(false);
        } else {
            this.eSelection = null;
            this.defaultSourceFolder = null;
            StatusInfo statusInfo = new StatusInfo();
            if (!this.hasCppNature) {
                statusInfo.setError(NewWizardMessages.getString("NewClassWizardPage.error.NotAvailableForNonCppProjects"));
            } else if (this.fSelectedProject == null) {
                statusInfo.setError(NewWizardMessages.getString("NewClassWizardPage.error.SelectedProjectError"));
            } else {
                statusInfo.setError(NewWizardMessages.getString("NewClassWizardPage.error.DefaultSourceFolderError"));
            }
            this.updateStatus(statusInfo);
        }
    }

    public void createControl(Composite composite) {
        if (!this.hasCppNature) {
            this.setControl((Control)new Composite(composite, 0));
            return;
        }
        int n = 5;
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(n, false));
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        this.createClassNameControls(composite2, n);
        this.createBaseClassControls(composite2, n);
        this.createModifierControls(composite2, n);
        this.createSeparator(composite2, n);
        this.createFilesControls(composite2, n);
        composite2.layout();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
    }

    protected void createClassNameControls(Composite composite, int n) {
        this.fClassNameDialogField.doFillIntoGrid(composite, n - 1);
        DialogField.createEmptySpace(composite);
        LayoutUtil.setWidthHint((Control)this.fClassNameDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    protected void createBaseClassControls(Composite composite, int n) {
        this.fBaseClassDialogField.doFillIntoGrid(composite, n);
        LayoutUtil.setWidthHint((Control)this.fBaseClassDialogField.getTextControl(null), this.getMaxFieldWidth());
        this.createAccessControls(composite, n);
    }

    protected void createAccessControls(Composite composite, int n) {
        LayoutUtil.setHorizontalSpan((Control)this.fAccessButtons.getLabelControl(composite), 1);
        Composite composite2 = this.fAccessButtons.getSelectionButtonsGroup(composite);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = n - 2;
        composite2.setLayoutData((Object)gridData);
        DialogField.createEmptySpace(composite);
    }

    protected void createModifierControls(Composite composite, int n) {
        LayoutUtil.setHorizontalSpan((Control)this.fConstDestButtons.getLabelControl(composite), 1);
        Composite composite2 = this.fConstDestButtons.getSelectionButtonsGroup(composite);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = n - 1;
        composite2.setLayoutData((Object)gridData);
        DialogField.createEmptySpace(composite);
    }

    protected void createFilesControls(Composite composite, int n) {
        this.linkedResourceGroupForHeader.doFillIntoGrid(composite, n);
        this.linkedResourceGroupForBody.doFillIntoGrid(composite, n);
    }

    protected void createSeparator(Composite composite, int n) {
        new Separator(258).doFillIntoGrid(composite, n, this.convertHeightInCharsToPixels(1));
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    public void handleEvent(Event event) {
    }

    private void classPageChangeControlPressed(DialogField dialogField) {
        ITypeInfo iTypeInfo;
        if (dialogField == this.fBaseClassDialogField && (iTypeInfo = this.chooseBaseClass()) != null) {
            this.fBaseClassDialogField.setText(iTypeInfo.getQualifiedTypeName().getFullyQualifiedName());
        }
    }

    private void classPageCustomButtonPressed(DialogField dialogField, int n) {
    }

    private void classPageDialogFieldChanged(DialogField dialogField) {
        String string;
        if (dialogField == this.fClassNameDialogField) {
            string = this.fClassNameDialogField.getText();
            if (!this.linkedResourceGroupForHeader.linkCreated()) {
                if (string.length() > 0) {
                    this.linkedResourceGroupForHeader.setText(String.valueOf(string) + ".h");
                } else {
                    this.linkedResourceGroupForHeader.setText(string);
                }
            }
            if (!this.linkedResourceGroupForBody.linkCreated()) {
                if (string.length() > 0) {
                    this.linkedResourceGroupForBody.setText(String.valueOf(string) + ".cpp");
                } else {
                    this.linkedResourceGroupForBody.setText(string);
                }
            }
            this.fClassNameStatus = this.classNameChanged();
        }
        if (dialogField == this.fBaseClassDialogField) {
            string = this.fBaseClassDialogField.getText();
            this.fAccessButtons.setEnabled(string.length() > 0);
            this.fBaseClassStatus = this.baseClassNameChanged();
        }
        if (dialogField == this.linkedResourceGroupForHeader) {
            this.fLinkedResourceGroupForHeaderStatus = this.linkedResourceGroupChanged(this.linkedResourceGroupForHeader, true);
        }
        if (dialogField == this.linkedResourceGroupForBody) {
            this.fLinkedResourceGroupForBodyStatus = this.linkedResourceGroupChanged(this.linkedResourceGroupForBody, false);
        }
        this.doStatusUpdate();
    }

    IStatus linkedResourceGroupChanged(LinkToFileGroup linkToFileGroup, boolean bl) {
        StatusInfo statusInfo = new StatusInfo();
        if (linkToFileGroup.linkCreated()) {
            String string = linkToFileGroup.getText();
            if (string == null || string.length() == 0) {
                if (bl) {
                    statusInfo.setError(NewWizardMessages.getString("NewClassWizardPage.error.EnterHeaderFile"));
                } else {
                    statusInfo.setError(NewWizardMessages.getString("NewClassWizardPage.error.EnterBodyFile"));
                }
            } else {
                IPath iPath = this.getContainerFullPath(linkToFileGroup);
                boolean bl2 = false;
                if (iPath != null) {
                    File file = iPath.toFile();
                    boolean bl3 = bl2 = file != null && file.exists() && file.isFile();
                }
                if (!bl2) {
                    if (bl) {
                        statusInfo.setError(NewWizardMessages.getString("NewClassWizardPage.error.NoHeaderFile"));
                    } else {
                        statusInfo.setError(NewWizardMessages.getString("NewClassWizardPage.error.NoBodyFile"));
                    }
                }
            }
        } else {
            String string = this.fClassNameDialogField.getText();
            if (bl) {
                if (string.length() > 0) {
                    linkToFileGroup.setText(String.valueOf(string) + ".h");
                } else {
                    linkToFileGroup.setText(string);
                }
            } else if (string.length() > 0) {
                linkToFileGroup.setText(String.valueOf(string) + ".cpp");
            } else {
                linkToFileGroup.setText(string);
            }
        }
        return statusInfo;
    }

    public boolean selectionIsCpp() {
        return this.hasCppNature;
    }

    private boolean isSelectionCPP(IStructuredSelection iStructuredSelection) {
        IProject iProject = this.getSelectionProject(iStructuredSelection);
        if (iProject != null) {
            return CoreModel.hasCCNature((IProject)iProject);
        }
        return false;
    }

    private ICElement getSelectionCElement(IStructuredSelection iStructuredSelection) {
        ICProject[] iCProjectArray;
        ICProject iCProject = null;
        if (iStructuredSelection != null && !iStructuredSelection.isEmpty() && (iCProjectArray = iStructuredSelection.getFirstElement()) instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)iCProjectArray;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iCProject = (ICElement)iAdaptable.getAdapter((Class)clazz)) == null) {
                IResource iResource;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz2)) != null && iResource.getType() != 8) {
                    while (iCProject == null && iResource.getType() != 4) {
                        iResource = iResource.getParent();
                        Class<?> clazz3 = class$0;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        iCProject = (ICElement)iResource.getAdapter((Class)clazz3);
                    }
                    if (iCProject == null) {
                        iCProject = CoreModel.getDefault().create(iResource);
                    }
                }
            }
        }
        if (iCProject == null || iCProject.getElementType() == 10) {
            try {
                iCProjectArray = CoreModel.create((IWorkspaceRoot)CUIPlugin.getWorkspace().getRoot()).getCProjects();
                if (iCProjectArray.length == 1) {
                    iCProject = iCProjectArray[0];
                }
            }
            catch (CModelException cModelException) {}
        }
        return iCProject;
    }

    private IResource getSelectionResourceElement(IStructuredSelection iStructuredSelection) {
        Object object;
        IResource iResource = null;
        if (iStructuredSelection != null && !iStructuredSelection.isEmpty() && (object = iStructuredSelection.getFirstElement()) instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            if (iAdaptable instanceof ICElement) {
                iResource = ((ICElement)iAdaptable).getUnderlyingResource();
            } else {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (iResource != null && iResource instanceof IFile) {
                iResource = iResource.getParent();
            }
        }
        return iResource;
    }

    private IProject getSelectionProject(IStructuredSelection iStructuredSelection) {
        Object object;
        if (iStructuredSelection != null && !iStructuredSelection.isEmpty() && (object = iStructuredSelection.getFirstElement()) instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            IResource iResource = null;
            if (iAdaptable instanceof ICElement) {
                iResource = ((ICElement)iAdaptable).getUnderlyingResource();
            } else {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (iResource != null) {
                return iResource.getProject();
            }
        }
        return null;
    }

    private ITypeInfo[] findClassElementsInProject() {
        if (this.eSelection == null) {
            return null;
        }
        if (this.elementsOfTypeClassInProject != null) {
            return this.elementsOfTypeClassInProject;
        }
        if (!AllTypesCache.isCacheUpToDate((ITypeSearchScope)this.fClassScope)) {
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    AllTypesCache.updateCache((ITypeSearchScope)NewClassWizardPage.this.fClassScope, (IProgressMonitor)iProgressMonitor);
                    if (iProgressMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            try {
                this.getContainer().run(true, true, iRunnableWithProgress);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string = NewWizardMessages.getString("NewClassWizardPage.getProjectClasses.exception.title");
                String string2 = NewWizardMessages.getString("NewClassWizardPage.getProjectClasses.exception.message");
                ExceptionHandler.handle(invocationTargetException, string, string2);
                this.elementsOfTypeClassInProject = new ITypeInfo[0];
                return this.elementsOfTypeClassInProject;
            }
            catch (InterruptedException interruptedException) {
                this.elementsOfTypeClassInProject = new ITypeInfo[0];
                return this.elementsOfTypeClassInProject;
            }
        }
        this.elementsOfTypeClassInProject = AllTypesCache.getTypes((ITypeSearchScope)this.fClassScope, (int[])this.fClassTypes);
        Arrays.sort(this.elementsOfTypeClassInProject, this.TYPE_NAME_COMPARATOR);
        return this.elementsOfTypeClassInProject;
    }

    protected ITypeInfo chooseBaseClass() {
        Object[] objectArray = this.findClassElementsInProject();
        if (objectArray == null || objectArray.length == 0) {
            String string = NewWizardMessages.getString("NewClassWizardPage.getProjectClasses.noclasses.title");
            String string2 = NewWizardMessages.getString("NewClassWizardPage.getProjectClasses.noclasses.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)string, (String)string2);
            return null;
        }
        BaseClassSelectionDialog baseClassSelectionDialog = new BaseClassSelectionDialog(this.getShell());
        baseClassSelectionDialog.setElements(objectArray);
        int n = baseClassSelectionDialog.open();
        if (n != 0) {
            return null;
        }
        return (ITypeInfo)baseClassSelectionDialog.getFirstResult();
    }

    public String getNewClassName() {
        return this.fClassNameDialogField.getText();
    }

    public String getBaseClassName() {
        return this.fBaseClassDialogField.getText();
    }

    public boolean isIncludeGuard() {
        return this.fConstDestButtons.isSelected(2);
    }

    public boolean isVirtualDestructor() {
        return this.fConstDestButtons.isSelected(1);
    }

    public boolean isInline() {
        return this.fConstDestButtons.isSelected(0);
    }

    public String getAccess() {
        if (this.fAccessButtons.isSelected(0)) {
            return "public";
        }
        if (this.fAccessButtons.isSelected(1)) {
            return "protected";
        }
        if (this.fAccessButtons.isSelected(2)) {
            return "private";
        }
        return "";
    }

    public ITranslationUnit getCreatedClassHeaderFile() {
        return this.parentHeaderTU;
    }

    public ITranslationUnit getCreatedClassBodyFile() {
        return this.parentBodyTU;
    }

    public ICElement getCreatedClassElement() {
        return this.createdClass;
    }

    public IStructure getBaseClassElement() {
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createClass(IProgressMonitor iProgressMonitor) {
        block20: {
            Object var8_12;
            IRunnableWithProgress iRunnableWithProgress;
            Object object;
            Object object2;
            block19: {
                if (iProgressMonitor == null) {
                    iProgressMonitor = new NullProgressMonitor();
                }
                iProgressMonitor.beginTask(NewWizardMessages.getString("NewTypeWizardPage.operationdesc"), 10);
                String string = this.getBaseClassName();
                ITypeInfo iTypeInfo = null;
                if (string != null && string.length() > 0 && (iTypeInfo = this.findInList((ITypeInfo[])(object2 = this.findClassElementsInProject()), (IQualifiedTypeName)new QualifiedTypeName(string))) != null && iTypeInfo.getResolvedReference() == null) {
                    object = new ITypeInfo[]{iTypeInfo};
                    iRunnableWithProgress = new IRunnableWithProgress((ITypeInfo[])object){
                        private final /* synthetic */ ITypeInfo[] val$typesToResolve;
                        {
                            this.val$typesToResolve = iTypeInfoArray;
                        }

                        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                            AllTypesCache.resolveTypeLocation((ITypeInfo)this.val$typesToResolve[0], (IProgressMonitor)iProgressMonitor);
                            if (iProgressMonitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                        }
                    };
                    try {
                        this.getContainer().run(true, true, iRunnableWithProgress);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        String string2 = NewWizardMessages.getString("NewClassWizardPage.getProjectClasses.exception.title");
                        String string3 = NewWizardMessages.getString("NewClassWizardPage.getProjectClasses.exception.message");
                        ExceptionHandler.handle(invocationTargetException, string2, string3);
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                        return false;
                    }
                }
                object2 = null;
                object2 = System.getProperty("line.separator", "\n");
                this.parentHeaderTU = this.createTranslationUnit(this.linkedResourceGroupForHeader, true);
                this.parentBodyTU = this.createTranslationUnit(this.linkedResourceGroupForBody, false);
                iProgressMonitor.worked(1);
                if (this.parentHeaderTU != null && !this.parentHeaderTU.isReadOnly()) {
                    object = this.constructHeaderFileContent(this.parentHeaderTU, (String)object2, iTypeInfo);
                    iRunnableWithProgress = null;
                    try {
                        try {
                            iRunnableWithProgress = this.parentHeaderTU.getSharedWorkingCopy(null, CUIPlugin.getDefault().getBufferFactory());
                            iRunnableWithProgress.getBuffer().append((String)object);
                            iRunnableWithProgress.reconcile();
                            iRunnableWithProgress.commit(true, iProgressMonitor);
                            this.createdClass = iRunnableWithProgress.getElement(this.getNewClassName());
                        }
                        catch (CModelException cModelException) {
                            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)NewWizardMessages.getString("WizardNewFileCreationPage.internalErrorTitle"), (String)cModelException.getMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        if (iRunnableWithProgress != null) {
                            iRunnableWithProgress.destroy();
                        }
                        throw throwable;
                    }
                    {
                        var8_12 = null;
                        if (iRunnableWithProgress == null) break block19;
                    }
                    iRunnableWithProgress.destroy();
                }
            }
            if (this.parentBodyTU != null && !this.parentBodyTU.isReadOnly()) {
                object = this.constructBodyFileContent((String)object2);
                iRunnableWithProgress = null;
                try {
                    try {
                        iRunnableWithProgress = this.parentBodyTU.getSharedWorkingCopy(null, CUIPlugin.getDefault().getBufferFactory());
                        iRunnableWithProgress.getBuffer().append((String)object);
                        iRunnableWithProgress.reconcile();
                        iRunnableWithProgress.commit(true, iProgressMonitor);
                    }
                    catch (CModelException cModelException) {
                        MessageDialog.openError((Shell)this.getContainer().getShell(), (String)NewWizardMessages.getString("WizardNewFileCreationPage.internalErrorTitle"), (String)cModelException.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    var8_12 = null;
                    if (iRunnableWithProgress != null) {
                        iRunnableWithProgress.destroy();
                    }
                    throw throwable;
                }
                {
                    var8_12 = null;
                    if (iRunnableWithProgress == null) break block20;
                }
                iRunnableWithProgress.destroy();
            }
        }
        iProgressMonitor.done();
        return true;
    }

    protected ITranslationUnit createTranslationUnit(LinkToFileGroup linkToFileGroup, boolean bl) {
        ICElement iCElement;
        ITranslationUnit iTranslationUnit = null;
        IFile iFile = null;
        iFile = this.createNewFile(linkToFileGroup, bl);
        if (iFile != null && (iCElement = CoreModel.getDefault().create(iFile)) instanceof ITranslationUnit) {
            iTranslationUnit = (ITranslationUnit)iCElement;
        }
        return iTranslationUnit;
    }

    protected IFile createNewFile(LinkToFileGroup linkToFileGroup, boolean bl) {
        final IFile iFile = this.createFileHandle(linkToFileGroup, bl);
        if (iFile.exists()) {
            return iFile;
        }
        final IPath iPath = this.getContainerFullPath(linkToFileGroup);
        final boolean bl2 = linkToFileGroup.linkCreated();
        final IPath iPath2 = this.getContainerPath(linkToFileGroup);
        final InputStream inputStream = this.getInitialContents();
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
                try {
                    iProgressMonitor.beginTask(NewWizardMessages.getString("WizardNewFileCreationPage.progress"), 2000);
                    if (!NewClassWizardPage.this.containerExists(iPath2)) {
                        ContainerGenerator containerGenerator = new ContainerGenerator(iPath2);
                        containerGenerator.generateContainer((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                    }
                    NewClassWizardPage.this.createFile(iFile, inputStream, iPath, bl2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                iProgressMonitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)NewWizardMessages.getString("WizardNewFileCreationPage.errorTitle"), null, (IStatus)((CoreException)invocationTargetException.getTargetException()).getStatus());
            } else {
                CUIPlugin.getDefault().logErrorMessage(MessageFormat.format("Exception in {0}.getNewFile(): {1}", ((Object)((Object)this)).getClass().getName(), invocationTargetException.getTargetException()));
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)NewWizardMessages.getString("WizardNewFileCreationPage.internalErrorTitle"), (String)MessageFormat.format("WizardNewFileCreationPage.internalErrorMessage", invocationTargetException.getTargetException().getMessage()));
            }
            return null;
        }
        return iFile;
    }

    protected IFile createFileHandle(LinkToFileGroup linkToFileGroup, boolean bl) {
        IPath iPath;
        IWorkspaceRoot iWorkspaceRoot = CUIPlugin.getWorkspace().getRoot();
        IFile iFile = iWorkspaceRoot.getFileForLocation(iPath = this.getContainerFullPath(linkToFileGroup));
        if (iFile == null) {
            iFile = iWorkspaceRoot.getFile(iPath);
        }
        return iFile;
    }

    protected void createFile(IFile iFile, InputStream inputStream, IPath iPath, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        if (inputStream == null) {
            inputStream = new ByteArrayInputStream(new byte[0]);
        }
        try {
            if (bl) {
                iFile.createLink(iPath, 16, iProgressMonitor);
            } else {
                iFile.create(inputStream, false, iProgressMonitor);
            }
        }
        catch (CoreException coreException) {
            if (coreException.getStatus().getCode() == 374) {
                iFile.refreshLocal(0, null);
            }
            throw coreException;
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IPath getContainerPath(LinkToFileGroup linkToFileGroup) {
        if (linkToFileGroup.linkCreated()) {
            String string = linkToFileGroup.getResolvedPath();
            if (string == null || string.length() < 1) {
                return null;
            }
            Path path = new Path(string);
            return path.removeLastSegments(1).removeTrailingSeparator().makeAbsolute();
        }
        return this.defaultSourceFolder;
    }

    protected IPath getContainerFullPath(LinkToFileGroup linkToFileGroup) {
        if (linkToFileGroup.linkCreated()) {
            String string = linkToFileGroup.getResolvedPath();
            if (string == null || string.length() < 1) {
                return null;
            }
            return new Path(string).makeAbsolute();
        }
        String string = linkToFileGroup.getText();
        IPath iPath = this.defaultSourceFolder;
        iPath.addTrailingSeparator();
        return iPath.append(string).makeAbsolute();
    }

    protected IPath getHeaderFullPath() {
        String string = String.valueOf(this.getNewClassName()) + ".h";
        IPath iPath = this.defaultSourceFolder;
        return iPath.append(string).makeAbsolute();
    }

    protected IPath getBodyFullPath() {
        String string = String.valueOf(this.getNewClassName()) + ".cpp";
        IPath iPath = this.defaultSourceFolder;
        return iPath.append(string).makeAbsolute();
    }

    protected boolean containerExists(IPath iPath) {
        IContainer iContainer = null;
        IWorkspaceRoot iWorkspaceRoot = CUIPlugin.getWorkspace().getRoot();
        iContainer = iWorkspaceRoot.getContainerForLocation(iPath);
        return iContainer != null;
    }

    protected InputStream getInitialContents() {
        return null;
    }

    protected String getClassComment(ITranslationUnit iTranslationUnit) {
        if (PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.javadoc")) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getNewClassName());
                String string = CodeGeneration.getClassComment(iTranslationUnit, stringBuffer.toString(), String.valueOf('\n'));
                if (string != null && this.isValidComment(string)) {
                    return string;
                }
            }
            catch (CoreException coreException) {
                CUIPlugin.getDefault().log(coreException);
            }
        }
        return null;
    }

    protected String constructHeaderFileContent(ITranslationUnit iTranslationUnit, String string, ITypeInfo iTypeInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        String string2 = this.getBaseClassName();
        String string3 = "";
        boolean bl2 = false;
        if (iTypeInfo != null) {
            bl = true;
            ITypeReference iTypeReference = iTypeInfo.getResolvedReference();
            if (iTypeReference != null) {
                IPath iPath = this.fSelectedProject.getFullPath();
                IPath iPath2 = iTypeReference.getRelativeIncludePath(this.fSelectedProject);
                if (!iPath2.equals((Object)iTypeReference.getLocation())) {
                    if (!iPath.isPrefixOf(iTypeReference.getPath())) {
                        bl2 = true;
                    }
                } else if (iPath.isPrefixOf(iTypeReference.getPath()) && iPath.isPrefixOf(iTranslationUnit.getPath())) {
                    iPath2 = iTypeReference.getRelativePath(iTranslationUnit.getPath());
                }
                string3 = iPath2.toString();
            }
        }
        if (string3.length() == 0) {
            string3 = String.valueOf(string2) + ".h";
        }
        if (this.isIncludeGuard()) {
            stringBuffer.append("#ifndef ");
            stringBuffer.append(this.getNewClassName().toUpperCase());
            stringBuffer.append("_H");
            stringBuffer.append(string);
            stringBuffer.append("#define ");
            stringBuffer.append(this.getNewClassName().toUpperCase());
            stringBuffer.append("_H");
            stringBuffer.append(string);
            stringBuffer.append(string);
        }
        if (bl && !iTranslationUnit.getElementName().equals(string3)) {
            stringBuffer.append("#include ");
            if (bl2) {
                stringBuffer.append('<');
            } else {
                stringBuffer.append('\"');
            }
            stringBuffer.append(string3);
            if (bl2) {
                stringBuffer.append('>');
            } else {
                stringBuffer.append('\"');
            }
            stringBuffer.append(string);
            stringBuffer.append(string);
        }
        stringBuffer.append("class ");
        stringBuffer.append(this.getNewClassName());
        if (bl) {
            stringBuffer.append(" : ");
            stringBuffer.append(this.getAccess());
            stringBuffer.append(" ");
            stringBuffer.append(string2);
        }
        stringBuffer.append("{");
        stringBuffer.append(string);
        stringBuffer.append("public:");
        stringBuffer.append(string);
        stringBuffer.append(string);
        stringBuffer.append('\t');
        stringBuffer.append(this.getNewClassName());
        stringBuffer.append("()");
        if (this.isInline()) {
            stringBuffer.append(" {}");
            stringBuffer.append(string);
        } else {
            stringBuffer.append(";");
            stringBuffer.append(string);
        }
        stringBuffer.append('\t');
        if (this.isVirtualDestructor()) {
            stringBuffer.append("virtual ");
        }
        stringBuffer.append("~");
        stringBuffer.append(this.getNewClassName());
        stringBuffer.append("()");
        if (this.isInline()) {
            stringBuffer.append(" {}");
            stringBuffer.append(string);
        } else {
            stringBuffer.append(";");
            stringBuffer.append(string);
        }
        stringBuffer.append("};");
        stringBuffer.append(string);
        if (this.isIncludeGuard()) {
            stringBuffer.append(string);
            stringBuffer.append("#endif // ");
            stringBuffer.append(this.getNewClassName().toUpperCase());
            stringBuffer.append("_H");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    protected String constructBodyFileContent(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getCreatedClassHeaderFile() != null) {
            stringBuffer.append("#include \"");
            stringBuffer.append(this.getCreatedClassHeaderFile().getElementName());
        }
        stringBuffer.append("\"");
        stringBuffer.append(string);
        stringBuffer.append(string);
        if (this.isInline()) {
            return stringBuffer.toString();
        }
        stringBuffer.append(this.getNewClassName());
        stringBuffer.append("::");
        stringBuffer.append(this.getNewClassName());
        stringBuffer.append("()");
        stringBuffer.append(string);
        stringBuffer.append("{}");
        stringBuffer.append(string);
        stringBuffer.append(this.getNewClassName());
        stringBuffer.append("::~");
        stringBuffer.append(this.getNewClassName());
        stringBuffer.append("()");
        stringBuffer.append(string);
        stringBuffer.append("{}");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected void doStatusUpdate() {
        IStatus[] iStatusArray = new IStatus[]{this.fClassNameStatus, this.fBaseClassStatus, this.fLinkedResourceGroupForHeaderStatus, this.fLinkedResourceGroupForBodyStatus};
        this.updateStatus(iStatusArray);
    }

    protected void updateStatus(IStatus[] iStatusArray) {
        this.updateStatus(StatusUtil.getMostSevere(iStatusArray));
    }

    protected void updateStatus(IStatus iStatus) {
        this.fCurrStatus = iStatus;
        this.setPageComplete(!iStatus.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, iStatus);
    }

    protected boolean isValidComment(String string) {
        return true;
    }

    protected IStatus classNameChanged() {
        QualifiedTypeName qualifiedTypeName;
        ITypeInfo[] iTypeInfoArray;
        StatusInfo statusInfo = new StatusInfo();
        String string = this.getNewClassName();
        if (string.length() == 0) {
            statusInfo.setError(NewWizardMessages.getString("NewClassWizardPage.error.EnterClassName"));
            return statusInfo;
        }
        if (string.indexOf("::") != -1) {
            statusInfo.setError(NewWizardMessages.getString("NewClassWizardPage.error.QualifiedName"));
            return statusInfo;
        }
        IStatus iStatus = CConventions.validateClassName((String)string);
        if (iStatus.getSeverity() == 4) {
            statusInfo.setError(NewWizardMessages.getFormattedString("NewClassWizardPage.error.InvalidClassName", iStatus.getMessage()));
            return statusInfo;
        }
        if (iStatus.getSeverity() == 2) {
            statusInfo.setWarning(NewWizardMessages.getFormattedString("NewClassWizardPage.warning.ClassNameDiscouraged", iStatus.getMessage()));
        }
        if (this.foundInList(iTypeInfoArray = this.findClassElementsInProject(), (IQualifiedTypeName)(qualifiedTypeName = new QualifiedTypeName(this.getNewClassName())))) {
            statusInfo.setError(NewWizardMessages.getString("NewClassWizardPage.error.ClassNameExists"));
        }
        return statusInfo;
    }

    protected IStatus baseClassNameChanged() {
        String string = this.getBaseClassName();
        StatusInfo statusInfo = new StatusInfo();
        if (string.length() == 0) {
            return statusInfo;
        }
        IStatus iStatus = CConventions.validateClassName((String)string);
        if (iStatus.getSeverity() == 4) {
            statusInfo.setError(NewWizardMessages.getString("NewClassWizardPage.error.InvalidBaseClassName"));
            return statusInfo;
        }
        ITypeInfo[] iTypeInfoArray = this.findClassElementsInProject();
        if (!this.foundInList(iTypeInfoArray, (IQualifiedTypeName)new QualifiedTypeName(string))) {
            statusInfo.setWarning(NewWizardMessages.getString("NewClassWizardPage.warning.BaseClassNotExists"));
        }
        return statusInfo;
    }

    private boolean foundInList(ITypeInfo[] iTypeInfoArray, IQualifiedTypeName iQualifiedTypeName) {
        return this.findInList(iTypeInfoArray, iQualifiedTypeName) != null;
    }

    private ITypeInfo findInList(ITypeInfo[] iTypeInfoArray, IQualifiedTypeName iQualifiedTypeName) {
        if (iTypeInfoArray == null || iTypeInfoArray.length == 0) {
            return null;
        }
        UnknownTypeInfo unknownTypeInfo = new UnknownTypeInfo(iQualifiedTypeName);
        int n = Arrays.binarySearch(iTypeInfoArray, unknownTypeInfo, this.TYPE_NAME_COMPARATOR);
        if (n >= 0 && n < iTypeInfoArray.length) {
            ITypeInfo iTypeInfo;
            int n2 = n - 1;
            while (n2 >= 0) {
                iTypeInfo = iTypeInfoArray[n2];
                if (!unknownTypeInfo.getName().equals(iTypeInfo.getName())) break;
                if (unknownTypeInfo.getQualifiedTypeName().equals(iTypeInfo.getQualifiedTypeName())) {
                    return iTypeInfo;
                }
                --n2;
            }
            n2 = n;
            while (n2 < iTypeInfoArray.length) {
                iTypeInfo = iTypeInfoArray[n2];
                if (!unknownTypeInfo.getName().equals(iTypeInfo.getName())) break;
                if (unknownTypeInfo.getQualifiedTypeName().equals(iTypeInfo.getQualifiedTypeName())) {
                    return iTypeInfo;
                }
                ++n2;
            }
        }
        return null;
    }

    private class TypeFieldsAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        TypeFieldsAdapter() {
        }

        public void changeControlPressed(DialogField dialogField) {
            NewClassWizardPage.this.classPageChangeControlPressed(dialogField);
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            NewClassWizardPage.this.classPageCustomButtonPressed(listDialogField, n);
        }

        public void selectionChanged(ListDialogField listDialogField) {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            NewClassWizardPage.this.classPageDialogFieldChanged(dialogField);
        }

        public void doubleClicked(ListDialogField listDialogField) {
        }
    }
}

