/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards.conversion;

import java.util.Vector;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.conversion.ConversionWizard;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public abstract class ConvertProjectWizardPage
extends WizardPage {
    public static final String KEY_TITLE = "ConvertionWizard.title";
    public static final String KEY_CONVERTING = "ConvertionWizard.converting";
    private static final String PROJECT_LIST = "ConversionWizard.projectlist";
    protected boolean convertToC = false;
    protected boolean convertToCC = true;
    protected Button cRadioButton;
    protected Button ccRadioButton;
    protected CheckboxTableViewer tableViewer;
    protected Button selectAllButton;
    protected Button deselectAllButton;
    protected Object[] listItems = null;

    public ConvertProjectWizardPage(String string) {
        super(string);
        this.setTitle(this.getWzTitleResource());
        this.setDescription(this.getWzDescriptionResource());
    }

    protected abstract String getWzTitleResource();

    protected abstract String getWzDescriptionResource();

    protected Object[] getCheckedElements() {
        return this.tableViewer.getCheckedElements();
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.setControl((Control)this.createAvailableProjectsGroup(composite2));
        this.addToMainPage(composite2);
        this.setPageComplete(this.validatePage());
    }

    protected void addToMainPage(Composite composite) {
        Group group = ControlFactory.createGroup(composite, CUIMessages.getString("ConvertProjectWizardPage.convertTo"), 2);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConvertProjectWizardPage.this.convertToC = ConvertProjectWizardPage.this.cRadioButton.getSelection();
                ConvertProjectWizardPage.this.convertToCC = ConvertProjectWizardPage.this.ccRadioButton.getSelection();
                ConvertProjectWizardPage.this.validatePage();
            }
        };
        this.cRadioButton = ControlFactory.createRadioButton((Composite)group, CUIMessages.getString("ConvertProjectWizardPage.CProject"), "C ", (SelectionListener)selectionAdapter);
        this.cRadioButton.setSelection(this.convertToC);
        this.ccRadioButton = ControlFactory.createRadioButton((Composite)group, CUIMessages.getString("ConvertProjectWizardPage.CppProject"), "C++", (SelectionListener)selectionAdapter);
        this.ccRadioButton.setSelection(this.convertToCC);
        group.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ConvertProjectWizardPage.this.cRadioButton = null;
                ConvertProjectWizardPage.this.ccRadioButton = null;
            }
        });
    }

    private final Composite createAvailableProjectsGroup(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(CUIPlugin.getResourceString(PROJECT_LIST));
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        Table table = new Table(composite2, 2854);
        gridData = new GridData(1808);
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        TableLayout tableLayout = new TableLayout();
        table.setHeaderVisible(false);
        table.setLayout((Layout)tableLayout);
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.tableViewer.setInput((Object)this.getElements());
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof IProject && object2 instanceof IProject) {
                    IProject iProject = (IProject)object;
                    IProject iProject2 = (IProject)object2;
                    int n = iProject.getName().compareToIgnoreCase(iProject2.getName());
                    if (n != 0) {
                        return n;
                    }
                    return iProject.getName().compareToIgnoreCase(iProject2.getName());
                }
                return super.compare(viewer, object, object2);
            }

            public boolean isSorterProperty(Object object, String string) {
                return true;
            }
        });
        this.tableViewer.setAllChecked(false);
        this.tableViewer.refresh();
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ConvertProjectWizardPage.this.setPageComplete(ConvertProjectWizardPage.this.validatePage());
                ConvertProjectWizardPage.this.updateSelectionButtons();
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(2));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 8;
        composite3.setLayout((Layout)gridLayout);
        this.selectAllButton = new Button(composite3, 8);
        this.selectAllButton.setText(CUIMessages.getString("ConvertProjectWizardPage.SelectAll"));
        this.selectAllButton.setLayoutData((Object)ConvertProjectWizardPage.getButtonGridData(this.selectAllButton));
        this.selectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ConvertProjectWizardPage.this.tableViewer.setAllChecked(true);
                ConvertProjectWizardPage.this.setPageComplete(true);
                ConvertProjectWizardPage.this.updateSelectionButtons();
            }
        });
        this.deselectAllButton = new Button(composite3, 8);
        this.deselectAllButton.setText(CUIMessages.getString("ConvertProjectWizardPage.DeselectAll"));
        this.deselectAllButton.setLayoutData((Object)ConvertProjectWizardPage.getButtonGridData(this.deselectAllButton));
        this.deselectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ConvertProjectWizardPage.this.tableViewer.setAllChecked(false);
                ConvertProjectWizardPage.this.setPageComplete(false);
                ConvertProjectWizardPage.this.updateSelectionButtons();
            }
        });
        Object[] objectArray = this.getElements();
        boolean bl = objectArray != null && objectArray.length > 0;
        this.selectAllButton.setEnabled(bl);
        this.deselectAllButton.setEnabled(false);
        return composite;
    }

    protected void updateSelectionButtons() {
        int n;
        Object[] objectArray = this.getCheckedElements();
        boolean bl = objectArray.length == (n = this.tableViewer.getTable().getItemCount());
        boolean bl2 = objectArray.length == 0;
        this.selectAllButton.setEnabled(!bl);
        this.deselectAllButton.setEnabled(!bl2);
    }

    private static GridData getButtonGridData(Button button) {
        GridData gridData = new GridData(768);
        gridData.widthHint = SWTUtil.getButtonWidthHint(button);
        gridData.heightHint = SWTUtil.getButtonHeigthHint(button);
        return gridData;
    }

    protected boolean validatePage() {
        Object[] objectArray = this.getCheckedElements();
        return objectArray != null && objectArray.length > 0;
    }

    protected Object[] getElements() {
        IWorkspace iWorkspace = CUIPlugin.getWorkspace();
        IProject[] iProjectArray = iWorkspace.getRoot().getProjects();
        Vector<IProject> vector = new Vector<IProject>(iProjectArray.length);
        IProject iProject = null;
        int n = 0;
        while (n < iProjectArray.length) {
            iProject = iProjectArray[n];
            if (iProject != null && iProject.isOpen() && this.isCandidate(iProject)) {
                vector.addElement(iProject);
            }
            iProject = null;
            ++n;
        }
        Object[] objectArray = null;
        if (vector.size() > 0) {
            objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
        }
        this.listItems = objectArray;
        return objectArray;
    }

    public void doRun(IProgressMonitor iProgressMonitor, String string) throws CoreException {
        Object[] objectArray = this.getCheckedElements();
        int n = objectArray.length;
        if (objectArray != null && n > 0) {
            if (iProgressMonitor == null) {
                iProgressMonitor = new NullProgressMonitor();
            }
            iProgressMonitor.beginTask(CUIPlugin.getResourceString(KEY_TITLE), 1);
            this.convertProjects(objectArray, iProgressMonitor, string);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void convertProjects(Object[] objectArray, IProgressMonitor iProgressMonitor, String string) throws CoreException {
        iProgressMonitor.beginTask(CUIPlugin.getResourceString(KEY_CONVERTING), objectArray.length);
        try {
            int n = 0;
            while (n < objectArray.length) {
                IProject iProject = (IProject)objectArray[n];
                this.convertProject(iProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), string);
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        iProgressMonitor.done();
    }

    public boolean finish() {
        return true;
    }

    public abstract boolean isCandidate(IProject var1);

    public void convertProject(IProject iProject, IProgressMonitor iProgressMonitor, String string) throws CoreException {
        if (this.convertToC) {
            if (!iProject.hasNature("org.eclipse.cdt.core.cnature")) {
                this.addCNature(iProject, iProgressMonitor, true);
            } else if (iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                CCProjectNature.removeCCNature((IProject)iProject, (IProgressMonitor)iProgressMonitor);
            }
        } else if (this.convertToCC && !iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
            this.addCCNature(iProject, iProgressMonitor, true);
        }
    }

    protected void addCNature(IProject iProject, IProgressMonitor iProgressMonitor, boolean bl) throws CoreException {
        if (this.getWizard() instanceof ConversionWizard) {
            CCorePlugin.getDefault().convertProjectToC(iProject, iProgressMonitor, ((ConversionWizard)this.getWizard()).getProjectID());
        }
    }

    protected void addCCNature(IProject iProject, IProgressMonitor iProgressMonitor, boolean bl) throws CoreException {
        if (this.getWizard() instanceof ConversionWizard) {
            if (iProject.hasNature("org.eclipse.cdt.core.cnature")) {
                CCorePlugin.getDefault().convertProjectFromCtoCC(iProject, iProgressMonitor);
            } else {
                CCorePlugin.getDefault().convertProjectToCC(iProject, iProgressMonitor, ((ConversionWizard)this.getWizard()).getProjectID());
            }
        }
    }

    public class ProjectContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object object) {
            return ConvertProjectWizardPage.this.listItems;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    public class ProjectLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object object, int n) {
            if (n == 0) {
                return ((IProject)object).getName();
            }
            return "";
        }

        public Image getColumnImage(Object object, int n) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }
    }
}

