/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.ui.controls;

import java.util.StringTokenizer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ControlFactory {
    public static Control setParentColors(Control control) {
        Composite composite = control.getParent();
        control.setBackground(composite.getBackground());
        control.setForeground(composite.getForeground());
        return control;
    }

    public static Composite createComposite(Composite composite, int n) {
        return ControlFactory.createCompositeEx(composite, n, 768);
    }

    public static Composite createCompositeEx(Composite composite, int n, int n2) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(n, true));
        composite2.setLayoutData((Object)new GridData(n2));
        return composite2;
    }

    public static Composite createCompositeSeparator(Composite composite, Color color, int n) {
        Composite composite2 = ControlFactory.createComposite(composite, 1);
        GridData gridData = (GridData)composite2.getLayoutData();
        gridData.heightHint = -1 == n ? 2 : n;
        composite2.setLayoutData((Object)gridData);
        composite2.setBackground(color);
        return composite2;
    }

    public static Label createSeparator(Composite composite, int n) {
        Label label = new Label(composite, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public static Control createEmptySpace(Composite composite) {
        return ControlFactory.createEmptySpace(composite, 1);
    }

    public static Control createEmptySpace(Composite composite, int n) {
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalSpan = n;
        gridData.horizontalIndent = 0;
        gridData.widthHint = 0;
        gridData.heightHint = 0;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public static Label createLabel(Composite composite, String string, int n, int n2, int n3) {
        Label label = new Label(composite, n3);
        label.setText(string);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.widthHint = n;
        gridData.heightHint = n2;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public static Label createLabel(Composite composite, String string) {
        return ControlFactory.createLabel(composite, string, -1, -1, 16384);
    }

    public static Label createBoldLabel(Composite composite, String string) {
        Label label = ControlFactory.createLabel(composite, string);
        FontData[] fontDataArray = label.getFont().getFontData();
        fontDataArray[0].setStyle(1);
        Font font = new Font((Device)Display.getCurrent(), fontDataArray[0]);
        label.setFont(font);
        return label;
    }

    public static Label createWrappedLabel(Composite composite, String string, int n, int n2) {
        return ControlFactory.createLabel(composite, string, n, n2, 16448);
    }

    public static Button createCheckBox(Composite composite, String string) {
        Button button = new Button(composite, 16416);
        button.setText(string);
        GridData gridData = new GridData();
        button.setLayoutData((Object)gridData);
        button.setBackground(composite.getBackground());
        button.setForeground(composite.getForeground());
        return button;
    }

    public static Button createCheckBoxEx(Composite composite, String string, int n) {
        Button button = new Button(composite, 0x20 | n);
        button.setText(string);
        GridData gridData = new GridData();
        button.setLayoutData((Object)gridData);
        button.setBackground(composite.getBackground());
        button.setForeground(composite.getForeground());
        return button;
    }

    public static Button createRadioButton(Composite composite, String string, String string2, SelectionListener selectionListener) {
        Button button = new Button(composite, 16400);
        button.setText(string);
        button.setData((Object)(string2 == null ? string : string2));
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        button.setLayoutData((Object)gridData);
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        return button;
    }

    public static Button createPushButton(Composite composite, String string) {
        Button button = new Button(composite, 8);
        button.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        return button;
    }

    public static Text createTextField(Composite composite) {
        return ControlFactory.createTextField(composite, 2052);
    }

    public static Text createTextField(Composite composite, int n) {
        Text text = new Text(composite, n);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)gridData);
        return text;
    }

    public static Group createGroup(Composite composite, String string, int n) {
        Group group = new Group(composite, 0);
        group.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        return group;
    }

    public static List createList(Composite composite, String string, String string2) {
        List list = new List(composite, 4);
        GridData gridData = new GridData();
        list.setLayoutData((Object)gridData);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            list.add(stringTokenizer.nextToken());
        }
        if (string2 == null) {
            if (list.getItemCount() > 0) {
                list.select(0);
            }
        } else {
            ControlFactory.selectList(list, string2);
        }
        return list;
    }

    public static void selectList(List list, String string) {
        int n = list.indexOf(string);
        if (n < 0) {
            n = 0;
        }
        list.select(n);
    }

    public static TableViewer createTableViewer(Composite composite, String[] stringArray, int n, int n2, int n3) {
        TableViewer tableViewer = new TableViewer(composite, 0x800 | n3);
        GridData gridData = new GridData(1808);
        gridData.widthHint = n;
        gridData.heightHint = n2;
        tableViewer.getTable().setLayoutData((Object)gridData);
        if (stringArray != null) {
            tableViewer.add((Object[])stringArray);
        }
        return tableViewer;
    }

    public static TableViewer createTableViewer(Composite composite, int n, int n2, int n3, String[] stringArray, int[] nArray) {
        TableViewer tableViewer = ControlFactory.createTableViewer(composite, null, n, n2, n3);
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        int n4 = 0;
        while (n4 < stringArray.length) {
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(stringArray[n4]);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(nArray[n4], true));
            ++n4;
        }
        table.setLayout((Layout)tableLayout);
        return tableViewer;
    }

    public static void deactivateCellEditor(TableViewer tableViewer) {
        if (tableViewer == null) {
            return;
        }
        CellEditor[] cellEditorArray = tableViewer.getCellEditors();
        TableItem[] tableItemArray = tableViewer.getTable().getSelection();
        if (tableItemArray.length >= 0) {
            int n = 0;
            while (n < cellEditorArray.length) {
                CellEditor cellEditor = cellEditorArray[n];
                if (cellEditor.isActivated()) {
                    if (cellEditor.isValueValid()) {
                        Object[] objectArray = tableViewer.getColumnProperties();
                        Object object = cellEditor.getValue();
                        tableViewer.cancelEditing();
                        tableViewer.getCellModifier().modify((Object)tableItemArray[0], (String)objectArray[n], object);
                        break;
                    }
                    tableViewer.cancelEditing();
                    break;
                }
                ++n;
            }
        }
    }

    public static CheckboxTableViewer createListViewer(Composite composite, String[] stringArray, int n, int n2, int n3) {
        Table table = new Table(composite, 2080);
        CheckboxTableViewer checkboxTableViewer = new CheckboxTableViewer(table);
        GridData gridData = new GridData(n3);
        gridData.widthHint = n;
        gridData.heightHint = n2;
        checkboxTableViewer.getTable().setLayoutData((Object)gridData);
        if (stringArray != null) {
            checkboxTableViewer.add((Object[])stringArray);
        }
        return checkboxTableViewer;
    }

    public static CheckboxTableViewer createListViewer(Composite composite, int n, int n2, int n3, String[] stringArray, int[] nArray) {
        CheckboxTableViewer checkboxTableViewer = ControlFactory.createListViewer(composite, null, n, n2, n3);
        Table table = checkboxTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn tableColumn = table.getColumn(0);
        tableColumn.setText(stringArray[0]);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(nArray[0], false));
        int n4 = 1;
        while (n4 < stringArray.length) {
            tableColumn = new TableColumn(table, 0);
            tableColumn.setText(stringArray[n4]);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(nArray[n4], false));
            ++n4;
        }
        return checkboxTableViewer;
    }

    public static CCombo createSelectCCombo(Composite composite, String string, String string2) {
        return ControlFactory.createSelectCCombo(composite, string, string2, 2056);
    }

    public static CCombo createSelectCCombo(Composite composite, String string, String string2, int n) {
        CCombo cCombo = new CCombo(composite, n);
        GridData gridData = new GridData(768);
        cCombo.setLayoutData((Object)gridData);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            cCombo.add(stringTokenizer.nextToken());
        }
        if (string2 == null || string2.length() == 0) {
            if (cCombo.getItemCount() > 0) {
                cCombo.select(0);
            }
        } else {
            ControlFactory.selectCCombo(cCombo, string2);
        }
        return cCombo;
    }

    public static CCombo createSelectCCombo(Composite composite, String[] stringArray, String string) {
        return ControlFactory.createSelectCCombo(composite, stringArray, string, 2060);
    }

    public static CCombo createSelectCCombo(Composite composite, String[] stringArray, String string, int n) {
        CCombo cCombo = new CCombo(composite, n);
        GridData gridData = new GridData(768);
        cCombo.setLayoutData((Object)gridData);
        int n2 = 0;
        while (n2 < stringArray.length) {
            cCombo.add(stringArray[n2]);
            ++n2;
        }
        if (string == null) {
            cCombo.select(0);
        } else {
            ControlFactory.selectCCombo(cCombo, string);
        }
        return cCombo;
    }

    public static void selectCCombo(CCombo cCombo, String string) {
        int n = cCombo.indexOf(string);
        if (n < 0) {
            n = 0;
        }
        cCombo.select(n);
    }

    public static Combo createSelectCombo(Composite composite, String string, String string2) {
        return ControlFactory.createSelectCombo(composite, string, string2, 2056);
    }

    public static Combo createSelectCombo(Composite composite, String string, String string2, int n) {
        Combo combo = new Combo(composite, n);
        GridData gridData = new GridData(768);
        combo.setLayoutData((Object)gridData);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            combo.add(stringTokenizer.nextToken());
        }
        if (string2 == null || string2.length() == 0) {
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        } else {
            ControlFactory.selectCombo(combo, string2);
        }
        return combo;
    }

    public static Combo createSelectCombo(Composite composite, String[] stringArray, String string) {
        return ControlFactory.createSelectCombo(composite, stringArray, string, 2060);
    }

    public static Combo createSelectCombo(Composite composite, String[] stringArray, String string, int n) {
        Combo combo = new Combo(composite, n);
        GridData gridData = new GridData(768);
        combo.setLayoutData((Object)gridData);
        int n2 = 0;
        while (n2 < stringArray.length) {
            combo.add(stringArray[n2]);
            ++n2;
        }
        if (string == null) {
            combo.select(0);
        } else {
            ControlFactory.selectCombo(combo, string);
        }
        return combo;
    }

    public static void selectCombo(Combo combo, String string) {
        int n = combo.indexOf(string);
        if (n < 0) {
            if ((combo.getStyle() & 8) == 0) {
                combo.setText(string);
                return;
            }
            n = 0;
        }
        combo.select(n);
    }

    public static Shell createDialogShell() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        return new Shell(shell, 2144);
    }

    public static Composite insertSpace(Composite composite, int n, int n2) {
        Composite composite2 = ControlFactory.createCompositeSeparator(composite, composite.getBackground(), -1 != n2 ? n2 : 5);
        ((GridData)composite2.getLayoutData()).horizontalSpan = n;
        return composite2;
    }

    public static MessageBox createDialog(String string, String string2, int n) {
        MessageBox messageBox = new MessageBox(ControlFactory.createDialogShell(), n | 0x10000);
        messageBox.setText(string);
        messageBox.setMessage(string2);
        return messageBox;
    }

    public static MessageBox createYesNoDialog(String string, String string2) {
        return ControlFactory.createDialog(string, string2, 196);
    }

    public static MessageBox createOkDialog(String string, String string2) {
        return ControlFactory.createDialog(string, string2, 34);
    }

    public static MessageBox createOkCancelDialog(String string, String string2) {
        return ControlFactory.createDialog(string, string2, 290);
    }
}

