/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.util.Map;
import org.eclipse.cdt.debug.core.ICBreakpointListener;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.swt.widgets.Display;

public class CBreakpointUpdater
implements ICBreakpointListener {
    private static CBreakpointUpdater fInstance;

    public static CBreakpointUpdater getInstance() {
        if (fInstance == null) {
            fInstance = new CBreakpointUpdater();
        }
        return fInstance;
    }

    public boolean installingBreakpoint(IDebugTarget iDebugTarget, IBreakpoint iBreakpoint) {
        return true;
    }

    public void breakpointInstalled(IDebugTarget iDebugTarget, final IBreakpoint iBreakpoint) {
        this.asyncExec(new Runnable(){

            public void run() {
                try {
                    if (((ICBreakpoint)iBreakpoint).incrementInstallCount() == 1) {
                        DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged(iBreakpoint);
                    }
                }
                catch (CoreException coreException) {
                    CDebugUIPlugin.log(coreException.getStatus());
                }
            }
        });
    }

    public void breakpointChanged(IDebugTarget iDebugTarget, final IBreakpoint iBreakpoint, final Map map) {
        this.asyncExec(new Runnable(){

            public void run() {
                try {
                    Boolean bl = (Boolean)map.get("org.eclipse.debug.core.enabled");
                    iBreakpoint.setEnabled(bl != null ? bl : false);
                    Integer n = (Integer)map.get("org.eclipse.cdt.debug.core.ignoreCount");
                    ((ICBreakpoint)iBreakpoint).setIgnoreCount(n != null ? n : 0);
                    String string = (String)map.get("org.eclipse.cdt.debug.core.condition");
                    ((ICBreakpoint)iBreakpoint).setCondition(string != null ? string : "");
                }
                catch (CoreException coreException) {
                    CDebugUIPlugin.log(coreException.getStatus());
                }
            }
        });
    }

    public void breakpointRemoved(IDebugTarget iDebugTarget, final IBreakpoint iBreakpoint) {
        this.asyncExec(new Runnable(){

            public void run() {
                try {
                    int n = ((ICBreakpoint)iBreakpoint).decrementInstallCount();
                    if (n == 0) {
                        iBreakpoint.delete();
                    }
                }
                catch (CoreException coreException) {}
            }
        });
    }

    public void dispose() {
    }

    private void asyncExec(Runnable runnable) {
        Display display = DebugUIPlugin.getStandardDisplay();
        if (display != null) {
            display.asyncExec(runnable);
        }
    }
}

