/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.CDebugUIMessages;
import org.eclipse.cdt.debug.internal.ui.OverlayImageCache;
import org.eclipse.cdt.debug.internal.ui.OverlayImageDescriptor;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;

public class CDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public static final String DISPLAY_FULL_PATHS = "DISPLAY_FULL_PATHS";
    protected HashMap fAttributes = new HashMap(3);
    protected CDebugImageDescriptorRegistry fDebugImageRegistry = CDebugUIPlugin.getImageDescriptorRegistry();
    private OverlayImageCache fImageCache = new OverlayImageCache();
    private static CDebugModelPresentation gfInstance = null;

    public static CDebugModelPresentation getDefault() {
        if (gfInstance == null) {
            gfInstance = new CDebugModelPresentation();
        }
        return gfInstance;
    }

    public void setAttribute(String string, Object object) {
        if (object == null) {
            return;
        }
        this.getAttributes().put(string, object);
    }

    public void computeDetail(IValue iValue, IValueDetailListener iValueDetailListener) {
    }

    public IEditorInput getEditorInput(Object object) {
        return null;
    }

    public String getEditorId(IEditorInput iEditorInput, Object object) {
        return null;
    }

    public Image getImage(Object object) {
        Image image = this.getBaseImage(object);
        if (image != null) {
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[4];
            return this.getImageCache().getImageFor(new OverlayImageDescriptor(image, imageDescriptorArray));
        }
        return this.getDefaultImage(object);
    }

    private Image getBaseImage(Object object) {
        if (object instanceof ICSharedLibrary) {
            return this.getSharedLibraryImage((ICSharedLibrary)object);
        }
        if (object instanceof IRegisterGroup) {
            return this.getRegisterGroupImage((IRegisterGroup)object);
        }
        if (object instanceof ICSignal) {
            return this.getSignalImage((ICSignal)object);
        }
        if (object instanceof ICBreakpoint) {
            return this.getBreakpointImage((ICBreakpoint)object);
        }
        return super.getImage(object);
    }

    protected Image getSharedLibraryImage(ICSharedLibrary iCSharedLibrary) {
        if (iCSharedLibrary.areSymbolsLoaded()) {
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[4];
            imageDescriptorArray[1] = CDebugImages.DESC_OVRS_SYMBOLS;
            return this.getImageCache().getImageFor(new OverlayImageDescriptor(this.getDebugImageRegistry().get(CDebugImages.DESC_OBJS_LOADED_SHARED_LIBRARY), imageDescriptorArray));
        }
        return CDebugUIPlugin.getImageDescriptorRegistry().get(CDebugImages.DESC_OBJS_SHARED_LIBRARY);
    }

    protected Image getSignalImage(ICSignal iCSignal) {
        return CDebugUIPlugin.getImageDescriptorRegistry().get(CDebugImages.DESC_OBJS_SIGNAL);
    }

    protected Image getRegisterGroupImage(IRegisterGroup iRegisterGroup) {
        return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_REGISTER_GROUP);
    }

    protected Image getBreakpointImage(ICBreakpoint iCBreakpoint) {
        try {
            if (iCBreakpoint instanceof ICLineBreakpoint) {
                return this.getLineBreakpointImage((ICLineBreakpoint)iCBreakpoint);
            }
            if (iCBreakpoint instanceof ICWatchpoint) {
                return this.getWatchpointImage((ICWatchpoint)iCBreakpoint);
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    protected Image getLineBreakpointImage(ICLineBreakpoint iCLineBreakpoint) throws CoreException {
        ImageDescriptor imageDescriptor = null;
        imageDescriptor = iCLineBreakpoint.isEnabled() ? CDebugImages.DESC_OBJS_BREAKPOINT_ENABLED : CDebugImages.DESC_OBJS_BREAKPOINT_DISABLED;
        return this.getImageCache().getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(imageDescriptor), this.computeBreakpointOverlays((ICBreakpoint)iCLineBreakpoint)));
    }

    protected Image getWatchpointImage(ICWatchpoint iCWatchpoint) throws CoreException {
        ImageDescriptor imageDescriptor = null;
        imageDescriptor = iCWatchpoint.isEnabled() ? (iCWatchpoint.isReadType() && !iCWatchpoint.isWriteType() ? CDebugImages.DESC_OBJS_READ_WATCHPOINT_ENABLED : (!iCWatchpoint.isReadType() && iCWatchpoint.isWriteType() ? CDebugImages.DESC_OBJS_WRITE_WATCHPOINT_ENABLED : CDebugImages.DESC_OBJS_WATCHPOINT_ENABLED)) : (iCWatchpoint.isReadType() && !iCWatchpoint.isWriteType() ? CDebugImages.DESC_OBJS_READ_WATCHPOINT_DISABLED : (!iCWatchpoint.isReadType() && iCWatchpoint.isWriteType() ? CDebugImages.DESC_OBJS_WRITE_WATCHPOINT_DISABLED : CDebugImages.DESC_OBJS_WATCHPOINT_DISABLED));
        return this.fImageCache.getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(imageDescriptor), this.computeBreakpointOverlays((ICBreakpoint)iCWatchpoint)));
    }

    public String getText(Object object) {
        StringBuffer stringBuffer = new StringBuffer(this.getBaseText(object));
        return stringBuffer.toString();
    }

    private String getBaseText(Object object) {
        boolean bl = this.isShowQualifiedNames();
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof ICSharedLibrary) {
            stringBuffer.append(this.getSharedLibraryText((ICSharedLibrary)object, bl));
            return stringBuffer.toString();
        }
        if (object instanceof IRegisterGroup) {
            stringBuffer.append(this.getRegisterGroupText((IRegisterGroup)object));
            return stringBuffer.toString();
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return this.getDefaultText(object);
    }

    protected String getSharedLibraryText(ICSharedLibrary iCSharedLibrary, boolean bl) {
        String string = new String();
        String string2 = iCSharedLibrary.getFileName();
        if (!this.isEmpty(string2)) {
            Path path = new Path(iCSharedLibrary.getFileName());
            if (!path.isEmpty()) {
                string = String.valueOf(string) + (bl ? path.toOSString() : path.lastSegment());
            }
        } else {
            string = String.valueOf(string) + CDebugUIMessages.getString("CDebugModelPresentation.unknown_1");
        }
        return string;
    }

    protected String getRegisterGroupText(IRegisterGroup iRegisterGroup) {
        String string = CDebugUIMessages.getString("CDebugModelPresentation.not_available_1");
        try {
            string = iRegisterGroup.getName();
        }
        catch (DebugException debugException) {
            CDebugUIPlugin.log(debugException.getStatus());
        }
        return string;
    }

    protected boolean isShowQualifiedNames() {
        Boolean bl = (Boolean)this.getAttributes().get(DISPLAY_FULL_PATHS);
        bl = bl == null ? Boolean.FALSE : bl;
        return bl;
    }

    private HashMap getAttributes() {
        return this.fAttributes;
    }

    private OverlayImageCache getImageCache() {
        return this.fImageCache;
    }

    private CDebugImageDescriptorRegistry getDebugImageRegistry() {
        return this.fDebugImageRegistry;
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    protected String getDefaultText(Object object) {
        return DebugUIPlugin.getDefaultLabelProvider().getText(object);
    }

    protected Image getDefaultImage(Object object) {
        return DebugUIPlugin.getDefaultLabelProvider().getImage(object);
    }

    private ImageDescriptor[] computeBreakpointOverlays(ICBreakpoint iCBreakpoint) {
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[4];
        try {
            if (iCBreakpoint.isConditional()) {
                ImageDescriptor imageDescriptor = imageDescriptorArray[0] = iCBreakpoint.isEnabled() ? CDebugImages.DESC_OVRS_BREAKPOINT_CONDITIONAL : CDebugImages.DESC_OVRS_BREAKPOINT_CONDITIONAL_DISABLED;
            }
            if (iCBreakpoint.isInstalled()) {
                ImageDescriptor imageDescriptor = imageDescriptorArray[2] = iCBreakpoint.isEnabled() ? CDebugImages.DESC_OVRS_BREAKPOINT_INSTALLED : CDebugImages.DESC_OVRS_BREAKPOINT_INSTALLED_DISABLED;
            }
            if (iCBreakpoint instanceof ICAddressBreakpoint) {
                ImageDescriptor imageDescriptor = imageDescriptorArray[1] = iCBreakpoint.isEnabled() ? CDebugImages.DESC_OVRS_ADDRESS_BREAKPOINT : CDebugImages.DESC_OVRS_ADDRESS_BREAKPOINT_DISABLED;
            }
            if (iCBreakpoint instanceof ICFunctionBreakpoint) {
                imageDescriptorArray[1] = iCBreakpoint.isEnabled() ? CDebugImages.DESC_OVRS_FUNCTION_BREAKPOINT : CDebugImages.DESC_OVRS_FUNCTION_BREAKPOINT_DISABLED;
            }
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.log(coreException);
        }
        return imageDescriptorArray;
    }
}

