/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;

public class CWatchExpressionDelegate
implements IWatchExpressionDelegate {
    public void evaluateExpression(final String string, IDebugElement iDebugElement, final IWatchExpressionListener iWatchExpressionListener) {
        if (!(iDebugElement instanceof ICStackFrame)) {
            iWatchExpressionListener.watchEvaluationFinished(null);
            return;
        }
        final ICStackFrame iCStackFrame = (ICStackFrame)iDebugElement;
        Runnable runnable = new Runnable(){

            public void run() {
                IValue iValue = null;
                DebugException debugException = null;
                try {
                    iValue = iCStackFrame.evaluateExpression(string);
                }
                catch (DebugException debugException2) {
                    debugException = debugException2;
                }
                IWatchExpressionResult iWatchExpressionResult = CWatchExpressionDelegate.this.evaluationComplete(string, iValue, debugException);
                iWatchExpressionListener.watchEvaluationFinished(iWatchExpressionResult);
            }
        };
        DebugPlugin.getDefault().asyncExec(runnable);
    }

    protected IWatchExpressionResult evaluationComplete(final String string, final IValue iValue, final DebugException debugException) {
        return new IWatchExpressionResult(){

            public IValue getValue() {
                return iValue;
            }

            public boolean hasErrors() {
                return debugException != null;
            }

            public String getExpressionText() {
                return string;
            }

            public DebugException getException() {
                return debugException;
            }

            public String[] getErrorMessages() {
                String[] stringArray;
                if (debugException != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = debugException.getMessage();
                } else {
                    stringArray = new String[]{};
                }
                return stringArray;
            }
        };
    }
}

